/*
 * Rahmenwerk-Plug-in "Maßstäbliche Darstellung"
 * Copyright (C) 2018 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.buv.plugin.netz.rdsmeldung;

import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.ui.PlatformUI;

import de.bsvrz.buv.plugin.dobj.util.IDavZeitStempelManager;
import de.bsvrz.buv.plugin.dobj.util.Projektion;
import de.bsvrz.sys.funclib.bitctrl.modell.DatensatzUpdateEvent;
import de.bsvrz.sys.funclib.bitctrl.modell.DatensatzUpdateListener;
import de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.objekte.RdsMeldung;
import de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.parameter.PdRdsMeldung;

abstract class RdsMeldungEmpfaenger implements DatensatzUpdateListener {

	private final RdsMeldungEditPart<?> editPart;
	private PointList streckenabschnitt;

	RdsMeldungEmpfaenger(final RdsMeldungEditPart<?> editPart) {
		this.editPart = editPart;
	}

	protected final RdsMeldung getRdsMeldung() {
		return editPart.getModel().getSystemObjekt();
	}

	protected final Projektion getProjektion() {
		return editPart.getProjektion();
	}

	final void anmelden() {
		getRdsMeldung().getPdRdsMeldung().addUpdateListener(RdsConverter.ASP,
				this);
	}

	final void abmelden() {
		getRdsMeldung().getPdRdsMeldung().removeUpdateListener(RdsConverter.ASP,
				this);
	}

	@Override
	public final void datensatzAktualisiert(final DatensatzUpdateEvent event) {
		if (!editPart.isActive()) {
			return;
		}

		updateZeitstempelLetzterDatensatz(event);

		if (PlatformUI.getWorkbench().getDisplay() != null) {
			PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable() {

				@Override
				public void run() {
					handleDatensatzAktualisiert(
							(PdRdsMeldung.Daten) event.getDatum());
					editPart.refreshLocation();
				}

			});
		}
	}

	private void updateZeitstempelLetzterDatensatz(
			final DatensatzUpdateEvent event) {
		final IDavZeitStempelManager davZeitStempelManager = editPart
				.getDavZeitStempelManager();
		if (event.getDatum().dContainsDaten()
				&& davZeitStempelManager != null) {
			davZeitStempelManager.setLetztenEmpfangenenZeitStempel(
					event.getDatum().dGetZeitstempel().getTime(),
					event.getObjekt().getSystemObject());
		}
	}

	private void handleDatensatzAktualisiert(final PdRdsMeldung.Daten datum) {
		if (datum.dContainsDaten()) {
			streckenabschnitt = getStreckenabschnitt(datum);
		} else {
			streckenabschnitt = new PointList();
		}
	}

	protected abstract PointList getStreckenabschnitt(
			final PdRdsMeldung.Daten datum);

	final PointList getStreckenabschnitt() {
		return streckenabschnitt;
	}

}
