/*
 * Rahmenwerk-Plug-in "Maßstäbliche Darstellung"
 * Copyright (C) 2018 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.buv.plugin.netz.rdsmeldung;

import java.util.ArrayList;
import java.util.List;

import de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.StrassenSegment;

final class RdsMeldungVerortung {

	private List<StrassenSegment> segmentListe = new ArrayList<>();

	private final int startOffset;
	private final int endOffset;

	RdsMeldungVerortung(final List<StrassenSegment> segmentListe,
			final int startOffset, final int endOffset) {
		super();
		this.segmentListe = segmentListe;
		this.startOffset = startOffset;
		this.endOffset = endOffset;
	}

	List<StrassenSegment> getSegmentListe() {
		return segmentListe;
	}

	int getStartOffset() {
		return startOffset;
	}

	int getEndOffset() {
		return endOffset;
	}

	@Override
	public String toString() {
		final StringBuffer text = new StringBuffer();
		text.append("RdsMeldungVerortung: Segmente: ");
		for (int i = 0; i < segmentListe.size(); i++) {
			if (i > 0) {
				text.append(", ");
			}
			text.append(segmentListe.get(i).getPid());
		}

		text.append(", Startoffset: " + startOffset);
		text.append(", Endoffset: " + endOffset);

		return text.toString();
	}

}
