/*
 * Rahmenwerk-Plug-in "Maßstäbliche Darstellung"
 * Copyright (C) 2018 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.buv.plugin.netz.situation;

import org.eclipse.draw2d.geometry.PointList;

import de.bsvrz.buv.plugin.dobj.decorator.LinienabstandZoomMediator;
import de.bsvrz.buv.plugin.dobj.editparts.BitCtrlDoModelEditPart;
import de.bsvrz.buv.plugin.netz.model.SituationDoModel;
import de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.Situation;

/**
 * Basisklasse für MVC-Controller zur Darstellung einer <em>Situation</em>.
 *
 * @author BitCtrl Systems GmbH, Thomas Thierfelder
 * @author BitCtrl Systems GmbH, Falko Schumann
 *
 * @param <T>
 *            der Typ der Situation.
 */
public abstract class SituationEditPart<T extends Situation, F extends SituationFigure>
		extends BitCtrlDoModelEditPart<T, F> {

	private SituationEmpfaenger empfaenger;

	@Override
	public SituationDoModel<T> getModel() {
		return (SituationDoModel<T>) super.getModel();
	}

	@Override
	public void geheOnline() {
		super.geheOnline();

		if (getSystemObjekt() != null) {
			empfaenger = createSituationEmpfaenger();
			empfaenger.anmelden();
		}
	}

	/**
	 * Erzeugt einen neuen Empfänger für die Daten der Situation.
	 */
	protected abstract SituationEmpfaenger createSituationEmpfaenger();

	@Override
	public void geheOffline() {
		if (empfaenger != null) {
			empfaenger.abmelden();
			empfaenger = null;
		}

		super.geheOffline();
	}

	@Override
	protected void refreshVisuals() {
		super.refreshVisuals();

		refreshLocation();

		new LinienabstandZoomMediator(this).mediate();
	}

	final void refreshLocation() {
		if (empfaenger != null) {
			getFigure().setStreckenabschnitt(empfaenger.getStreckenabschnitt());
		} else {
			getFigure().setStreckenabschnitt(new PointList());
		}
	}

}
