/*
 * Rahmenwerk-Plug-in "Maßstäbliche Darstellung"
 * Copyright (C) 2018 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.buv.plugin.netz.situation;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.gef.Request;

import de.bsvrz.buv.plugin.dobj.decorator.AntikollisionsalgorithmusMediator;
import de.bsvrz.buv.plugin.dobj.legende.DoLegendeBaustein;
import de.bsvrz.buv.plugin.dobj.requests.DobjRequestConstants;
import de.bsvrz.buv.plugin.dobj.requests.VerbindungslinieRequest;
import de.bsvrz.buv.plugin.netz.model.SituationSymbolDoTyp;
import de.bsvrz.buv.rw.basislib.legende.ILegendeBaustein;
import de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.Situation;

/**
 * Basisklasse für MVC-Controller zur Darstellung einer <em>Situation</em> als
 * Symbol.
 *
 * @author BitCtrl Systems GmbH, Thomas Thierfelder
 * @author BitCtrl Systems GmbH, Falko Schumann
 * @param <T>
 *            der Typ der Situation.
 */
public abstract class SituationSymbolEditPart<T extends Situation>
		extends SituationEditPart<T, SituationSymbolFigure> {

	private DoLegendeBaustein legendeBaustein;

	@Override
	protected SituationEmpfaenger createSituationEmpfaenger() {
		return new SituationSymbolEmpfaenger(this);
	}

	@Override
	public void notifyChanged(final Notification notification) {
		super.notifyChanged(notification);

		final Object notifier = notification.getNotifier();
		if (notification.getEventType() != Notification.REMOVING_ADAPTER
				&& (notifier instanceof SituationSymbolDoTyp)) {
			refreshVisuals();
		}
	}

	@Override
	protected void refreshVisuals() {
		super.refreshVisuals();

		new AntikollisionsalgorithmusMediator(this).mediate();
	}

	@Override
	public void performRequest(final Request req) {
		super.performRequest(req);

		if (DobjRequestConstants.REQ_VERBINDUNGSLINIE.equals(req.getType())) {
			final VerbindungslinieRequest vlr = (VerbindungslinieRequest) req;
			getFigure().setVerbindungslinieSichtbar(vlr.isVerbindungsLinie());
		}
	}

	@Override
	public Object getAdapter(@SuppressWarnings("rawtypes") final Class key) {
		if (ILegendeBaustein.class.equals(key)) {
			return getLegendeBaustein();
		}

		return super.getAdapter(key);
	}

	private ILegendeBaustein getLegendeBaustein() {
		disposeLegende();
		final SituationSymbolFigure f = createFigure();
		f.setVerbindungslinieSichtbar(false);
		legendeBaustein = new DoLegendeBaustein(getModel().getDoTyp(), f,
				f.getSize());
		return legendeBaustein;
	}

	private void disposeLegende() {
		if (legendeBaustein != null) {
			legendeBaustein.dispose();
			legendeBaustein = null;
		}
	}

}
