/*
 * Rahmenwerk-Plug-in "Maßstäbliche Darstellung"
 * Copyright (C) 2018 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.buv.plugin.netz.situation;

import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.PrecisionPoint;

import de.bsvrz.sys.funclib.bitctrl.geolib.WGS84Polygon;
import de.bsvrz.sys.funclib.bitctrl.geolib.WGS84Punkt;
import de.bsvrz.sys.funclib.bitctrl.modell.att.Feld;
import de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.Situation;
import de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.StrassenSegment;
import de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.parameter.PdSituationsEigenschaften;
import de.bsvrz.sys.funclib.bitctrl.modell.util.geolib.WGS84Util;

public class SituationSymbolEmpfaenger extends SituationEmpfaenger {

	protected SituationSymbolEmpfaenger(
			final SituationEditPart<? extends Situation, ? extends SituationFigure> editPart) {
		super(editPart);
	}

	@Override
	protected final PointList getStreckenabschnitt(
			final PdSituationsEigenschaften.Daten datum) {
		final Feld<StrassenSegment> strassenSegmente = datum
				.getStrassenSegment();
		if (strassenSegmente.isEmpty()) {
			return new PointList();
		}

		final WGS84Polygon polygon = WGS84Util.ausschneiden(
				strassenSegmente.get(0), datum.getStartOffset().doubleValue(),
				-1);
		if (polygon.getKoordinaten().size() <= 1) {
			return new PointList();
		}

		final WGS84Punkt wgs84Punkt = polygon.getKoordinaten().get(0);
		Point point = new PrecisionPoint(wgs84Punkt.getLaenge(),
				wgs84Punkt.getBreite());
		point = getProjektion().umrechnenWeltNachModel(point);

		final WGS84Punkt nextWgs84Punkt = polygon.getKoordinaten().get(1);
		final Point nextPoint = getProjektion().umrechnenWeltNachModel(
				new PrecisionPoint(nextWgs84Punkt.getLaenge(),
						nextWgs84Punkt.getBreite()));

		final PointList pointList = new PointList();
		pointList.addPoint(point);
		pointList.addPoint(nextPoint);
		return pointList;
	}

}
