/*
 * Rahmenwerk-Plug-in "Maßstäbliche Darstellung"
 * Copyright (C) 2018 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.buv.plugin.netz.situation;

import java.util.List;

import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.PrecisionPoint;

import com.bitctrl.lib.eclipse.log.PluginLogger;

import de.bsvrz.buv.plugin.netz.internal.NetzPlugin;
import de.bsvrz.sys.funclib.bitctrl.geolib.WGS84Polygon;
import de.bsvrz.sys.funclib.bitctrl.geolib.WGS84Punkt;
import de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.Situation;
import de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.StrassenSegment;
import de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.parameter.PdSituationsEigenschaften;
import de.bsvrz.sys.funclib.bitctrl.modell.util.geolib.WGS84Util;

public class SituationVerlaufEmpfaenger extends SituationEmpfaenger {

	private final PluginLogger logger = NetzPlugin.getDefault().getLogger();

	protected SituationVerlaufEmpfaenger(
			final SituationEditPart<? extends Situation, ? extends SituationFigure> editPart) {
		super(editPart);
	}

	@Override
	protected final PointList getStreckenabschnitt(
			final PdSituationsEigenschaften.Daten situationsEigenschaften) {
		final List<StrassenSegment> strassenSegmente = situationsEigenschaften
				.getStrassenSegment();
		if (strassenSegmente.isEmpty()) {
			return new PointList();
		}

		WGS84Polygon polygon;
		try {
			polygon = WGS84Util.abschneiden(strassenSegmente,
					situationsEigenschaften.getStartOffset().doubleValue(),
					situationsEigenschaften.getEndOffset().doubleValue());
		} catch (final IllegalArgumentException ex) {
			logger.error("Das Polygon der Situation "
					+ situationsEigenschaften.dGetDatensatz().getSystemObjekt()
					+ " konnte nicht aus den Straßensegmente und dem Start- und Endoffset bestimmt werden.",
					ex);
			polygon = WGS84Util.verbinde(strassenSegmente);
		}

		if (polygon.laenge() < 10) {
			return new PointList();
		}

		final PointList pointList = new PointList();
		for (final WGS84Punkt e : polygon.getKoordinaten()) {
			Point p = new PrecisionPoint(e.getLaenge(), e.getBreite());
			p = getProjektion().umrechnenWeltNachModel(p);
			if (p.preciseX() > 0.0 && p.preciseY() > 0.0) {
				pointList.addPoint(p);
			} else {
				logger.error("Das Polygon der Situation "
						+ situationsEigenschaften.dGetDatensatz()
								.getSystemObjekt()
						+ " enthält einen ungültigen Punkt: " + p);
			}
		}
		return pointList;
	}

}
