/*
 * Rahmenwerk-Plug-in "Maßstäbliche Darstellung"
 * Copyright (C) 2018 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.buv.plugin.netz.stau;

import org.eclipse.draw2d.IFigure;
import org.eclipse.gef.EditPolicy;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;

import de.bsvrz.buv.plugin.netz.internal.NetzPlugin;
import de.bsvrz.buv.plugin.netz.situation.SituationSymbolEditPart;
import de.bsvrz.buv.plugin.netz.situation.SituationSymbolFigure;
import de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.Stau;

/**
 * MVC-Controller für die Darstellung eines Staus als Symbol.
 *
 * @author BitCtrl Systems GmbH, Thierfelder
 *
 */
public class StauSymbolEditPart extends SituationSymbolEditPart<Stau> {

	private final ImageDescriptor stauSymbolImageDescriptor = NetzPlugin
			.getDefault().getImageDescriptor("images/dot/stau.png");

	protected final ImageDescriptor getStauSymbolImageDescriptor() {
		return stauSymbolImageDescriptor;
	}

	@Override
	protected SituationSymbolFigure createFigure() {
		final Image image = getResourceManager()
				.createImage(stauSymbolImageDescriptor);
		return new SituationSymbolFigure(getKollisionsManager(), image);
	}

	@Override
	protected void createEditPolicies() {
		super.createEditPolicies();

		if (!isEditor()) {
			installEditPolicy(EditPolicy.SELECTION_FEEDBACK_ROLE,
					new StauPopUpEditPolicy());
		}
	}

	@Override
	protected final IFigure getToolTip() {
		if (isEditor()) {
			return super.getToolTip();
		}

		return null;
	}

}
