/*
 * Rahmenwerk-Plug-in "Maßstäbliche Darstellung"
 * Copyright (C) 2018 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.buv.plugin.netz.stoerfall;

import org.eclipse.swt.graphics.Color;

import de.bsvrz.buv.plugin.dobj.decorator.StoerfallIndikatorFigure;
import de.bsvrz.buv.plugin.dobj.decorator.StoerfallSituation;
import de.bsvrz.buv.plugin.netz.LinieFigure;

/**
 * MVC-View für die Darstellung der Situation eines <em>Störfallindikators</em>.
 *
 * @author BitCtrl Systems GmbH, thierfelder
 * @author BitCtrl Systems GmbH, Falko Schumann
 */
public class BaseStoerfallIndikatorFigure extends LinieFigure
		implements StoerfallIndikatorFigure {

	private StoerfallSituation stoerfallSituation;
	private Color stoerungFarbe;
	private Color keineAussageFarbe;
	private Color freierVerkehrFarbe;
	private Color lebhafterVerkehrFarbe;
	private Color dichterVerkehrFarbe;
	private Color zaehfliessenderVerkehrFarbe;
	private Color stockenderVerkehrFarbe;
	private Color stauFarbe;

	@Override
	public final StoerfallSituation getStoerfallSituation() {
		return stoerfallSituation;
	}

	@Override
	public final void setStoerfallSituation(
			final StoerfallSituation stoerfallSituation) {
		if (this.stoerfallSituation == stoerfallSituation) {
			return;
		}

		this.stoerfallSituation = stoerfallSituation;

		updateFigure();
	}

	@Override
	public final Color getStoerungFarbe() {
		return stoerungFarbe;
	}

	@Override
	public final void setStoerungFarbe(final Color stoerungFarbe) {
		this.stoerungFarbe = stoerungFarbe;
		updateFigure();
	}

	@Override
	public final Color getKeineAussageFarbe() {
		return keineAussageFarbe;
	}

	@Override
	public final void setKeineAussageFarbe(final Color keineAussageFarbe) {
		this.keineAussageFarbe = keineAussageFarbe;
		updateFigure();
	}

	@Override
	public final Color getFreierVerkehrFarbe() {
		return freierVerkehrFarbe;
	}

	@Override
	public final void setFreierVerkehrFarbe(final Color freierVerkehrFarbe) {
		this.freierVerkehrFarbe = freierVerkehrFarbe;
		updateFigure();
	}

	@Override
	public final Color getLebhafterVerkehrFarbe() {
		return lebhafterVerkehrFarbe;
	}

	@Override
	public final void setLebhafterVerkehrFarbe(
			final Color lebhafterVerkehrFarbe) {
		this.lebhafterVerkehrFarbe = lebhafterVerkehrFarbe;
		updateFigure();
	}

	@Override
	public final Color getDichterVerkehrFarbe() {
		return dichterVerkehrFarbe;
	}

	@Override
	public final void setDichterVerkehrFarbe(final Color dichterVerkehrFarbe) {
		this.dichterVerkehrFarbe = dichterVerkehrFarbe;
		updateFigure();
	}

	@Override
	public final Color getZaehfliessenderVerkehrFarbe() {
		return zaehfliessenderVerkehrFarbe;
	}

	@Override
	public final void setZaehfliessenderVerkehrFarbe(
			final Color zaehfliessenderVerkehrFarbe) {
		this.zaehfliessenderVerkehrFarbe = zaehfliessenderVerkehrFarbe;
		updateFigure();
	}

	@Override
	public final Color getStockenderVerkehrFarbe() {
		return stockenderVerkehrFarbe;
	}

	@Override
	public final void setStockenderVerkehrFarbe(
			final Color stockenderVerkehrFarbe) {
		this.stockenderVerkehrFarbe = stockenderVerkehrFarbe;
		updateFigure();
	}

	@Override
	public final Color getStauFarbe() {
		return stauFarbe;
	}

	@Override
	public final void setStauFarbe(final Color stauFarbe) {
		this.stauFarbe = stauFarbe;
		updateFigure();
	}

	@Override
	public void setVisible(final boolean visible) {
		/*
		 * FIXME Refactoren wie bei Situation, so das setVisible nicht
		 * überschrieben wird.
		 */
		final boolean newVisible = visible && stoerfallSituation != null;
		super.setVisible(newVisible);
	}

	@Override
	protected void updateFigure() {
		super.updateFigure();

		if (stoerfallSituation != null) {
			switch (stoerfallSituation) {
			case Stoerung:
				setForegroundColor(stoerungFarbe);
				break;
			case KeineAussage:
				setForegroundColor(keineAussageFarbe);
				break;
			case FreierVerkehr:
				setForegroundColor(freierVerkehrFarbe);
				break;
			case LebhafterVerkehr:
				setForegroundColor(lebhafterVerkehrFarbe);
				break;
			case DichterVerkehr:
				setForegroundColor(dichterVerkehrFarbe);
				break;
			case ZaehfliessenderVerkehr:
				setForegroundColor(zaehfliessenderVerkehrFarbe);
				break;
			case StockenderVerkehr:
				setForegroundColor(stockenderVerkehrFarbe);
				break;
			case Stau:
				setForegroundColor(stauFarbe);
				break;
			default:
				throw new IllegalArgumentException(
						"Unbekannte Störfallsituation: " + stoerfallSituation);
			}
		}
	}

}
