/*
 * Rahmenwerk-Plug-in "Maßstäbliche Darstellung"
 * Copyright (C) 2018 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.buv.plugin.netz.stoerfall;

import static de.bsvrz.buv.plugin.dobj.util.StoerfallConstants.DEFAULT_ASP_STOERFALL_VERFAHREN;
import static de.bsvrz.buv.plugin.dobj.util.StoerfallConstants.VIEWER_PROPERTY_ASPECT_STOERFALL_VERFAHREN;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.common.notify.Notification;

import de.bsvrz.buv.plugin.dobj.decorator.LinienabstandZoomMediator;
import de.bsvrz.buv.plugin.dobj.decorator.LinienstaerkeZoomMediator;
import de.bsvrz.buv.plugin.dobj.decorator.StoerfallIndikatorMediator;
import de.bsvrz.buv.plugin.dobj.editparts.BitCtrlDoModelEditPart;
import de.bsvrz.buv.plugin.netz.model.StoerfallIndikatorDoTyp;
import de.bsvrz.buv.rw.basislib.legende.ILegendeBaustein;
import de.bsvrz.dav.daf.main.ClientDavInterface;
import de.bsvrz.dav.daf.main.config.Aspect;
import de.bsvrz.dav.daf.main.config.DataModel;
import de.bsvrz.dav.daf.main.config.SystemObject;
import de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.StoerfallIndikator;

/**
 * Basisklasse für MVC-Controller vom Typ <em>StörfallIndikator</em>.
 *
 * @author BitCtrl Systems GmbH, Thierfelder
 * @author BitCtrl Systems GmbH, Falko Schumann
 */
public abstract class StoerfallIndikatorEditPart<T extends StoerfallIndikator>
		extends BitCtrlDoModelEditPart<T, BaseStoerfallIndikatorFigure> {

	private final PropertyChangeListener viewerPropertyChangeListener = new PropertyChangeListener() {

		@Override
		public void propertyChange(final PropertyChangeEvent evt) {
			if (!VIEWER_PROPERTY_ASPECT_STOERFALL_VERFAHREN
					.equals(evt.getPropertyName())) {
				return;
			}

			if (empfaenger != null) {
				final Aspect asp = (Aspect) evt.getNewValue();
				Assert.isNotNull(asp);
				empfaenger.setAspect(asp);
			}
		}

	};

	private StoerfallIndikatorEmpfaenger empfaenger;
	private StoerfallIndikatorLegendeBaustein legendeBaustein;

	/**
	 * Gibt den Darstellungsobjekttyp zurück.
	 */
	protected StoerfallIndikatorDoTyp getDoTyp() {
		return (StoerfallIndikatorDoTyp) getModel().getDoTyp();
	}

	@Override
	protected BaseStoerfallIndikatorFigure createFigure() {
		return new BaseStoerfallIndikatorFigure();
	}

	@Override
	public void activate() {
		super.activate();

		getViewer().addPropertyChangeListener(viewerPropertyChangeListener);
	}

	@Override
	public void deactivate() {
		disposeLegende();

		getViewer().removePropertyChangeListener(viewerPropertyChangeListener);

		super.deactivate();
	}

	@Override
	public void geheOnline() {
		super.geheOnline();

		final SystemObject so = getModel().getSystemObject();
		if (so != null) {
			empfaenger = new StoerfallIndikatorEmpfaenger(so, getFigure(),
					getDavZeitStempelManager(), getAspectStoerfallVerfahren());
			empfaenger.anmelden();
		}
	}

	@Override
	public void geheOffline() {
		getFigure().setStoerfallSituation(null);

		if (empfaenger != null) {
			empfaenger.abmelden();
			empfaenger = null;
		}

		super.geheOffline();
	}

	private Aspect getAspectStoerfallVerfahren() {
		Aspect asp = (Aspect) getViewer()
				.getProperty(VIEWER_PROPERTY_ASPECT_STOERFALL_VERFAHREN);
		if (asp == null) {
			asp = getDataModel().getAspect(DEFAULT_ASP_STOERFALL_VERFAHREN);
		}
		Assert.isNotNull(asp);
		return asp;
	}

	private DataModel getDataModel() {
		final ClientDavInterface dav = getDav();
		final DataModel model = dav.getDataModel();
		Assert.isNotNull(model);
		return model;
	}

	@Override
	public void notifyChanged(final Notification notification) {
		super.notifyChanged(notification);

		final Object notifier = notification.getNotifier();
		if (notification.getEventType() != Notification.REMOVING_ADAPTER
				&& (notifier instanceof StoerfallIndikatorDoTyp)) {
			refreshVisuals();
		}
	}

	@Override
	protected void refreshVisuals() {
		super.refreshVisuals();

		new LinienstaerkeZoomMediator(this).mediate();
		new LinienabstandZoomMediator(this).mediate();
		new StoerfallIndikatorMediator(this).mediate();
	}

	@Override
	public Object getAdapter(@SuppressWarnings("rawtypes") final Class key) {
		if (ILegendeBaustein.class.equals(key)) {
			return getLegendeBaustein();
		}

		return super.getAdapter(key);
	}

	private ILegendeBaustein getLegendeBaustein() {
		disposeLegende();
		legendeBaustein = new StoerfallIndikatorLegendeBaustein(getDoTyp(),
				createFigure());
		return legendeBaustein;
	}

	private void disposeLegende() {
		if (legendeBaustein != null) {
			legendeBaustein.dispose();
			legendeBaustein = null;
		}
	}

}
