/*
 * Rahmenwerk-Plug-in "Maßstäbliche Darstellung"
 * Copyright (C) 2018 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.buv.plugin.netz.stoerfall;

import static de.bsvrz.buv.plugin.dobj.util.StoerfallConstants.ATG_STOERFALL_ZUSTAND;

import org.eclipse.ui.PlatformUI;

import de.bsvrz.buv.plugin.dobj.decorator.StoerfallIndikatorFigure;
import de.bsvrz.buv.plugin.dobj.decorator.StoerfallSituation;
import de.bsvrz.buv.plugin.dobj.util.IDavZeitStempelManager;
import de.bsvrz.buv.plugin.netz.internal.RahmenwerkService;
import de.bsvrz.dav.daf.main.ClientDavInterface;
import de.bsvrz.dav.daf.main.ClientReceiverInterface;
import de.bsvrz.dav.daf.main.Data;
import de.bsvrz.dav.daf.main.DataDescription;
import de.bsvrz.dav.daf.main.ReceiveOptions;
import de.bsvrz.dav.daf.main.ReceiverRole;
import de.bsvrz.dav.daf.main.ResultData;
import de.bsvrz.dav.daf.main.config.Aspect;
import de.bsvrz.dav.daf.main.config.AttributeGroup;
import de.bsvrz.dav.daf.main.config.DataModel;
import de.bsvrz.dav.daf.main.config.SystemObject;

final class StoerfallIndikatorEmpfaenger implements ClientReceiverInterface {

	private final SystemObject systemObject;
	private final StoerfallIndikatorFigure figure;
	private final IDavZeitStempelManager davZeitStempelManager;

	private Aspect aspect;

	StoerfallIndikatorEmpfaenger(final SystemObject systemObject,
			final StoerfallIndikatorFigure figure,
			final IDavZeitStempelManager davZeitStempelManager,
			final Aspect aspect) {
		this.systemObject = systemObject;
		this.figure = figure;
		this.davZeitStempelManager = davZeitStempelManager;
		this.aspect = aspect;
	}

	public void setAspect(final Aspect aspect) {
		abmelden();
		this.aspect = aspect;
		anmelden();
	}

	void anmelden() {
		getClientDavInterface().subscribeReceiver(this, systemObject,
				createDataDescription(), ReceiveOptions.normal(),
				ReceiverRole.receiver());
	}

	void abmelden() {
		final ClientDavInterface dav = getClientDavInterface();
		if (dav != null) {
			dav.unsubscribeReceiver(this, systemObject,
					createDataDescription());
		}
	}

	private ClientDavInterface getClientDavInterface() {
		return RahmenwerkService.getService().getRahmenwerk()
				.getDavVerbindung();
	}

	private DataDescription createDataDescription() {
		final DataModel model = getClientDavInterface().getDataModel();
		final AttributeGroup atg = model
				.getAttributeGroup(ATG_STOERFALL_ZUSTAND);
		return new DataDescription(atg, aspect);
	}

	@Override
	public void update(final ResultData[] resultDatas) {
		for (final ResultData resultData : resultDatas) {
			updateZeitstempelLetzterDatensatz(resultData);

			PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable() {

				@Override
				public void run() {
					final StoerfallSituation situation;
					if (resultData.hasData()) {
						final Data data = resultData.getData();
						final byte value = data.getItem("Situation")
								.asUnscaledValue().byteValue();
						situation = StoerfallSituation.values()[value];
					} else {
						situation = null;
					}
					figure.setStoerfallSituation(situation);
				}

			});
		}
	}

	private void updateZeitstempelLetzterDatensatz(
			final ResultData resultData) {
		if (resultData.hasData() && davZeitStempelManager != null) {
			davZeitStempelManager.setLetztenEmpfangenenZeitStempel(
					resultData.getDataTime(), resultData.getObject());
		}
	}

}
