/*
 * Rahmenwerk-Plug-in "Maßstäbliche Darstellung"
 * Copyright (C) 2018 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.buv.plugin.netz.stoerfall;

import java.util.ArrayList;
import java.util.List;

import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;

import com.bitctrl.lib.eclipse.draw2d.FigureUtilities2;

import de.bsvrz.buv.plugin.dobj.decorator.LinienstaerkeFigure;
import de.bsvrz.buv.plugin.dobj.decorator.StoerfallSituation;
import de.bsvrz.buv.plugin.dobj.decorator.model.LinienstaerkeDecorator;
import de.bsvrz.buv.plugin.dobj.decorator.model.LinienstaerkeZoomDecorator;
import de.bsvrz.buv.plugin.dobj.model.DoTyp;
import de.bsvrz.buv.plugin.netz.LinieFigure;
import de.bsvrz.buv.plugin.netz.model.StoerfallIndikatorDoTyp;
import de.bsvrz.buv.rw.basislib.legende.ILegendeBaustein;
import de.bsvrz.buv.rw.basislib.legende.LegendeBaustein;

final class StoerfallIndikatorLegendeBaustein implements ILegendeBaustein {

	private final DoTyp doTyp;
	private final BaseStoerfallIndikatorFigure figure;

	private List<ILegendeBaustein> legendenBausteine;
	private Image image;
	private final Color stoerungFarbe;
	private final Color keineAussageFarbe;
	private final Color freierVerkehrFarbe;
	private final Color lebhafterVerkehrFarbe;
	private final Color dichterVerkehrFarbe;
	private final Color zaehfliessenderVerkehrFarbe;
	private final Color stockenderVerkehrFarbe;
	private final Color stauFarbe;

	StoerfallIndikatorLegendeBaustein(final StoerfallIndikatorDoTyp doTyp,
			final BaseStoerfallIndikatorFigure figure) {
		this.doTyp = doTyp;
		this.figure = figure;

		assignGeometrie(figure);
		assignLinienstaerke(doTyp, figure);

		final Display display = PlatformUI.getWorkbench().getDisplay();
		stoerungFarbe = new Color(display, doTyp.getStoerungFarbe());
		figure.setStoerungFarbe(stoerungFarbe);
		keineAussageFarbe = new Color(display, doTyp.getKeineAussageFarbe());
		figure.setKeineAussageFarbe(keineAussageFarbe);
		freierVerkehrFarbe = new Color(display, doTyp.getFreierVerkehrFarbe());
		figure.setFreierVerkehrFarbe(freierVerkehrFarbe);
		lebhafterVerkehrFarbe = new Color(display,
				doTyp.getLebhafterVerkehrFarbe());
		figure.setLebhafterVerkehrFarbe(lebhafterVerkehrFarbe);
		dichterVerkehrFarbe = new Color(display,
				doTyp.getDichterVerkehrFarbe());
		figure.setDichterVerkehrFarbe(dichterVerkehrFarbe);
		zaehfliessenderVerkehrFarbe = new Color(display,
				doTyp.getZaehfliessenderVerkehrFarbe());
		figure.setZaehfliessenderVerkehrFarbe(zaehfliessenderVerkehrFarbe);
		stockenderVerkehrFarbe = new Color(display,
				doTyp.getStockenderVerkehrFarbe());
		figure.setStockenderVerkehrFarbe(stockenderVerkehrFarbe);
		stauFarbe = new Color(display, doTyp.getStauFarbe());
		figure.setStauFarbe(stauFarbe);
	}

	private void assignGeometrie(final LinieFigure linieFigure) {
		final PointList points = new PointList();
		points.addPoint(new Point(0, 15));
		points.addPoint(new Point(4, 8));
		points.addPoint(new Point(12, 6));
		points.addPoint(new Point(15, 0));
		linieFigure.setBasePoints(points);
	}

	private void assignLinienstaerke(final StoerfallIndikatorDoTyp doTyp,
			final LinienstaerkeFigure linienstaerkeFigure) {
		if (doTyp instanceof LinienstaerkeDecorator) {
			linienstaerkeFigure.setLinienstaerke(
					((LinienstaerkeDecorator) doTyp).getLinienstaerke());
		} else if (doTyp instanceof LinienstaerkeZoomDecorator) {
			linienstaerkeFigure.setLinienstaerke(
					((LinienstaerkeZoomDecorator) doTyp).getLinienstaerke());
		} else {
			linienstaerkeFigure.setLinienstaerke(1);
		}
	}

	@Override
	public List<ILegendeBaustein> getBausteine() {
		if (legendenBausteine == null) {
			legendenBausteine = new ArrayList<>();

			for (final StoerfallSituation e : StoerfallSituation.values()) {
				final Image img = createImage(e);
				legendenBausteine.add(new LegendeBaustein(img, e.toString()));
			}

		}

		return legendenBausteine;
	}

	private Image createImage(final StoerfallSituation stoerfallSituation) {
		figure.setStoerfallSituation(stoerfallSituation);
		if (ColorConstants.white.getRGB()
				.equals(figure.getForegroundColor().getRGB())) {
			return FigureUtilities2.createImageWithGrayBackGroud(figure,
					new Dimension(16, 16));
		}
		return FigureUtilities2.createImage(figure, new Dimension(16, 16));
	}

	@Override
	public Image getIcon() {
		if (image == null) {
			image = createImage(StoerfallSituation.FreierVerkehr);
		}

		return image;
	}

	@Override
	public String getText() {
		return doTyp.getName();
	}

	void dispose() {
		if (legendenBausteine != null) {
			for (final ILegendeBaustein e : legendenBausteine) {
				e.getIcon().dispose();
			}
			legendenBausteine = null;
		}

		if (image != null) {
			image.dispose();
			image = null;
		}

		stoerungFarbe.dispose();
		keineAussageFarbe.dispose();
		freierVerkehrFarbe.dispose();
		lebhafterVerkehrFarbe.dispose();
		dichterVerkehrFarbe.dispose();
		zaehfliessenderVerkehrFarbe.dispose();
		stockenderVerkehrFarbe.dispose();
		stauFarbe.dispose();
	}

}
