/*
 * Rahmenwerk-Plug-in "Maßstäbliche Darstellung"
 * Copyright (C) 2018 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.buv.plugin.netz.stoerfall.anzeigeverfahren;

import java.util.SortedSet;

import de.bsvrz.buv.plugin.darstellung.model.AnzeigeVerfahren;
import de.bsvrz.buv.plugin.netz.internal.RahmenwerkService;
import de.bsvrz.sys.funclib.bitctrl.geolib.WGS84Polygon;
import de.bsvrz.sys.funclib.bitctrl.modell.SystemObjekt;
import de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.MessQuerschnittAllgemein;
import de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.StrassenSegment;
import de.bsvrz.sys.funclib.bitctrl.modell.util.cache.AnzeigeVerfahrenCache.MqaMitPosition;
import de.bsvrz.sys.funclib.bitctrl.modell.util.geolib.WGS84Util;

/**
 * Ordnet jedem allgemeinen Messquerschnitt ein Polygon nach Verfahren III
 * (siehe SE-02.00.00.00.00-AFo-5.0) zu.
 *
 * @author BitCtrl Systems GmbH, thierfelder
 */
public final class AnzeigeVerfahren3PolygonProvider
		extends AbstractAnzeigeVerfahrenPolygonProvider {

	/**
	 * Singleton-Instanz dieser Klasse.
	 */
	public static final AnzeigeVerfahrenPolygonProvider INSTANCE = new AnzeigeVerfahren3PolygonProvider();

	private AnzeigeVerfahren3PolygonProvider() {
		initializeInBackground();
	}

	@Override
	protected AnzeigeVerfahrenInitializer createAnzeigeVerfahrenInitializer() {
		return new AnzeigeVerfahren3Initializer();
	}

	@Override
	public String toString() {
		return AnzeigeVerfahren.VERFAHREN_III.getLiteral();
	}

	private class AnzeigeVerfahren3Initializer
			extends AnzeigeVerfahrenInitializer {

		@Override
		protected void initialize() {
			for (final SystemObjekt mqs : RahmenwerkService.getService()
					.getObjektFactory()
					.bestimmeModellobjekte(MessQuerschnittAllgemein.PID)) {
				final MessQuerschnittAllgemein mq = (MessQuerschnittAllgemein) mqs;
				final StrassenSegment segment = RahmenwerkService.getService()
						.getCacheService().getAnzeigeVerfahrenCache()
						.getMqToSegment().get(mq);
				final Double offset = RahmenwerkService.getService()
						.getCacheService().getAnzeigeVerfahrenCache()
						.getMqToOffset().get(mq);
				WGS84Polygon punkte;
				punkte = null;

				if (segment != null && offset != null) {
					final SortedSet<MqaMitPosition> mqList = RahmenwerkService
							.getService().getCacheService()
							.getAnzeigeVerfahrenCache().getSegmentToMqList()
							.get(segment);
					if (mqList != null) {
						int i = 0;
						int found = -1;
						final MqaMitPosition[] mqArray = mqList
								.toArray(new MqaMitPosition[mqList.size()]);
						for (final MqaMitPosition elem : mqList) {
							if (elem.offset == offset) {
								found = i;
								break;
							}
							i++;
						}
						if (found > -1) {
							if (found == 0) {
								/**
								 * An erster Stelle gefunden:
								 */
								if (mqList.size() == 1) {
									/**
									 * ganzes Segment.
									 */
									punkte = WGS84Util.ausschneiden(segment,
											-1.0, -1.0);
								} else {
									/**
									 * von Segmentanfang bis Offset von zweitem
									 * MQ
									 */
									punkte = WGS84Util
											.ausschneiden(segment, -1.0,
													(mqArray[0].offset
															+ mqArray[1].offset)
															/ 2.0);
								}
							} else if (found == mqList.size() - 1) {
								/**
								 * An letzter Stelle gefunden und MQ-Liste
								 * wenigstens zwei Elemente gross:
								 */
								punkte = WGS84Util.ausschneiden(segment,
										(mqArray[mqList.size() - 2].offset
												+ mqArray[mqList.size()
														- 1].offset)
												/ 2.0,
										-1.0);
							} else {
								/**
								 * Sonst
								 */
								punkte = WGS84Util.ausschneiden(segment,
										(mqArray[found - 1].offset
												+ mqArray[found].offset) / 2.0,
										(mqArray[found].offset
												+ mqArray[found + 1].offset)
												/ 2.0);
							}
						}
					}
				}
				getMqToPolygon().put(mq, punkte);

			}
			fireAnzeigeVerfahrenInitialisiertAndRemoveAllListeners();
		}
	}

}
