/*
 * Rahmenwerk-Plug-in "Maßstäbliche Darstellung"
 * Copyright (C) 2018 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.buv.plugin.netz.stoerfall.anzeigeverfahren;

import java.util.ArrayList;

import de.bsvrz.sys.funclib.bitctrl.geolib.WGS84Polygon;
import de.bsvrz.sys.funclib.bitctrl.geolib.WGS84Punkt;
import de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.MessQuerschnittAllgemein;

/**
 * Stellt zu einem allgemeinen Messquerschnitt ein Polygon in WGS84-Koordinaten
 * zur Verfuegung, dem dessen Verkehrslage zugeordnet werden kann.
 *
 * @author BitCtrl Systems GmbH, thierfelder
 *
 */
public interface AnzeigeVerfahrenPolygonProvider {

	/**
	 * Polygon ohne Punkte.
	 */
	WGS84Polygon LEERES_POLYGON = new WGS84Polygon(new ArrayList<WGS84Punkt>());

	/**
	 * Erfragt zu einem allgemeinen Messquerschnitt ein Polygon in
	 * WGS84-Koordinaten, dem dessen Verkehrslage zugeordnet werden kann.
	 *
	 * @param mqa
	 *            ein allgemeiner Messquerschnitt.
	 * @return zu einem allgemeinen Messquerschnitt ein Polygon in
	 *         WGS84-Koordinaten, dem dessen Verkehrslage zugeordnet werden kann
	 *         bzw. ein "leeres" Polygon, wenn dies nicht moeglich ist.
	 */
	WGS84Polygon getPolygonBy(final MessQuerschnittAllgemein mqa);

	/**
	 * Erfragt die Id.
	 *
	 * @return die Id.
	 */
	String getId();

	/**
	 * Fuegt neuen Listener hinzu.
	 *
	 * @param listener
	 *            neuer Listener.
	 */
	void addInitialisierungsListener(final AnzeigeVerfahrenListener listener);

}
