/*
 * Rahmenwerk-Plug-in "Maßstäbliche Darstellung"
 * Copyright (C) 2018 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.buv.plugin.netz.strassenknoten;

import org.eclipse.draw2d.Ellipse;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PrecisionPoint;
import org.eclipse.draw2d.geometry.Rectangle;

import de.bsvrz.buv.plugin.dobj.DoFigure;

/**
 * MVC-View zur Darstellung von Straßenknoten.
 *
 * @author BitCtrl Systems GmbH, Falko Schumann
 *
 */
final class StrassenKnotenFigure extends Ellipse implements DoFigure {

	private Point hotspot;
	private int ausgangsdurchmesserInMeter;
	private int minimalerDurchmesserInPixel;
	private double zoom = 1.0;
	private double vonZoom;
	private double bisZoom = Double.MAX_VALUE;

	@Override
	public Point getHotspot() {
		return hotspot;
	}

	@Override
	public void setHotspot(final Point hotspot) {
		if (this.hotspot != null && this.hotspot.equals(hotspot)) {
			return;
		}

		this.hotspot = hotspot;

		updateFigure();
	}

	public int getAusgangsdurchmesserInMeter() {
		return ausgangsdurchmesserInMeter;
	}

	public void setAusgangsdurchmesserInMeter(
			final int ausgangsdurchmesserInMeter) {
		if (this.ausgangsdurchmesserInMeter == ausgangsdurchmesserInMeter) {
			return;
		}

		this.ausgangsdurchmesserInMeter = ausgangsdurchmesserInMeter;

		updateFigure();
	}

	public int getMinimalerDurchmesserInPixel() {
		return minimalerDurchmesserInPixel;
	}

	public void setMinimalerDurchmesserInPixel(
			final int minimalerDurchmesserInPixel) {
		if (this.minimalerDurchmesserInPixel == minimalerDurchmesserInPixel) {
			return;
		}

		this.minimalerDurchmesserInPixel = minimalerDurchmesserInPixel;

		updateFigure();
	}

	@Override
	public void setSichtbareZoomStufe(final double vonZoom,
			final double bisZoom) {
		if (this.vonZoom == vonZoom && this.bisZoom == bisZoom) {
			return;
		}

		this.vonZoom = vonZoom;
		this.bisZoom = bisZoom;

		updateFigure();
	}

	@Override
	public void handleZoomChanged(final double newZoom) {
		if (zoom == newZoom) {
			return;
		}

		zoom = newZoom;

		updateFigure();
	}

	private void updateFigure() {
		setVisible(vonZoom <= zoom && zoom <= bisZoom);
		setLineWidthFloat((float) (1 / zoom));

		double durchmesser = ausgangsdurchmesserInMeter;
		if (durchmesser * zoom < minimalerDurchmesserInPixel) {
			durchmesser = minimalerDurchmesserInPixel / zoom;
		}
		final Point p;
		if (hotspot != null) {
			p = new PrecisionPoint(hotspot.x - durchmesser / 2,
					hotspot.y - durchmesser / 2);
		} else {
			p = new PrecisionPoint(durchmesser / 2, durchmesser / 2);
		}
		final Dimension size = new Dimension((int) durchmesser,
				(int) durchmesser).expand(1, 1);
		super.setBounds(new Rectangle(p, size));

	}

	@Override
	public void setBounds(final Rectangle rect) {
		/*
		 * TODO Workaround beseitigen. Jemand kann setBounds() aufrufen und
		 * damit updateFigure() umgehen.
		 */

		if (getBounds() != null && getBounds().equals(rect)) {
			return;
		}

		updateFigure();
	}

}
