/*
 * Rahmenwerk-Plug-in "Maßstäbliche Darstellung"
 * Copyright (C) 2018 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.buv.plugin.netz.strassenknoten;

import static org.eclipse.swt.SWT.BORDER;
import static org.eclipse.swt.SWT.CENTER;
import static org.eclipse.swt.SWT.CHECK;
import static org.eclipse.ui.views.properties.tabbed.ITabbedPropertyConstants.HSPACE;
import static org.eclipse.ui.views.properties.tabbed.ITabbedPropertyConstants.VSPACE;

import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;

import com.bitctrl.lib.eclipse.emf.gef.commands.SetCommand;
import com.bitctrl.lib.eclipse.emf.gef.commands.UnsetCommand;

import de.bsvrz.buv.plugin.dobj.model.DoKomponente;
import de.bsvrz.buv.plugin.dobj.properties.AbstractSection;
import de.bsvrz.buv.plugin.netz.model.NetzPackage;
import de.bsvrz.buv.plugin.netz.model.StrassenKnotenDoTyp;

/**
 * Erlaubt die Parametrierung des Ausgangsdurchmessers und minimalen
 * Durchmessers der Straßenknoten.
 *
 * @author BitCtrl Systems GmbH, Falko Schumann
 *
 */
public final class StrassenKnotenPropertySection
		extends AbstractSection<StrassenKnotenDoTyp> {

	private Label ausgangsdurchmesserLabel;
	private Spinner ausgangsdurchmesser;
	private Label ausgangsdurchmesserEinheitLabel;
	private Button ausgangsdurchmesserUseDefault;

	private Label minimalerDurchmesserLabel;
	private Spinner minimalerDurchmesser;
	private Label minimalerDurchmesserEinheitLabel;
	private Button minimalerDurchmesserUseDefault;

	@Override
	public void createControls(final Composite parent,
			final TabbedPropertySheetPage aTabbedPropertySheetPage) {
		super.createControls(parent, aTabbedPropertySheetPage);

		final TabbedPropertySheetWidgetFactory factory = getWidgetFactory();
		final Composite container = factory.createFlatFormComposite(parent);

		createAusgangsdurchmesser(container);
		createMinimalerDurchmesser(container);
	}

	private void createAusgangsdurchmesser(final Composite parent) {
		final TabbedPropertySheetWidgetFactory factory = getWidgetFactory();

		// Widgets anlegen

		ausgangsdurchmesserLabel = factory.createLabel(parent,
				"Ausgangsdurchmesser:", BORDER);
		ausgangsdurchmesser = new Spinner(parent, BORDER);
		ausgangsdurchmesser.setMinimum(1);
		ausgangsdurchmesser.setMaximum(Integer.MAX_VALUE);
		ausgangsdurchmesser.setIncrement(1);
		ausgangsdurchmesser.setPageIncrement(10);
		factory.adapt(parent);
		ausgangsdurchmesserEinheitLabel = factory.createLabel(parent, "Meter");
		ausgangsdurchmesserUseDefault = factory.createButton(parent,
				"Defaultwert verwenden", CHECK);

		// Widgets layouten
		final FormData spinnerData = new FormData();
		spinnerData.left = new FormAttachment(ausgangsdurchmesserLabel, HSPACE);
		spinnerData.width = 150;
		spinnerData.top = new FormAttachment(0, 0);
		ausgangsdurchmesser.setLayoutData(spinnerData);
		final FormData labelData = new FormData();
		labelData.left = new FormAttachment(0, 0);
		labelData.width = STANDARD_LABEL_WIDTH;
		labelData.top = new FormAttachment(ausgangsdurchmesser, 0, CENTER);
		ausgangsdurchmesserLabel.setLayoutData(labelData);
		final FormData einheitData = new FormData();
		einheitData.left = new FormAttachment(ausgangsdurchmesser, 0, HSPACE);
		einheitData.top = new FormAttachment(ausgangsdurchmesser, 0, CENTER);
		ausgangsdurchmesserEinheitLabel.setLayoutData(einheitData);
		final FormData useDefaultData = new FormData();
		useDefaultData.left = new FormAttachment(
				ausgangsdurchmesserEinheitLabel, 0, HSPACE);
		useDefaultData.top = new FormAttachment(ausgangsdurchmesser, 0, CENTER);
		ausgangsdurchmesserUseDefault.setLayoutData(useDefaultData);

		// Listener anmelden
		ausgangsdurchmesser.addSelectionListener(new SelectionAdapter() {

			@Override
			public void widgetSelected(final SelectionEvent e) {
				final int value = ausgangsdurchmesser.getSelection();
				final SetCommand cmd = new SetCommand(getElement(),
						NetzPackage.Literals.STRASSEN_KNOTEN_DO_TYP__AUSGANGSDURCHMESSER_IN_METER,
						value);
				getCommandStack().execute(cmd);
			}

		});
		ausgangsdurchmesserUseDefault
				.addSelectionListener(new SelectionAdapter() {

					@Override
					public void widgetSelected(final SelectionEvent e) {
						if (ausgangsdurchmesserUseDefault.getSelection()) {
							final UnsetCommand cmd = new UnsetCommand(
									getElement(),
									NetzPackage.Literals.STRASSEN_KNOTEN_DO_TYP__AUSGANGSDURCHMESSER_IN_METER);
							getCommandStack().execute(cmd);
						} else {
							final int value = getElement()
									.getAusgangsdurchmesserInMeter();
							final SetCommand cmd = new SetCommand(getElement(),
									NetzPackage.Literals.STRASSEN_KNOTEN_DO_TYP__AUSGANGSDURCHMESSER_IN_METER,
									value);
							getCommandStack().execute(cmd);
						}
					}

				});
	}

	private void createMinimalerDurchmesser(final Composite parent) {
		final TabbedPropertySheetWidgetFactory factory = getWidgetFactory();

		// Widgets anlegen

		minimalerDurchmesserLabel = factory.createLabel(parent,
				"Minimaler Durchmesser:", BORDER);
		minimalerDurchmesser = new Spinner(parent, BORDER);
		minimalerDurchmesser.setMinimum(1);
		minimalerDurchmesser.setMaximum(Integer.MAX_VALUE);
		minimalerDurchmesser.setIncrement(1);
		minimalerDurchmesser.setPageIncrement(10);
		factory.adapt(parent);
		minimalerDurchmesserEinheitLabel = factory.createLabel(parent, "Pixel");
		minimalerDurchmesserUseDefault = factory.createButton(parent,
				"Defaultwert verwenden", CHECK);

		// Widgets layouten
		final FormData spinnerData = new FormData();
		spinnerData.left = new FormAttachment(minimalerDurchmesserLabel,
				HSPACE);
		spinnerData.width = 150;
		spinnerData.top = new FormAttachment(ausgangsdurchmesser, VSPACE);
		minimalerDurchmesser.setLayoutData(spinnerData);
		final FormData labelData = new FormData();
		labelData.left = new FormAttachment(0, 0);
		labelData.width = STANDARD_LABEL_WIDTH;
		labelData.top = new FormAttachment(minimalerDurchmesser, 0, CENTER);
		minimalerDurchmesserLabel.setLayoutData(labelData);
		final FormData einheitData = new FormData();
		einheitData.left = new FormAttachment(minimalerDurchmesser, 0, HSPACE);
		einheitData.top = new FormAttachment(minimalerDurchmesser, 0, CENTER);
		minimalerDurchmesserEinheitLabel.setLayoutData(einheitData);
		final FormData useDefaultData = new FormData();
		useDefaultData.left = new FormAttachment(
				minimalerDurchmesserEinheitLabel, 0, HSPACE);
		useDefaultData.top = new FormAttachment(minimalerDurchmesser, 0,
				CENTER);
		minimalerDurchmesserUseDefault.setLayoutData(useDefaultData);

		// Listener anmelden
		minimalerDurchmesser.addSelectionListener(new SelectionAdapter() {

			@Override
			public void widgetSelected(final SelectionEvent e) {
				final int value = minimalerDurchmesser.getSelection();
				final SetCommand cmd = new SetCommand(getElement(),
						NetzPackage.Literals.STRASSEN_KNOTEN_DO_TYP__MINIMALER_DURCHMESSER_IN_PIXEL,
						value);
				getCommandStack().execute(cmd);
			}

		});
		minimalerDurchmesserUseDefault
				.addSelectionListener(new SelectionAdapter() {

					@Override
					public void widgetSelected(final SelectionEvent e) {
						if (minimalerDurchmesserUseDefault.getSelection()) {
							final UnsetCommand cmd = new UnsetCommand(
									getElement(),
									NetzPackage.Literals.STRASSEN_KNOTEN_DO_TYP__MINIMALER_DURCHMESSER_IN_PIXEL);
							getCommandStack().execute(cmd);
						} else {
							final int value = getElement()
									.getMinimalerDurchmesserInPixel();
							final SetCommand cmd = new SetCommand(getElement(),
									NetzPackage.Literals.STRASSEN_KNOTEN_DO_TYP__MINIMALER_DURCHMESSER_IN_PIXEL,
									value);
							getCommandStack().execute(cmd);
						}
					}

				});
	}

	@Override
	public void refresh() {
		setAusgangsdurchmesserToWidget();
		disableAusgangsdurchmesserIfNecessary();

		setMinimalerDurchmesserToWidget();
		disableMinimalerDurchmesserIfNecessary();
	}

	private void setAusgangsdurchmesserToWidget() {
		final boolean isChanged = ausgangsdurchmesser
				.getSelection() != getElement().getAusgangsdurchmesserInMeter();
		if (isChanged) {
			ausgangsdurchmesser
					.setSelection(getElement().getAusgangsdurchmesserInMeter());
		}
	}

	private void disableAusgangsdurchmesserIfNecessary() {
		final boolean isDoKomponente = getElement()
				.eContainer() instanceof DoKomponente;
		final boolean useDefault = !getElement()
				.isSetAusgangsdurchmesserInMeter();

		ausgangsdurchmesserUseDefault.setSelection(useDefault);

		final boolean enabled = !isDoKomponente && !useDefault;
		ausgangsdurchmesser.setEnabled(enabled);
		ausgangsdurchmesserLabel.setEnabled(enabled);
	}

	private void setMinimalerDurchmesserToWidget() {
		final boolean isChanged = minimalerDurchmesser
				.getSelection() != getElement()
						.getMinimalerDurchmesserInPixel();
		if (isChanged) {
			minimalerDurchmesser.setSelection(
					getElement().getMinimalerDurchmesserInPixel());
		}
	}

	private void disableMinimalerDurchmesserIfNecessary() {
		final boolean isDoKomponente = getElement()
				.eContainer() instanceof DoKomponente;
		final boolean useDefault = !getElement()
				.isSetMinimalerDurchmesserInPixel();

		minimalerDurchmesserUseDefault.setSelection(useDefault);

		final boolean enabled = !isDoKomponente && !useDefault;
		minimalerDurchmesser.setEnabled(enabled);
		minimalerDurchmesserLabel.setEnabled(enabled);
	}

}
