/*
 * Rahmenwerk-Plug-in "Maßstäbliche Darstellung"
 * Copyright (C) 2018 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.buv.plugin.netz.strassensegment;

import static org.eclipse.swt.SWT.BORDER;
import static org.eclipse.ui.views.properties.tabbed.ITabbedPropertyConstants.HSPACE;

import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.ColorDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.views.properties.tabbed.ITabbedPropertyConstants;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;

import com.bitctrl.lib.eclipse.emf.gef.commands.SetCommand;

import de.bsvrz.buv.plugin.dobj.decorator.model.Zoomverhalten;
import de.bsvrz.buv.plugin.dobj.properties.AbstractSection;
import de.bsvrz.buv.plugin.netz.model.NetzPackage;
import de.bsvrz.buv.plugin.netz.model.StrassenSegmentDoTyp;

/**
 * PropertySection für die Darstellungseigenschaften der StrassenSegmente anhand
 * des Strassentyps.
 *
 * @author BitCtrl Systems GmbH, Ch. Hösel
 *
 */
public class StrassenSegmentDoTypPropertySection
		extends AbstractSection<StrassenSegmentDoTyp> {

	private Spinner linienstaerkeLandstrasse;
	private Spinner linienstaerkeKreisstrasse;
	private Spinner linienabstandKreisstrasse;
	private Spinner linienabstandLandstrasse;
	private Spinner linienstaerkeBundesstrasse;
	private Spinner linienabstandBundesstrasse;
	private Spinner linienstaerkeAutobahn;
	private Spinner linienabstandAutobahn;
	private Text colorTextAutobahn;
	private Text colorTextBundesstrasse;
	private Text colorTextLandstrasse;
	private Text colorTextKreisstrasse;
	private Group groupAutobahn;
	private Group groupBundesstrasse;
	private Group groupKreisstrasse;
	private Group groupLandstrasse;
	private Button useDefaultButtonAutobahn;
	private Button useDefaultButtonBundesstrasse;
	private Button useDefaultButtonLandstrasse;
	private Button useDefaultButtonKreisstrasse;
	private Button selectColorButtonAutobahn;
	private Button selectColorButtonBundesstrasse;
	private Button selectColorButtonLandstrasse;
	private Button selectColorButtonKreissstrasse;

	private Color autobahnColor;
	private Color bundesstrasseColor;
	private Color landstrasseColor;
	private Color kreisstrasseColor;
	private Button linienstaerkeDynamischesZoomverhaltenAutobahnBtn;
	private Spinner linienstaerkeMinimaleZoomstufeAutobahnSpinner;
	private Spinner linienstaerkeMaximaleZoomstufeAutobahnSpinner;
	private Spinner linienstaerkeMinimumAutobahnSpinner;
	private Spinner linienstaerkeMaximumAutobahnSpinner;
	private Button linienstaerkeStatischesZoomverhaltenAutobahnBtn;
	private Button linienstaerkeDynamischesZoomverhaltenBundesstrasseBtn;
	private Spinner linienstaerkeMinimaleZoomstufeBundesstrasseSpinner;
	private Spinner linienstaerkeMaximaleZoomstufeBundesstrasseSpinner;
	private Spinner linienstaerkeMinimumBundesstrasseSpinner;
	private Spinner linienstaerkeMaximumBundesstrasseSpinner;
	private Button linienstaerkeStatischesZoomverhaltenBundesstrasseBtn;
	private Spinner linienstaerkeMinimaleZoomstufeLandstrasseSpinner;
	private Spinner linienstaerkeMaximaleZoomstufeLandstrasseSpinner;
	private Spinner linienstaerkeMinimumLandstrasseSpinner;
	private Spinner linienstaerkeMaximumLandstrasseSpinner;
	private Button linienstaerkeStatischesZoomverhaltenLandstrasseBtn;
	private Spinner linienstaerkeMinimaleZoomstufeKreisstrasseSpinner;
	private Spinner linienstaerkeMaximaleZoomstufeKreisstrasseSpinner;
	private Spinner linienstaerkeMinimumKreisstrasseSpinner;
	private Button linienstaerkeStatischesZoomverhaltenKreisstrasseBtn;
	private Button linienstaerkeDynamischesZoomverhaltenLandstrasseBtn;
	private Button linienstaerkeDynamischesZoomverhaltenKreisstrasseBtn;
	private Spinner linienstaerkeMaximumKreisstrasseSpinner;

	@Override
	public void createControls(final Composite parent,
			final TabbedPropertySheetPage aTabbedPropertySheetPage) {
		super.createControls(parent, aTabbedPropertySheetPage);
		final TabbedPropertySheetWidgetFactory factory = getWidgetFactory();
		final Composite container = factory.createFlatFormComposite(parent);

		createAutobahnSection(factory, container);
		createBundesstrasseSection(factory, container);
		createLandstrasseSection(factory, container);
		createKreisstrasseSection(factory, container);

	}

	private void createAutobahnSection(
			final TabbedPropertySheetWidgetFactory factory,
			final Composite container) {
		groupAutobahn = factory.createGroup(container, "Autobahn");

		final GridLayout layout = new GridLayout(8, false);
		layout.horizontalSpacing = ITabbedPropertyConstants.HMARGIN;
		groupAutobahn.setLayout(layout);

		final FormData data = new FormData();
		data.left = new FormAttachment(0, HSPACE);
		data.right = new FormAttachment(100, -HSPACE);
		data.top = new FormAttachment(0, 0);
		groupAutobahn.setLayoutData(data);

		factory.createLabel(groupAutobahn, "Linienabstand:");

		linienabstandAutobahn = new Spinner(groupAutobahn, BORDER);
		linienabstandAutobahn.setMinimum(0);
		linienabstandAutobahn.setMaximum(100);
		linienabstandAutobahn.setIncrement(1);
		linienabstandAutobahn.setPageIncrement(10);
		factory.adapt(container);
		GridDataFactory.fillDefaults().applyTo(linienabstandAutobahn);

		linienabstandAutobahn.addSelectionListener(new SelectionAdapter() {

			@Override
			public void widgetSelected(final SelectionEvent e) {
				final int value = linienabstandAutobahn.getSelection();
				final SetCommand cmd = new SetCommand(getElement(),
						NetzPackage.Literals.STRASSEN_SEGMENT_DO_TYP__LINIENABSTAND_AUTOBAHN,
						value);
				getCommandStack().execute(cmd);
			}
		});

		factory.createLabel(groupAutobahn, "Farbe:");

		colorTextAutobahn = factory.createText(groupAutobahn, "",
				SWT.READ_ONLY);
		colorTextAutobahn.setEditable(false);
		colorTextAutobahn.setEnabled(false);
		selectColorButtonAutobahn = factory.createButton(groupAutobahn,
				"Ändern", SWT.PUSH);

		// Listener anmelden
		selectColorButtonAutobahn.addSelectionListener(new SelectionAdapter() {

			@Override
			public void widgetSelected(final SelectionEvent e) {
				final ColorDialog dlg = new ColorDialog(
						groupAutobahn.getShell());
				dlg.setText("Farbe auswählen");
				dlg.setRGB(getElement().getVordergrundFarbeAutobahn());
				final RGB rgb = dlg.open();
				if (rgb != null) {
					final SetCommand command = new SetCommand(getElement(),
							NetzPackage.Literals.STRASSEN_SEGMENT_DO_TYP__VORDERGRUND_FARBE_AUTOBAHN,
							rgb);
					getCommandStack().execute(command);
				}
			}
		});

		useDefaultButtonAutobahn = factory.createButton(groupAutobahn,
				"Defaultwert verwenden", SWT.CHECK);

		useDefaultButtonAutobahn.addSelectionListener(new SelectionAdapter() {

			@Override
			public void widgetSelected(final SelectionEvent e) {
				final SetCommand command = new SetCommand(getElement(),
						NetzPackage.Literals.STRASSEN_SEGMENT_DO_TYP__DEFAULT_DARSTELLUNG_AUTOBAHN,
						useDefaultButtonAutobahn.getSelection());
				getCommandStack().execute(command);
			}
		});

		final Group groupLinienstärke = factory.createGroup(groupAutobahn,
				"Linienstärke");

		GridDataFactory.fillDefaults().span(8, 1).grab(true, true)
				.applyTo(groupLinienstärke);
		GridLayoutFactory.fillDefaults().numColumns(8)
				.applyTo(groupLinienstärke);

		createLinienstaerkeStatischesZoomverhaltenAutobahn(groupLinienstärke);

		createLinienstaerkeDynamischesZoomverhaltenAutobahn(groupLinienstärke);
	}

	private void createBundesstrasseSection(
			final TabbedPropertySheetWidgetFactory factory,
			final Composite container) {
		groupBundesstrasse = factory.createGroup(container, "Bundesstraße");
		final GridLayout layout = new GridLayout(8, false);
		layout.horizontalSpacing = ITabbedPropertyConstants.HMARGIN;
		groupBundesstrasse.setLayout(layout);

		final FormData data = new FormData();
		data.left = new FormAttachment(0, HSPACE);
		data.right = new FormAttachment(100, -HSPACE);
		data.top = new FormAttachment(groupAutobahn,
				ITabbedPropertyConstants.VSPACE);
		groupBundesstrasse.setLayoutData(data);

		factory.createLabel(groupBundesstrasse, "Linienabstand:");

		linienabstandBundesstrasse = new Spinner(groupBundesstrasse, BORDER);
		linienabstandBundesstrasse.setMinimum(0);
		linienabstandBundesstrasse.setMaximum(100);
		linienabstandBundesstrasse.setIncrement(1);
		linienabstandBundesstrasse.setPageIncrement(10);
		factory.adapt(container);
		GridDataFactory.fillDefaults().applyTo(linienabstandBundesstrasse);

		linienabstandBundesstrasse.addSelectionListener(new SelectionAdapter() {

			@Override
			public void widgetSelected(final SelectionEvent e) {
				final int value = linienabstandBundesstrasse.getSelection();
				final SetCommand cmd = new SetCommand(getElement(),
						NetzPackage.Literals.STRASSEN_SEGMENT_DO_TYP__LINIENABSTAND_BUNDESSTRASSE,
						value);
				getCommandStack().execute(cmd);
			}
		});

		factory.createLabel(groupBundesstrasse, "Farbe:");

		colorTextBundesstrasse = factory.createText(groupBundesstrasse, "",
				SWT.READ_ONLY);
		colorTextBundesstrasse.setEditable(false);
		colorTextBundesstrasse.setEnabled(false);
		selectColorButtonBundesstrasse = factory
				.createButton(groupBundesstrasse, "Ändern", SWT.PUSH);

		// Listener anmelden
		selectColorButtonBundesstrasse
				.addSelectionListener(new SelectionAdapter() {

					@Override
					public void widgetSelected(final SelectionEvent e) {
						final ColorDialog dlg = new ColorDialog(
								groupBundesstrasse.getShell());
						dlg.setText("Farbe auswählen");
						dlg.setRGB(getElement().getVordergrundFarbeAutobahn());
						final RGB rgb = dlg.open();
						if (rgb != null) {
							final SetCommand command = new SetCommand(
									getElement(),
									NetzPackage.Literals.STRASSEN_SEGMENT_DO_TYP__VORDERGRUND_FARBE_BUNDESSTRASSE,
									rgb);
							getCommandStack().execute(command);
						}
					}
				});

		useDefaultButtonBundesstrasse = factory.createButton(groupBundesstrasse,
				"Defaultwert verwenden", SWT.CHECK);

		useDefaultButtonBundesstrasse
				.addSelectionListener(new SelectionAdapter() {

					@Override
					public void widgetSelected(final SelectionEvent e) {
						final SetCommand command = new SetCommand(getElement(),
								NetzPackage.Literals.STRASSEN_SEGMENT_DO_TYP__DEFAULT_DARSTELLUNG_BUNDESSTRASSE,
								useDefaultButtonBundesstrasse.getSelection());
						getCommandStack().execute(command);
					}
				});

		final Group groupLinienstärke = factory.createGroup(groupBundesstrasse,
				"Linienstärke");

		GridDataFactory.fillDefaults().span(8, 1).grab(true, true)
				.applyTo(groupLinienstärke);
		GridLayoutFactory.fillDefaults().numColumns(8)
				.applyTo(groupLinienstärke);

		createLinienstaerkeStatischesZoomverhaltenBundesstrasse(
				groupLinienstärke);

		createLinienstaerkeDynamischesZoomverhaltenBundesstrasse(
				groupLinienstärke);
	}

	private void createLandstrasseSection(
			final TabbedPropertySheetWidgetFactory factory,
			final Composite container) {
		groupLandstrasse = factory.createGroup(container, "Landstraße");
		final GridLayout layout = new GridLayout(8, false);
		layout.horizontalSpacing = ITabbedPropertyConstants.HMARGIN;
		groupLandstrasse.setLayout(layout);

		final FormData data = new FormData();
		data.left = new FormAttachment(0, HSPACE);
		data.right = new FormAttachment(100, -HSPACE);
		data.top = new FormAttachment(groupBundesstrasse,
				ITabbedPropertyConstants.VSPACE);
		groupLandstrasse.setLayoutData(data);

		factory.createLabel(groupLandstrasse, "Linienabstand:");

		linienabstandLandstrasse = new Spinner(groupLandstrasse, BORDER);
		linienabstandLandstrasse.setMinimum(0);
		linienabstandLandstrasse.setMaximum(100);
		linienabstandLandstrasse.setIncrement(1);
		linienabstandLandstrasse.setPageIncrement(10);
		factory.adapt(container);
		GridDataFactory.fillDefaults().applyTo(linienabstandLandstrasse);

		linienabstandLandstrasse.addSelectionListener(new SelectionAdapter() {

			@Override
			public void widgetSelected(final SelectionEvent e) {
				final int value = linienabstandLandstrasse.getSelection();
				final SetCommand cmd = new SetCommand(getElement(),
						NetzPackage.Literals.STRASSEN_SEGMENT_DO_TYP__LINIENABSTAND_LANDSTRASSE,
						value);
				getCommandStack().execute(cmd);
			}
		});

		factory.createLabel(groupLandstrasse, "Farbe:");

		colorTextLandstrasse = factory.createText(groupLandstrasse, "",
				SWT.READ_ONLY);
		colorTextLandstrasse.setEditable(false);
		colorTextLandstrasse.setEnabled(false);
		selectColorButtonLandstrasse = factory.createButton(groupLandstrasse,
				"Ändern", SWT.PUSH);

		// Listener anmelden
		selectColorButtonLandstrasse
				.addSelectionListener(new SelectionAdapter() {

					@Override
					public void widgetSelected(final SelectionEvent e) {
						final ColorDialog dlg = new ColorDialog(
								groupLandstrasse.getShell());
						dlg.setText("Farbe auswählen");
						dlg.setRGB(getElement().getVordergrundFarbeAutobahn());
						final RGB rgb = dlg.open();
						if (rgb != null) {
							final SetCommand command = new SetCommand(
									getElement(),
									NetzPackage.Literals.STRASSEN_SEGMENT_DO_TYP__VORDERGRUND_FARBE_LANDSTRASSE,
									rgb);
							getCommandStack().execute(command);
						}
					}
				});

		useDefaultButtonLandstrasse = factory.createButton(groupLandstrasse,
				"Defaultwert verwenden", SWT.CHECK);
		useDefaultButtonLandstrasse
				.addSelectionListener(new SelectionAdapter() {

					@Override
					public void widgetSelected(final SelectionEvent e) {
						final SetCommand command = new SetCommand(getElement(),
								NetzPackage.Literals.STRASSEN_SEGMENT_DO_TYP__DEFAULT_DARSTELLUNG_LANDSTRASSE,
								useDefaultButtonLandstrasse.getSelection());
						getCommandStack().execute(command);
					}
				});

		final Group groupLinienstärke = factory.createGroup(groupLandstrasse,
				"Linienstärke");

		GridDataFactory.fillDefaults().span(8, 1).grab(true, true)
				.applyTo(groupLinienstärke);
		GridLayoutFactory.fillDefaults().numColumns(8)
				.applyTo(groupLinienstärke);
		createLinienstaerkeStatischesZoomverhaltenLandstrasse(
				groupLinienstärke);

		createLinienstaerkeDynamischesZoomverhaltenLandstrasse(
				groupLinienstärke);
	}

	private void createKreisstrasseSection(
			final TabbedPropertySheetWidgetFactory factory,
			final Composite container) {
		groupKreisstrasse = factory.createGroup(container, "Kreisstraße");
		final GridLayout layout = new GridLayout(8, false);
		layout.horizontalSpacing = ITabbedPropertyConstants.HMARGIN;
		groupKreisstrasse.setLayout(layout);

		final FormData data = new FormData();
		data.left = new FormAttachment(0, HSPACE);
		data.right = new FormAttachment(100, -HSPACE);
		data.top = new FormAttachment(groupLandstrasse,
				ITabbedPropertyConstants.VSPACE);
		groupKreisstrasse.setLayoutData(data);

		factory.createLabel(groupKreisstrasse, "Linienabstand:");

		linienabstandKreisstrasse = new Spinner(groupKreisstrasse, BORDER);
		linienabstandKreisstrasse.setMinimum(0);
		linienabstandKreisstrasse.setMaximum(100);
		linienabstandKreisstrasse.setIncrement(1);
		linienabstandKreisstrasse.setPageIncrement(10);
		factory.adapt(container);
		GridDataFactory.fillDefaults().applyTo(linienabstandKreisstrasse);

		linienabstandKreisstrasse.addSelectionListener(new SelectionAdapter() {

			@Override
			public void widgetSelected(final SelectionEvent e) {
				final int value = linienabstandKreisstrasse.getSelection();
				final SetCommand cmd = new SetCommand(getElement(),
						NetzPackage.Literals.STRASSEN_SEGMENT_DO_TYP__LINIENABSTAND_KREISSTRASSE,
						value);
				getCommandStack().execute(cmd);
			}
		});

		factory.createLabel(groupKreisstrasse, "Farbe:");

		colorTextKreisstrasse = factory.createText(groupKreisstrasse, "",
				SWT.READ_ONLY);
		colorTextKreisstrasse.setEditable(false);
		colorTextKreisstrasse.setEnabled(false);
		selectColorButtonKreissstrasse = factory.createButton(groupKreisstrasse,
				"Ändern", SWT.PUSH);

		// Listener anmelden
		selectColorButtonKreissstrasse
				.addSelectionListener(new SelectionAdapter() {

					@Override
					public void widgetSelected(final SelectionEvent e) {
						final ColorDialog dlg = new ColorDialog(
								groupKreisstrasse.getShell());
						dlg.setText("Farbe auswählen");
						dlg.setRGB(getElement().getVordergrundFarbeAutobahn());
						final RGB rgb = dlg.open();
						if (rgb != null) {
							final SetCommand command = new SetCommand(
									getElement(),
									NetzPackage.Literals.STRASSEN_SEGMENT_DO_TYP__VORDERGRUND_FARBE_KREISSTRASSE,
									rgb);
							getCommandStack().execute(command);
						}
					}
				});

		useDefaultButtonKreisstrasse = factory.createButton(groupKreisstrasse,
				"Defaultwert verwenden", SWT.CHECK);
		useDefaultButtonKreisstrasse
				.addSelectionListener(new SelectionAdapter() {

					@Override
					public void widgetSelected(final SelectionEvent e) {
						final SetCommand command = new SetCommand(getElement(),
								NetzPackage.Literals.STRASSEN_SEGMENT_DO_TYP__DEFAULT_DARSTELLUNG_KREISSTRASSE,
								useDefaultButtonKreisstrasse.getSelection());
						getCommandStack().execute(command);
					}
				});

		final Group groupLinienstärke = factory.createGroup(groupKreisstrasse,
				"Linienstärke");

		GridDataFactory.fillDefaults().span(8, 1).grab(true, true)
				.applyTo(groupLinienstärke);
		GridLayoutFactory.fillDefaults().numColumns(8)
				.applyTo(groupLinienstärke);
		createLinienstaerkeStatischesZoomverhaltenKreisstrasse(
				groupLinienstärke);

		createLinienstaerkeDynamischesZoomverhaltenKreisstrasse(
				groupLinienstärke);
	}

	private void disposeColors() {
		if (autobahnColor != null) {
			autobahnColor.dispose();
		}
		if (bundesstrasseColor != null) {
			bundesstrasseColor.dispose();
		}
		if (landstrasseColor != null) {
			landstrasseColor.dispose();
		}
		if (kreisstrasseColor != null) {
			kreisstrasseColor.dispose();
		}
	}

	@Override
	public void dispose() {
		disposeColors();
		super.dispose();
	}

	@Override
	public void refresh() {
		super.refresh();
		disposeColors();

		refreshAutobahn();
		refreshBundesstrasse();
		refreshLandstrasse();
		refreshKreissstrasse();

	}

	private void refreshAutobahn() {
		final boolean defaultDarstellungAutobahn = getElement()
				.isDefaultDarstellungAutobahn();
		useDefaultButtonAutobahn.setSelection(defaultDarstellungAutobahn);
		linienabstandAutobahn.setEnabled(!defaultDarstellungAutobahn);
		linienabstandAutobahn
				.setSelection(getElement().getLinienabstandAutobahn());
		linienstaerkeStatischesZoomverhaltenAutobahnBtn.setSelection(
				getElement().getLinienstaerkeZoomverhaltenAutobahn()
						.equals(Zoomverhalten.STATISCHES_ZOOMVERHALTEN));
		linienstaerkeStatischesZoomverhaltenAutobahnBtn
				.setEnabled(!defaultDarstellungAutobahn);
		linienstaerkeAutobahn.setEnabled(!defaultDarstellungAutobahn
				&& linienstaerkeStatischesZoomverhaltenAutobahnBtn
						.getSelection());
		if (linienstaerkeAutobahn.getSelection() != getElement()
				.getLinienstaerkeAutobahn()) {
			linienstaerkeAutobahn
					.setSelection(getElement().getLinienstaerkeAutobahn());
		}

		linienstaerkeDynamischesZoomverhaltenAutobahnBtn.setSelection(
				getElement().getLinienstaerkeZoomverhaltenAutobahn()
						.equals(Zoomverhalten.DYNAMISCHES_ZOOMVERHALTEN));
		linienstaerkeDynamischesZoomverhaltenAutobahnBtn
				.setEnabled(!defaultDarstellungAutobahn);

		if (linienstaerkeMinimumAutobahnSpinner.getSelection() != getElement()
				.getLinienstaerkeMinimumAutobahn()) {
			linienstaerkeMinimumAutobahnSpinner.setSelection(
					getElement().getLinienstaerkeMinimumAutobahn());
		}
		linienstaerkeMinimumAutobahnSpinner
				.setEnabled(!defaultDarstellungAutobahn
						&& linienstaerkeDynamischesZoomverhaltenAutobahnBtn
								.getSelection());

		if (linienstaerkeMaximumAutobahnSpinner.getSelection() != getElement()
				.getLinienstaerkeMaximumAutobahn()) {
			linienstaerkeMaximumAutobahnSpinner.setSelection(
					getElement().getLinienstaerkeMaximumAutobahn());
		}
		linienstaerkeMaximumAutobahnSpinner
				.setEnabled(!defaultDarstellungAutobahn
						&& linienstaerkeDynamischesZoomverhaltenAutobahnBtn
								.getSelection());

		if (linienstaerkeMinimaleZoomstufeAutobahnSpinner
				.getSelection() != getElement()
						.getLinienstaerkeMinimaleZoomstufeAutobahn()) {
			linienstaerkeMinimaleZoomstufeAutobahnSpinner.setSelection(
					getElement().getLinienstaerkeMinimaleZoomstufeAutobahn());
		}
		linienstaerkeMinimaleZoomstufeAutobahnSpinner
				.setEnabled(!defaultDarstellungAutobahn
						&& linienstaerkeDynamischesZoomverhaltenAutobahnBtn
								.getSelection());

		if (linienstaerkeMaximaleZoomstufeAutobahnSpinner
				.getSelection() != getElement()
						.getLinienstaerkeMaximaleZoomstufeAutobahn()) {
			linienstaerkeMaximaleZoomstufeAutobahnSpinner.setSelection(
					getElement().getLinienstaerkeMaximaleZoomstufeAutobahn());
		}
		linienstaerkeMaximaleZoomstufeAutobahnSpinner
				.setEnabled(!defaultDarstellungAutobahn
						&& linienstaerkeDynamischesZoomverhaltenAutobahnBtn
								.getSelection());
		selectColorButtonAutobahn.setEnabled(!defaultDarstellungAutobahn);
		final RGB vordergrundFarbeAutobahn = getElement()
				.getVordergrundFarbeAutobahn();
		if (vordergrundFarbeAutobahn != null) {
			autobahnColor = new Color(colorTextAutobahn.getDisplay(),
					vordergrundFarbeAutobahn);
			colorTextAutobahn.setText(vordergrundFarbeAutobahn.toString());
			colorTextAutobahn.setBackground(autobahnColor);
		}
	}

	private void refreshBundesstrasse() {
		final boolean defaultDarstellung = getElement()
				.isDefaultDarstellungBundesstrasse();
		useDefaultButtonBundesstrasse.setSelection(defaultDarstellung);
		linienabstandBundesstrasse.setEnabled(!defaultDarstellung);
		linienabstandBundesstrasse
				.setSelection(getElement().getLinienabstandBundesstrasse());
		linienstaerkeStatischesZoomverhaltenAutobahnBtn.setSelection(
				getElement().getLinienstaerkeZoomverhaltenAutobahn()
						.equals(Zoomverhalten.STATISCHES_ZOOMVERHALTEN));
		linienstaerkeStatischesZoomverhaltenBundesstrasseBtn
				.setEnabled(!defaultDarstellung);
		linienstaerkeBundesstrasse.setEnabled(!defaultDarstellung
				&& linienstaerkeStatischesZoomverhaltenBundesstrasseBtn
						.getSelection());

		if (linienstaerkeBundesstrasse.getSelection() != getElement()
				.getLinienstaerkeBundesstrasse()) {
			linienstaerkeBundesstrasse
					.setSelection(getElement().getLinienstaerkeBundesstrasse());
		}

		linienstaerkeDynamischesZoomverhaltenBundesstrasseBtn.setSelection(
				getElement().getLinienstaerkeZoomverhaltenBundesstrasse()
						.equals(Zoomverhalten.DYNAMISCHES_ZOOMVERHALTEN));
		linienstaerkeDynamischesZoomverhaltenBundesstrasseBtn
				.setEnabled(!defaultDarstellung);

		if (linienstaerkeMinimumBundesstrasseSpinner
				.getSelection() != getElement()
						.getLinienstaerkeMinimumBundesstrasse()) {
			linienstaerkeMinimumBundesstrasseSpinner.setSelection(
					getElement().getLinienstaerkeMinimumBundesstrasse());
		}
		linienstaerkeMinimumBundesstrasseSpinner.setEnabled(!defaultDarstellung
				&& linienstaerkeDynamischesZoomverhaltenBundesstrasseBtn
						.getSelection());

		if (linienstaerkeMaximumBundesstrasseSpinner
				.getSelection() != getElement()
						.getLinienstaerkeMaximumBundesstrasse()) {
			linienstaerkeMaximumBundesstrasseSpinner.setSelection(
					getElement().getLinienstaerkeMaximumBundesstrasse());
		}
		linienstaerkeMaximumBundesstrasseSpinner.setEnabled(!defaultDarstellung
				&& linienstaerkeDynamischesZoomverhaltenBundesstrasseBtn
						.getSelection());

		if (linienstaerkeMinimaleZoomstufeBundesstrasseSpinner
				.getSelection() != getElement()
						.getLinienstaerkeMinimaleZoomstufeBundesstrasse()) {
			linienstaerkeMinimaleZoomstufeBundesstrasseSpinner
					.setSelection(getElement()
							.getLinienstaerkeMinimaleZoomstufeBundesstrasse());
		}
		linienstaerkeMinimaleZoomstufeBundesstrasseSpinner
				.setEnabled(!defaultDarstellung
						&& linienstaerkeDynamischesZoomverhaltenBundesstrasseBtn
								.getSelection());

		if (linienstaerkeMaximaleZoomstufeBundesstrasseSpinner
				.getSelection() != getElement()
						.getLinienstaerkeMaximaleZoomstufeBundesstrasse()) {
			linienstaerkeMaximaleZoomstufeBundesstrasseSpinner
					.setSelection(getElement()
							.getLinienstaerkeMaximaleZoomstufeBundesstrasse());
		}
		linienstaerkeMaximaleZoomstufeBundesstrasseSpinner
				.setEnabled(!defaultDarstellung
						&& linienstaerkeDynamischesZoomverhaltenBundesstrasseBtn
								.getSelection());

		selectColorButtonBundesstrasse.setEnabled(!defaultDarstellung);
		final RGB vordergrundFarbe = getElement()
				.getVordergrundFarbeBundesstrasse();
		if (vordergrundFarbe != null) {
			bundesstrasseColor = new Color(colorTextBundesstrasse.getDisplay(),
					vordergrundFarbe);
			colorTextBundesstrasse.setText(vordergrundFarbe.toString());
			colorTextBundesstrasse.setBackground(bundesstrasseColor);
		}
	}

	private void refreshLandstrasse() {
		final boolean defaultDarstellung = getElement()
				.isDefaultDarstellungLandstrasse();
		useDefaultButtonLandstrasse.setSelection(defaultDarstellung);
		linienabstandLandstrasse.setEnabled(!defaultDarstellung);
		linienabstandLandstrasse
				.setSelection(getElement().getLinienabstandLandstrasse());

		linienstaerkeStatischesZoomverhaltenLandstrasseBtn.setSelection(
				getElement().getLinienstaerkeZoomverhaltenLandstrasse()
						.equals(Zoomverhalten.STATISCHES_ZOOMVERHALTEN));
		linienstaerkeStatischesZoomverhaltenLandstrasseBtn
				.setEnabled(!defaultDarstellung);
		linienstaerkeLandstrasse.setEnabled(!defaultDarstellung
				&& linienstaerkeStatischesZoomverhaltenLandstrasseBtn
						.getSelection());

		if (linienstaerkeLandstrasse.getSelection() != getElement()
				.getLinienstaerkeLandstrasse()) {
			linienstaerkeLandstrasse
					.setSelection(getElement().getLinienstaerkeLandstrasse());
		}

		linienstaerkeDynamischesZoomverhaltenLandstrasseBtn.setSelection(
				getElement().getLinienstaerkeZoomverhaltenLandstrasse()
						.equals(Zoomverhalten.DYNAMISCHES_ZOOMVERHALTEN));
		linienstaerkeDynamischesZoomverhaltenLandstrasseBtn
				.setEnabled(!defaultDarstellung);

		if (linienstaerkeMinimumLandstrasseSpinner
				.getSelection() != getElement()
						.getLinienstaerkeMinimumLandstrasse()) {
			linienstaerkeMinimumLandstrasseSpinner.setSelection(
					getElement().getLinienstaerkeMinimumLandstrasse());
		}
		linienstaerkeMinimumLandstrasseSpinner.setEnabled(!defaultDarstellung
				&& linienstaerkeDynamischesZoomverhaltenLandstrasseBtn
						.getSelection());

		if (linienstaerkeMaximumLandstrasseSpinner
				.getSelection() != getElement()
						.getLinienstaerkeMaximumLandstrasse()) {
			linienstaerkeMaximumLandstrasseSpinner.setSelection(
					getElement().getLinienstaerkeMaximumLandstrasse());
		}
		linienstaerkeMaximumLandstrasseSpinner.setEnabled(!defaultDarstellung
				&& linienstaerkeDynamischesZoomverhaltenLandstrasseBtn
						.getSelection());

		if (linienstaerkeMinimaleZoomstufeLandstrasseSpinner
				.getSelection() != getElement()
						.getLinienstaerkeMinimaleZoomstufeLandstrasse()) {
			linienstaerkeMinimaleZoomstufeLandstrasseSpinner
					.setSelection(getElement()
							.getLinienstaerkeMinimaleZoomstufeLandstrasse());
		}
		linienstaerkeMinimaleZoomstufeLandstrasseSpinner
				.setEnabled(!defaultDarstellung
						&& linienstaerkeDynamischesZoomverhaltenLandstrasseBtn
								.getSelection());

		if (linienstaerkeMaximaleZoomstufeLandstrasseSpinner
				.getSelection() != getElement()
						.getLinienstaerkeMaximaleZoomstufeLandstrasse()) {
			linienstaerkeMaximaleZoomstufeLandstrasseSpinner
					.setSelection(getElement()
							.getLinienstaerkeMaximaleZoomstufeLandstrasse());
		}
		linienstaerkeMaximaleZoomstufeLandstrasseSpinner
				.setEnabled(!defaultDarstellung
						&& linienstaerkeDynamischesZoomverhaltenLandstrasseBtn
								.getSelection());

		selectColorButtonLandstrasse.setEnabled(!defaultDarstellung);
		final RGB vordergrundFarbe = getElement()
				.getVordergrundFarbeLandstrasse();
		if (vordergrundFarbe != null) {
			landstrasseColor = new Color(colorTextLandstrasse.getDisplay(),
					vordergrundFarbe);
			colorTextLandstrasse.setText(vordergrundFarbe.toString());
			colorTextLandstrasse.setBackground(landstrasseColor);
		}
	}

	private void refreshKreissstrasse() {
		final boolean defaultDarstellung = getElement()
				.isDefaultDarstellungKreisstrasse();
		useDefaultButtonKreisstrasse.setSelection(defaultDarstellung);
		linienabstandKreisstrasse.setEnabled(!defaultDarstellung);

		if (linienabstandKreisstrasse.getSelection() != getElement()
				.getLinienabstandKreisstrasse()) {
			linienabstandKreisstrasse
					.setSelection(getElement().getLinienabstandKreisstrasse());
		}

		linienstaerkeStatischesZoomverhaltenKreisstrasseBtn.setSelection(
				getElement().getLinienstaerkeZoomverhaltenKreisstrasse()
						.equals(Zoomverhalten.STATISCHES_ZOOMVERHALTEN));
		linienstaerkeStatischesZoomverhaltenKreisstrasseBtn
				.setEnabled(!defaultDarstellung);
		linienstaerkeKreisstrasse.setEnabled(!defaultDarstellung
				&& linienstaerkeStatischesZoomverhaltenKreisstrasseBtn
						.getSelection());

		if (linienstaerkeKreisstrasse.getSelection() != getElement()
				.getLinienstaerkeKreisstrasse()) {
			linienstaerkeKreisstrasse
					.setSelection(getElement().getLinienstaerkeKreisstrasse());
		}

		linienstaerkeDynamischesZoomverhaltenKreisstrasseBtn.setSelection(
				getElement().getLinienstaerkeZoomverhaltenKreisstrasse()
						.equals(Zoomverhalten.DYNAMISCHES_ZOOMVERHALTEN));
		linienstaerkeDynamischesZoomverhaltenKreisstrasseBtn
				.setEnabled(!defaultDarstellung);

		if (linienstaerkeMinimumKreisstrasseSpinner
				.getSelection() != getElement()
						.getLinienstaerkeMinimumKreisstrasse()) {
			linienstaerkeMinimumKreisstrasseSpinner.setSelection(
					getElement().getLinienstaerkeMinimumKreisstrasse());
		}
		linienstaerkeMinimumKreisstrasseSpinner.setEnabled(!defaultDarstellung
				&& linienstaerkeDynamischesZoomverhaltenKreisstrasseBtn
						.getSelection());

		if (linienstaerkeMaximumKreisstrasseSpinner
				.getSelection() != getElement()
						.getLinienstaerkeMaximumKreisstrasse()) {
			linienstaerkeMaximumKreisstrasseSpinner.setSelection(
					getElement().getLinienstaerkeMaximumKreisstrasse());
		}
		linienstaerkeMaximumKreisstrasseSpinner.setEnabled(!defaultDarstellung
				&& linienstaerkeDynamischesZoomverhaltenKreisstrasseBtn
						.getSelection());

		if (linienstaerkeMinimaleZoomstufeKreisstrasseSpinner
				.getSelection() != getElement()
						.getLinienstaerkeMinimaleZoomstufeKreisstrasse()) {
			linienstaerkeMinimaleZoomstufeKreisstrasseSpinner
					.setSelection(getElement()
							.getLinienstaerkeMinimaleZoomstufeKreisstrasse());
		}
		linienstaerkeMinimaleZoomstufeKreisstrasseSpinner
				.setEnabled(!defaultDarstellung
						&& linienstaerkeDynamischesZoomverhaltenKreisstrasseBtn
								.getSelection());

		if (linienstaerkeMaximaleZoomstufeKreisstrasseSpinner
				.getSelection() != getElement()
						.getLinienstaerkeMaximaleZoomstufeKreisstrasse()) {
			linienstaerkeMaximaleZoomstufeKreisstrasseSpinner
					.setSelection(getElement()
							.getLinienstaerkeMaximaleZoomstufeKreisstrasse());
		}
		linienstaerkeMaximaleZoomstufeKreisstrasseSpinner
				.setEnabled(!defaultDarstellung
						&& linienstaerkeDynamischesZoomverhaltenKreisstrasseBtn
								.getSelection());

		selectColorButtonKreissstrasse.setEnabled(!defaultDarstellung);
		final RGB vordergrundFarbe = getElement()
				.getVordergrundFarbeKreisstrasse();
		if (vordergrundFarbe != null) {
			kreisstrasseColor = new Color(colorTextKreisstrasse.getDisplay(),
					vordergrundFarbe);
			colorTextKreisstrasse.setText(vordergrundFarbe.toString());
			colorTextKreisstrasse.setBackground(kreisstrasseColor);
		}
	}

	private void createLinienstaerkeDynamischesZoomverhaltenAutobahn(
			final Composite container) {
		final TabbedPropertySheetWidgetFactory factory = getWidgetFactory();

		linienstaerkeDynamischesZoomverhaltenAutobahnBtn = getWidgetFactory()
				.createButton(container,
						Zoomverhalten.DYNAMISCHES_ZOOMVERHALTEN.getLiteral(),
						SWT.RADIO);
		GridDataFactory.fillDefaults().span(3, 1)
				.applyTo(linienstaerkeDynamischesZoomverhaltenAutobahnBtn);

		final Group dynamischesZoomverhaltenGroup = getWidgetFactory()
				.createGroup(container, "");
		GridDataFactory.fillDefaults().span(5, 1)
				.applyTo(dynamischesZoomverhaltenGroup);
		GridLayoutFactory.swtDefaults().numColumns(8)
				.applyTo(dynamischesZoomverhaltenGroup);

		createLinienstaerkeDynamischeZoomstufenAutobahn(factory,
				dynamischesZoomverhaltenGroup);

		createLinienstaerkeDynamischeLinienstaerkeAutobahn(factory,
				dynamischesZoomverhaltenGroup);

		linienstaerkeDynamischesZoomverhaltenAutobahnBtn
				.addSelectionListener(new SelectionAdapter() {

					@Override
					public void widgetSelected(final SelectionEvent e) {
						final SetCommand cmd = new SetCommand(getElement(),
								NetzPackage.Literals.STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_ZOOMVERHALTEN_AUTOBAHN,
								Zoomverhalten.DYNAMISCHES_ZOOMVERHALTEN);
						getCommandStack().execute(cmd);
					}
				});

	}

	private void createLinienstaerkeDynamischeZoomstufenAutobahn(
			final TabbedPropertySheetWidgetFactory factory,
			final Group dynamischesZoomverhaltenGroup) {
		factory.createLabel(dynamischesZoomverhaltenGroup,
				"Minimale Zoomstufe (in %):");

		linienstaerkeMinimaleZoomstufeAutobahnSpinner = new Spinner(
				dynamischesZoomverhaltenGroup, SWT.BORDER);
		linienstaerkeMinimaleZoomstufeAutobahnSpinner.setValues(1, 1,
				Integer.MAX_VALUE, 0, 1, 100);
		factory.adapt(linienstaerkeMinimaleZoomstufeAutobahnSpinner);
		linienstaerkeMinimaleZoomstufeAutobahnSpinner
				.addSelectionListener(new SelectionAdapter() {

					@Override
					public void widgetSelected(final SelectionEvent e) {
						final int wert = linienstaerkeMinimaleZoomstufeAutobahnSpinner
								.getSelection();
						getCommandStack().execute(new SetCommand(getElement(),
								NetzPackage.Literals.STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_MINIMALE_ZOOMSTUFE_AUTOBAHN,
								wert));
					}

				});

		factory.createLabel(dynamischesZoomverhaltenGroup,
				"Maximale Zoomstufe (in %):");

		linienstaerkeMaximaleZoomstufeAutobahnSpinner = new Spinner(
				dynamischesZoomverhaltenGroup, SWT.BORDER);
		linienstaerkeMaximaleZoomstufeAutobahnSpinner.setValues(5000, 0,
				Integer.MAX_VALUE, 0, 1, 100);
		factory.adapt(linienstaerkeMaximaleZoomstufeAutobahnSpinner);
		linienstaerkeMaximaleZoomstufeAutobahnSpinner
				.addSelectionListener(new SelectionAdapter() {

					@Override
					public void widgetSelected(final SelectionEvent e) {
						final int wert = linienstaerkeMaximaleZoomstufeAutobahnSpinner
								.getSelection();
						getCommandStack().execute(new SetCommand(getElement(),
								NetzPackage.Literals.STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_MAXIMALE_ZOOMSTUFE_AUTOBAHN,
								wert));

					}

				});

	}

	private void createLinienstaerkeDynamischeLinienstaerkeAutobahn(
			final TabbedPropertySheetWidgetFactory factory,
			final Group dynamischesZoomverhaltenGroup) {
		factory.createLabel(dynamischesZoomverhaltenGroup,
				"Minimale Linienstärke:");

		linienstaerkeMinimumAutobahnSpinner = new Spinner(
				dynamischesZoomverhaltenGroup, SWT.BORDER);
		linienstaerkeMinimumAutobahnSpinner.setValues(1, 1, Integer.MAX_VALUE,
				0, 1, 100);
		factory.adapt(linienstaerkeMinimumAutobahnSpinner);
		linienstaerkeMinimumAutobahnSpinner
				.addSelectionListener(new SelectionAdapter() {

					@Override
					public void widgetSelected(final SelectionEvent e) {
						final int wert = linienstaerkeMinimumAutobahnSpinner
								.getSelection();

						getCommandStack().execute(new SetCommand(getElement(),
								NetzPackage.Literals.STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_MINIMUM_AUTOBAHN,
								wert));
					}
				});

		factory.createLabel(dynamischesZoomverhaltenGroup,
				"Maximale Linienstärke");

		linienstaerkeMaximumAutobahnSpinner = new Spinner(
				dynamischesZoomverhaltenGroup, SWT.BORDER);
		linienstaerkeMaximumAutobahnSpinner.setValues(5000, 0,
				Integer.MAX_VALUE, 0, 1, 100);
		factory.adapt(linienstaerkeMaximumAutobahnSpinner);

		linienstaerkeMaximumAutobahnSpinner
				.addSelectionListener(new SelectionAdapter() {

					@Override
					public void widgetSelected(final SelectionEvent e) {
						final int wert = linienstaerkeMaximumAutobahnSpinner
								.getSelection();

						getCommandStack().execute(new SetCommand(getElement(),
								NetzPackage.Literals.STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_MAXIMUM_AUTOBAHN,
								wert));
					}
				});

	}

	private void createLinienstaerkeStatischesZoomverhaltenAutobahn(
			final Composite parent) {
		final TabbedPropertySheetWidgetFactory factory = getWidgetFactory();

		// Widgets anlegen

		linienstaerkeStatischesZoomverhaltenAutobahnBtn = getWidgetFactory()
				.createButton(parent,
						Zoomverhalten.STATISCHES_ZOOMVERHALTEN.getLiteral(),
						SWT.RADIO);
		linienstaerkeStatischesZoomverhaltenAutobahnBtn.setSelection(true);
		GridDataFactory.fillDefaults().span(3, 1)
				.applyTo(linienstaerkeStatischesZoomverhaltenAutobahnBtn);

		final Group statischesZoomverhaltenGroup = getWidgetFactory()
				.createGroup(parent, "");
		GridDataFactory.fillDefaults().grab(true, false).span(5, 1)
				.applyTo(statischesZoomverhaltenGroup);
		GridLayoutFactory.fillDefaults().numColumns(2)
				.applyTo(statischesZoomverhaltenGroup);

		factory.createLabel(statischesZoomverhaltenGroup, "Linienstärke:");

		linienstaerkeAutobahn = new Spinner(statischesZoomverhaltenGroup,
				BORDER);
		linienstaerkeAutobahn.setMinimum(1);
		linienstaerkeAutobahn.setMaximum(100);
		linienstaerkeAutobahn.setIncrement(1);
		linienstaerkeAutobahn.setPageIncrement(10);
		factory.adapt(parent);

		// Listener anmelden

		linienstaerkeStatischesZoomverhaltenAutobahnBtn
				.addSelectionListener(new SelectionAdapter() {

					@Override
					public void widgetSelected(final SelectionEvent e) {
						final SetCommand cmd = new SetCommand(getElement(),
								NetzPackage.Literals.STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_ZOOMVERHALTEN_AUTOBAHN,
								Zoomverhalten.STATISCHES_ZOOMVERHALTEN);
						getCommandStack().execute(cmd);
					}
				});

		linienstaerkeAutobahn.addSelectionListener(new SelectionAdapter() {

			@Override
			public void widgetSelected(final SelectionEvent e) {
				final int wert = linienstaerkeAutobahn.getSelection();

				getCommandStack().execute(new SetCommand(getElement(),
						NetzPackage.Literals.STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_AUTOBAHN,
						wert));
			}
		});
	}

	private void createLinienstaerkeDynamischesZoomverhaltenBundesstrasse(
			final Composite container) {
		final TabbedPropertySheetWidgetFactory factory = getWidgetFactory();

		linienstaerkeDynamischesZoomverhaltenBundesstrasseBtn = getWidgetFactory()
				.createButton(container,
						Zoomverhalten.DYNAMISCHES_ZOOMVERHALTEN.getLiteral(),
						SWT.RADIO);
		GridDataFactory.fillDefaults().span(3, 1)
				.applyTo(linienstaerkeDynamischesZoomverhaltenBundesstrasseBtn);

		final Group dynamischesZoomverhaltenGroup = getWidgetFactory()
				.createGroup(container, "");
		GridDataFactory.fillDefaults().span(5, 1)
				.applyTo(dynamischesZoomverhaltenGroup);
		GridLayoutFactory.swtDefaults().numColumns(8)
				.applyTo(dynamischesZoomverhaltenGroup);

		createLinienstaerkeDynamischeZoomstufenBundesstrasse(factory,
				dynamischesZoomverhaltenGroup);

		createLinienstaerkeDynamischeLinienstaerkeBundesstrasse(factory,
				dynamischesZoomverhaltenGroup);

		linienstaerkeDynamischesZoomverhaltenBundesstrasseBtn
				.addSelectionListener(new SelectionAdapter() {

					@Override
					public void widgetSelected(final SelectionEvent e) {
						final SetCommand cmd = new SetCommand(getElement(),
								NetzPackage.Literals.STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_ZOOMVERHALTEN_BUNDESSTRASSE,
								Zoomverhalten.DYNAMISCHES_ZOOMVERHALTEN);
						getCommandStack().execute(cmd);
					}
				});

	}

	private void createLinienstaerkeDynamischeZoomstufenBundesstrasse(
			final TabbedPropertySheetWidgetFactory factory,
			final Group dynamischesZoomverhaltenGroup) {
		factory.createLabel(dynamischesZoomverhaltenGroup,
				"Minimale Zoomstufe (in %):");

		linienstaerkeMinimaleZoomstufeBundesstrasseSpinner = new Spinner(
				dynamischesZoomverhaltenGroup, SWT.BORDER);

		linienstaerkeMinimaleZoomstufeBundesstrasseSpinner.setValues(1, 1,
				Integer.MAX_VALUE, 0, 1, 100);
		factory.adapt(linienstaerkeMinimaleZoomstufeBundesstrasseSpinner);
		linienstaerkeMinimaleZoomstufeBundesstrasseSpinner
				.addSelectionListener(new SelectionAdapter() {

					@Override
					public void widgetSelected(final SelectionEvent e) {
						final int wert = linienstaerkeMinimaleZoomstufeBundesstrasseSpinner
								.getSelection();
						getCommandStack().execute(new SetCommand(getElement(),
								NetzPackage.Literals.STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_MINIMALE_ZOOMSTUFE_BUNDESSTRASSE,
								wert));
					}

				});

		factory.createLabel(dynamischesZoomverhaltenGroup,
				"Maximale Zoomstufe (in %):");

		linienstaerkeMaximaleZoomstufeBundesstrasseSpinner = new Spinner(
				dynamischesZoomverhaltenGroup, SWT.BORDER);
		linienstaerkeMaximaleZoomstufeBundesstrasseSpinner.setValues(5000, 0,
				Integer.MAX_VALUE, 0, 1, 100);
		factory.adapt(linienstaerkeMaximaleZoomstufeBundesstrasseSpinner);
		linienstaerkeMaximaleZoomstufeBundesstrasseSpinner
				.addSelectionListener(new SelectionAdapter() {

					@Override
					public void widgetSelected(final SelectionEvent e) {
						final int wert = linienstaerkeMaximaleZoomstufeBundesstrasseSpinner
								.getSelection();
						getCommandStack().execute(new SetCommand(getElement(),
								NetzPackage.Literals.STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_MAXIMALE_ZOOMSTUFE_BUNDESSTRASSE,
								wert));

					}

				});

	}

	private void createLinienstaerkeDynamischeLinienstaerkeBundesstrasse(
			final TabbedPropertySheetWidgetFactory factory,
			final Group dynamischesZoomverhaltenGroup) {
		factory.createLabel(dynamischesZoomverhaltenGroup,
				"Minimale Linienstärke:");

		linienstaerkeMinimumBundesstrasseSpinner = new Spinner(
				dynamischesZoomverhaltenGroup, SWT.BORDER);
		linienstaerkeMinimumBundesstrasseSpinner.setValues(1, 1,
				Integer.MAX_VALUE, 0, 1, 100);
		factory.adapt(linienstaerkeMinimumBundesstrasseSpinner);
		linienstaerkeMinimumBundesstrasseSpinner
				.addSelectionListener(new SelectionAdapter() {

					@Override
					public void widgetSelected(final SelectionEvent e) {
						final int wert = linienstaerkeMinimumBundesstrasseSpinner
								.getSelection();

						getCommandStack().execute(new SetCommand(getElement(),
								NetzPackage.Literals.STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_MINIMUM_BUNDESSTRASSE,
								wert));
					}
				});

		factory.createLabel(dynamischesZoomverhaltenGroup,
				"Maximale Linienstärke");

		linienstaerkeMaximumBundesstrasseSpinner = new Spinner(
				dynamischesZoomverhaltenGroup, SWT.BORDER);
		linienstaerkeMaximumBundesstrasseSpinner.setValues(5000, 0,
				Integer.MAX_VALUE, 0, 1, 100);
		factory.adapt(linienstaerkeMaximumBundesstrasseSpinner);

		linienstaerkeMaximumBundesstrasseSpinner
				.addSelectionListener(new SelectionAdapter() {

					@Override
					public void widgetSelected(final SelectionEvent e) {
						final int wert = linienstaerkeMaximumBundesstrasseSpinner
								.getSelection();

						getCommandStack().execute(new SetCommand(getElement(),
								NetzPackage.Literals.STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_MAXIMUM_BUNDESSTRASSE,
								wert));
					}
				});

	}

	private void createLinienstaerkeStatischesZoomverhaltenBundesstrasse(
			final Composite parent) {
		final TabbedPropertySheetWidgetFactory factory = getWidgetFactory();

		linienstaerkeStatischesZoomverhaltenBundesstrasseBtn = getWidgetFactory()
				.createButton(parent,
						Zoomverhalten.STATISCHES_ZOOMVERHALTEN.getLiteral(),
						SWT.RADIO);
		GridDataFactory.fillDefaults().span(3, 1)
				.applyTo(linienstaerkeStatischesZoomverhaltenBundesstrasseBtn);

		final Group statischesZoomverhaltenGroup = getWidgetFactory()
				.createGroup(parent, "");
		GridDataFactory.fillDefaults().span(5, 1).grab(true, false)
				.applyTo(statischesZoomverhaltenGroup);
		GridLayoutFactory.fillDefaults().numColumns(2)
				.applyTo(statischesZoomverhaltenGroup);

		factory.createLabel(statischesZoomverhaltenGroup, "Linienstärke:");

		linienstaerkeBundesstrasse = new Spinner(statischesZoomverhaltenGroup,
				BORDER);
		linienstaerkeBundesstrasse.setMinimum(1);
		linienstaerkeBundesstrasse.setMaximum(100);
		linienstaerkeBundesstrasse.setIncrement(1);
		linienstaerkeBundesstrasse.setPageIncrement(10);
		factory.adapt(parent);

		linienstaerkeStatischesZoomverhaltenBundesstrasseBtn
				.addSelectionListener(new SelectionAdapter() {

					@Override
					public void widgetSelected(final SelectionEvent e) {
						final SetCommand cmd = new SetCommand(getElement(),
								NetzPackage.Literals.STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_ZOOMVERHALTEN_BUNDESSTRASSE,
								Zoomverhalten.STATISCHES_ZOOMVERHALTEN);
						getCommandStack().execute(cmd);
					}
				});

		linienstaerkeBundesstrasse.addSelectionListener(new SelectionAdapter() {

			@Override
			public void widgetSelected(final SelectionEvent e) {
				final int wert = linienstaerkeBundesstrasse.getSelection();

				getCommandStack().execute(new SetCommand(getElement(),
						NetzPackage.Literals.STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_BUNDESSTRASSE,
						wert));
			}
		});
	}

	private void createLinienstaerkeDynamischesZoomverhaltenLandstrasse(
			final Composite container) {
		final TabbedPropertySheetWidgetFactory factory = getWidgetFactory();

		linienstaerkeDynamischesZoomverhaltenLandstrasseBtn = getWidgetFactory()
				.createButton(container,
						Zoomverhalten.DYNAMISCHES_ZOOMVERHALTEN.getLiteral(),
						SWT.RADIO);
		GridDataFactory.fillDefaults().span(3, 1)
				.applyTo(linienstaerkeDynamischesZoomverhaltenLandstrasseBtn);

		final Group dynamischesZoomverhaltenGroup = getWidgetFactory()
				.createGroup(container, "");
		GridDataFactory.fillDefaults().span(5, 1)
				.applyTo(dynamischesZoomverhaltenGroup);
		GridLayoutFactory.swtDefaults().numColumns(8)
				.applyTo(dynamischesZoomverhaltenGroup);

		createLinienstaerkeDynamischeZoomstufenLandstrasse(factory,
				dynamischesZoomverhaltenGroup);

		createLinienstaerkeDynamischeLinienstaerkeLandstrasse(factory,
				dynamischesZoomverhaltenGroup);

		linienstaerkeDynamischesZoomverhaltenLandstrasseBtn
				.addSelectionListener(new SelectionAdapter() {

					@Override
					public void widgetSelected(final SelectionEvent e) {
						final SetCommand cmd = new SetCommand(getElement(),
								NetzPackage.Literals.STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_ZOOMVERHALTEN_LANDSTRASSE,
								Zoomverhalten.DYNAMISCHES_ZOOMVERHALTEN);
						getCommandStack().execute(cmd);
					}
				});

	}

	private void createLinienstaerkeDynamischeZoomstufenLandstrasse(
			final TabbedPropertySheetWidgetFactory factory,
			final Group dynamischesZoomverhaltenGroup) {
		factory.createLabel(dynamischesZoomverhaltenGroup,
				"Minimale Zoomstufe (in %):");

		linienstaerkeMinimaleZoomstufeLandstrasseSpinner = new Spinner(
				dynamischesZoomverhaltenGroup, SWT.BORDER);

		linienstaerkeMinimaleZoomstufeLandstrasseSpinner.setValues(1, 1,
				Integer.MAX_VALUE, 0, 1, 100);
		factory.adapt(linienstaerkeMinimaleZoomstufeLandstrasseSpinner);
		linienstaerkeMinimaleZoomstufeLandstrasseSpinner
				.addSelectionListener(new SelectionAdapter() {

					@Override
					public void widgetSelected(final SelectionEvent e) {
						final int wert = linienstaerkeMinimaleZoomstufeLandstrasseSpinner
								.getSelection();
						getCommandStack().execute(new SetCommand(getElement(),
								NetzPackage.Literals.STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_MINIMALE_ZOOMSTUFE_LANDSTRASSE,
								wert));
					}

				});

		factory.createLabel(dynamischesZoomverhaltenGroup,
				"Maximale Zoomstufe (in %):");

		linienstaerkeMaximaleZoomstufeLandstrasseSpinner = new Spinner(
				dynamischesZoomverhaltenGroup, SWT.BORDER);
		linienstaerkeMaximaleZoomstufeLandstrasseSpinner.setValues(5000, 0,
				Integer.MAX_VALUE, 0, 1, 100);
		factory.adapt(linienstaerkeMaximaleZoomstufeLandstrasseSpinner);
		linienstaerkeMaximaleZoomstufeLandstrasseSpinner
				.addSelectionListener(new SelectionAdapter() {

					@Override
					public void widgetSelected(final SelectionEvent e) {
						final int wert = linienstaerkeMaximaleZoomstufeLandstrasseSpinner
								.getSelection();
						getCommandStack().execute(new SetCommand(getElement(),
								NetzPackage.Literals.STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_MAXIMALE_ZOOMSTUFE_LANDSTRASSE,
								wert));

					}

				});

	}

	private void createLinienstaerkeDynamischeLinienstaerkeLandstrasse(
			final TabbedPropertySheetWidgetFactory factory,
			final Group dynamischesZoomverhaltenGroup) {
		factory.createLabel(dynamischesZoomverhaltenGroup,
				"Minimale Linienstärke:");

		linienstaerkeMinimumLandstrasseSpinner = new Spinner(
				dynamischesZoomverhaltenGroup, SWT.BORDER);
		linienstaerkeMinimumLandstrasseSpinner.setValues(1, 1,
				Integer.MAX_VALUE, 0, 1, 100);
		factory.adapt(linienstaerkeMinimumLandstrasseSpinner);
		linienstaerkeMinimumLandstrasseSpinner
				.addSelectionListener(new SelectionAdapter() {

					@Override
					public void widgetSelected(final SelectionEvent e) {
						final int wert = linienstaerkeMinimumLandstrasseSpinner
								.getSelection();

						getCommandStack().execute(new SetCommand(getElement(),
								NetzPackage.Literals.STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_MINIMALE_ZOOMSTUFE_LANDSTRASSE,
								wert));
					}
				});

		factory.createLabel(dynamischesZoomverhaltenGroup,
				"Maximale Linienstärke");

		linienstaerkeMaximumLandstrasseSpinner = new Spinner(
				dynamischesZoomverhaltenGroup, SWT.BORDER);
		linienstaerkeMaximumLandstrasseSpinner.setValues(5000, 0,
				Integer.MAX_VALUE, 0, 1, 100);
		factory.adapt(linienstaerkeMaximumLandstrasseSpinner);

		linienstaerkeMaximumLandstrasseSpinner
				.addSelectionListener(new SelectionAdapter() {

					@Override
					public void widgetSelected(final SelectionEvent e) {
						final int wert = linienstaerkeMaximumLandstrasseSpinner
								.getSelection();

						getCommandStack().execute(new SetCommand(getElement(),
								NetzPackage.Literals.STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_MAXIMUM_LANDSTRASSE,
								wert));
					}
				});

	}

	private void createLinienstaerkeStatischesZoomverhaltenLandstrasse(
			final Composite parent) {
		final TabbedPropertySheetWidgetFactory factory = getWidgetFactory();

		// Widgets anlegen

		linienstaerkeStatischesZoomverhaltenLandstrasseBtn = getWidgetFactory()
				.createButton(parent,
						Zoomverhalten.STATISCHES_ZOOMVERHALTEN.getLiteral(),
						SWT.RADIO);
		linienstaerkeStatischesZoomverhaltenLandstrasseBtn.setSelection(true);
		GridDataFactory.fillDefaults().span(3, 1)
				.applyTo(linienstaerkeStatischesZoomverhaltenLandstrasseBtn);

		final Group statischesZoomverhaltenGroup = getWidgetFactory()
				.createGroup(parent, "");
		GridDataFactory.fillDefaults().span(5, 1)
				.applyTo(statischesZoomverhaltenGroup);
		GridLayoutFactory.fillDefaults().numColumns(2)
				.applyTo(statischesZoomverhaltenGroup);

		factory.createLabel(statischesZoomverhaltenGroup, "Linienstärke:");

		linienstaerkeLandstrasse = new Spinner(statischesZoomverhaltenGroup,
				BORDER);
		linienstaerkeLandstrasse.setMinimum(1);
		linienstaerkeLandstrasse.setMaximum(100);
		linienstaerkeLandstrasse.setIncrement(1);
		linienstaerkeLandstrasse.setPageIncrement(10);
		factory.adapt(parent);

		// Listener anmelden

		linienstaerkeStatischesZoomverhaltenLandstrasseBtn
				.addSelectionListener(new SelectionAdapter() {

					@Override
					public void widgetSelected(final SelectionEvent e) {
						final SetCommand cmd = new SetCommand(getElement(),
								NetzPackage.Literals.STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_ZOOMVERHALTEN_LANDSTRASSE,
								Zoomverhalten.STATISCHES_ZOOMVERHALTEN);
						getCommandStack().execute(cmd);
					}
				});

		linienstaerkeLandstrasse.addSelectionListener(new SelectionAdapter() {

			@Override
			public void widgetSelected(final SelectionEvent e) {
				final int wert = linienstaerkeLandstrasse.getSelection();

				getCommandStack().execute(new SetCommand(getElement(),
						NetzPackage.Literals.STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_LANDSTRASSE,
						wert));
			}
		});
	}

	private void createLinienstaerkeDynamischesZoomverhaltenKreisstrasse(
			final Composite container) {
		final TabbedPropertySheetWidgetFactory factory = getWidgetFactory();

		linienstaerkeDynamischesZoomverhaltenKreisstrasseBtn = getWidgetFactory()
				.createButton(container,
						Zoomverhalten.DYNAMISCHES_ZOOMVERHALTEN.getLiteral(),
						SWT.RADIO);
		GridDataFactory.fillDefaults().span(3, 1)
				.applyTo(linienstaerkeDynamischesZoomverhaltenKreisstrasseBtn);

		final Group dynamischesZoomverhaltenGroup = getWidgetFactory()
				.createGroup(container, "");
		GridDataFactory.fillDefaults().span(5, 1)
				.applyTo(dynamischesZoomverhaltenGroup);
		GridLayoutFactory.swtDefaults().numColumns(8)
				.applyTo(dynamischesZoomverhaltenGroup);

		createLinienstaerkeDynamischeZoomstufenKreisstrasse(factory,
				dynamischesZoomverhaltenGroup);

		createLinienstaerkeDynamischeLinienstaerkeKreisstrasse(factory,
				dynamischesZoomverhaltenGroup);

		linienstaerkeDynamischesZoomverhaltenKreisstrasseBtn
				.addSelectionListener(new SelectionAdapter() {

					@Override
					public void widgetSelected(final SelectionEvent e) {
						final SetCommand cmd = new SetCommand(getElement(),
								NetzPackage.Literals.STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_ZOOMVERHALTEN_KREISSTRASSE,
								Zoomverhalten.DYNAMISCHES_ZOOMVERHALTEN);
						getCommandStack().execute(cmd);
					}
				});

	}

	private void createLinienstaerkeDynamischeZoomstufenKreisstrasse(
			final TabbedPropertySheetWidgetFactory factory,
			final Group dynamischesZoomverhaltenGroup) {
		factory.createLabel(dynamischesZoomverhaltenGroup,
				"Minimale Zoomstufe (in %):");

		linienstaerkeMinimaleZoomstufeKreisstrasseSpinner = new Spinner(
				dynamischesZoomverhaltenGroup, SWT.BORDER);

		linienstaerkeMinimaleZoomstufeKreisstrasseSpinner.setValues(1, 1,
				Integer.MAX_VALUE, 0, 1, 100);
		factory.adapt(linienstaerkeMinimaleZoomstufeKreisstrasseSpinner);
		linienstaerkeMinimaleZoomstufeKreisstrasseSpinner
				.addSelectionListener(new SelectionAdapter() {

					@Override
					public void widgetSelected(final SelectionEvent e) {
						final int wert = linienstaerkeMinimaleZoomstufeKreisstrasseSpinner
								.getSelection();
						getCommandStack().execute(new SetCommand(getElement(),
								NetzPackage.Literals.STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_MINIMALE_ZOOMSTUFE_KREISSTRASSE,
								wert));
					}

				});

		factory.createLabel(dynamischesZoomverhaltenGroup,
				"Maximale Zoomstufe (in %):");

		linienstaerkeMaximaleZoomstufeKreisstrasseSpinner = new Spinner(
				dynamischesZoomverhaltenGroup, SWT.BORDER);
		linienstaerkeMaximaleZoomstufeKreisstrasseSpinner.setValues(5000, 0,
				Integer.MAX_VALUE, 0, 1, 100);
		factory.adapt(linienstaerkeMaximaleZoomstufeKreisstrasseSpinner);
		linienstaerkeMaximaleZoomstufeKreisstrasseSpinner
				.addSelectionListener(new SelectionAdapter() {

					@Override
					public void widgetSelected(final SelectionEvent e) {
						final int wert = linienstaerkeMaximaleZoomstufeKreisstrasseSpinner
								.getSelection();
						getCommandStack().execute(new SetCommand(getElement(),
								NetzPackage.Literals.STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_MAXIMALE_ZOOMSTUFE_KREISSTRASSE,
								wert));

					}

				});

	}

	private void createLinienstaerkeDynamischeLinienstaerkeKreisstrasse(
			final TabbedPropertySheetWidgetFactory factory,
			final Group dynamischesZoomverhaltenGroup) {
		factory.createLabel(dynamischesZoomverhaltenGroup,
				"Minimale Linienstärke:");

		linienstaerkeMinimumKreisstrasseSpinner = new Spinner(
				dynamischesZoomverhaltenGroup, SWT.BORDER);
		linienstaerkeMinimumKreisstrasseSpinner.setValues(1, 1,
				Integer.MAX_VALUE, 0, 1, 100);
		factory.adapt(linienstaerkeMinimumKreisstrasseSpinner);
		linienstaerkeMinimumKreisstrasseSpinner
				.addSelectionListener(new SelectionAdapter() {

					@Override
					public void widgetSelected(final SelectionEvent e) {
						final int wert = linienstaerkeMinimumKreisstrasseSpinner
								.getSelection();

						getCommandStack().execute(new SetCommand(getElement(),
								NetzPackage.Literals.STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_MINIMUM_KREISSTRASSE,
								wert));
					}
				});

		factory.createLabel(dynamischesZoomverhaltenGroup,
				"Maximale Linienstärke");

		linienstaerkeMaximumKreisstrasseSpinner = new Spinner(
				dynamischesZoomverhaltenGroup, SWT.BORDER);
		linienstaerkeMaximumKreisstrasseSpinner.setValues(5000, 0,
				Integer.MAX_VALUE, 0, 1, 100);
		factory.adapt(linienstaerkeMaximumKreisstrasseSpinner);

		linienstaerkeMaximumKreisstrasseSpinner
				.addSelectionListener(new SelectionAdapter() {

					@Override
					public void widgetSelected(final SelectionEvent e) {
						final int wert = linienstaerkeMaximumKreisstrasseSpinner
								.getSelection();

						getCommandStack().execute(new SetCommand(getElement(),
								NetzPackage.Literals.STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_MAXIMUM_KREISSTRASSE,
								wert));
					}
				});

	}

	private void createLinienstaerkeStatischesZoomverhaltenKreisstrasse(
			final Composite parent) {
		final TabbedPropertySheetWidgetFactory factory = getWidgetFactory();

		// Widgets anlegen

		linienstaerkeStatischesZoomverhaltenKreisstrasseBtn = getWidgetFactory()
				.createButton(parent,
						Zoomverhalten.STATISCHES_ZOOMVERHALTEN.getLiteral(),
						SWT.RADIO);
		linienstaerkeStatischesZoomverhaltenKreisstrasseBtn.setSelection(true);
		GridDataFactory.fillDefaults().span(3, 1)
				.applyTo(linienstaerkeStatischesZoomverhaltenKreisstrasseBtn);

		final Group statischesZoomverhaltenGroup = getWidgetFactory()
				.createGroup(parent, "");
		GridDataFactory.fillDefaults().span(5, 1)
				.applyTo(statischesZoomverhaltenGroup);
		GridLayoutFactory.fillDefaults().numColumns(2)
				.applyTo(statischesZoomverhaltenGroup);

		factory.createLabel(statischesZoomverhaltenGroup, "Linienstärke:");

		linienstaerkeKreisstrasse = new Spinner(statischesZoomverhaltenGroup,
				BORDER);
		linienstaerkeKreisstrasse.setMinimum(1);
		linienstaerkeKreisstrasse.setMaximum(100);
		linienstaerkeKreisstrasse.setIncrement(1);
		linienstaerkeKreisstrasse.setPageIncrement(10);
		factory.adapt(parent);

		linienstaerkeStatischesZoomverhaltenKreisstrasseBtn
				.addSelectionListener(new SelectionAdapter() {

					@Override
					public void widgetSelected(final SelectionEvent e) {
						final SetCommand cmd = new SetCommand(getElement(),
								NetzPackage.Literals.STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_ZOOMVERHALTEN_KREISSTRASSE,
								Zoomverhalten.STATISCHES_ZOOMVERHALTEN);
						getCommandStack().execute(cmd);
					}
				});

		linienstaerkeKreisstrasse.addSelectionListener(new SelectionAdapter() {

			@Override
			public void widgetSelected(final SelectionEvent e) {
				final int wert = linienstaerkeKreisstrasse.getSelection();

				getCommandStack().execute(new SetCommand(getElement(),
						NetzPackage.Literals.STRASSEN_SEGMENT_DO_TYP__LINIENSTAERKE_KREISSTRASSE,
						wert));
			}
		});
	}
}
