/*
 * Rahmenwerk-Plug-in "Maßstäbliche Darstellung"
 * Copyright (C) 2018 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.buv.plugin.netz.strassenteilsegment;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;

import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.PrecisionPoint;

import de.bsvrz.buv.plugin.dobj.util.Projektion;
import de.bsvrz.buv.plugin.netz.stoerfall.StoerfallIndikatorEditPart;
import de.bsvrz.sys.funclib.bitctrl.geolib.WGS84Koordinate;
import de.bsvrz.sys.funclib.bitctrl.modell.tmgeoreferenzierungglobal.konfigurationsdaten.KdBestehtAusLinienObjekten;
import de.bsvrz.sys.funclib.bitctrl.modell.tmgeoreferenzierungglobal.konfigurationsdaten.KdLinienKoordinaten;
import de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.StrassenSegment;
import de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.StrassenTeilSegment;
import de.bsvrz.sys.funclib.bitctrl.modell.util.geolib.WGS84Util;

/**
 * MVC-Controller für den Störfallindikator Straßenteilsegment.
 *
 * @author BitCtrl Systems GmbH, thierfelder
 * @author BitCtrl Systems GmbH, Falko Schumann
 */
public final class StrassenTeilSegmentStoerfallIndikatorEditPart
		extends StoerfallIndikatorEditPart<StrassenTeilSegment> {

	/** Punkte der Linie des Strassensegments. */
	private PointList strassenTeilSegmentKoordinaten;

	private final PropertyChangeListener propertyListener = new PropertyChangeListener() {

		@Override
		public void propertyChange(final PropertyChangeEvent evt) {
			final String prop = evt.getPropertyName();

			if (Projektion.class.toString().equals(prop)) {
				cleanModellKoordinaten();
				refreshVisuals();
			}
		}

	};

	/**
	 * Entfernt alle gecachten Modellkoordinaten (Pixelkoordinaten), damit diese
	 * neu berechnet werden.
	 */
	protected void cleanModellKoordinaten() {
		strassenTeilSegmentKoordinaten = null;
	}

	@Override
	public void activate() {
		super.activate();

		if (isEditor()) {
			getViewer().addPropertyChangeListener(propertyListener);
		}
	}

	@Override
	public void deactivate() {
		if (isEditor()) {
			getViewer().removePropertyChangeListener(propertyListener);
		}

		super.deactivate();
	}

	@Override
	protected void refreshVisuals() {
		super.refreshVisuals();

		refreshGeometrie();
	}

	private void refreshGeometrie() {
		getFigure().setBasePoints(getStrassenSegmentKoordinaten());
	}

	private PointList getStrassenSegmentKoordinaten() {
		if (strassenTeilSegmentKoordinaten == null) {
			if (getModel().getSystemObject() == null) {
				return null;
			}

			vorladen(StrassenSegment.PID, KdBestehtAusLinienObjekten.PID);
			vorladen(StrassenTeilSegment.PID, KdLinienKoordinaten.PID);

			strassenTeilSegmentKoordinaten = new PointList();
			final List<WGS84Koordinate> strassenSegment = WGS84Util
					.konvertiere(getSystemObjekt());
			final Projektion aktuelleProjektion = getProjektion();
			for (final WGS84Koordinate p : strassenSegment) {
				strassenTeilSegmentKoordinaten.addPoint(aktuelleProjektion
						.umrechnenWeltNachModel(new PrecisionPoint(
								p.getLaenge(), p.getBreite())));
			}
		}
		return strassenTeilSegmentKoordinaten;
	}

}
