/*
 * Rahmenwerk-Plug-in "Maßstäbliche Darstellung"
 * Copyright (C) 2018 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.buv.plugin.netz.tmcmeldung;

import org.eclipse.emf.common.notify.Notification;

import de.bsvrz.buv.plugin.dobj.decorator.LinienstaerkeZoomMediator;
import de.bsvrz.buv.plugin.dobj.decorator.VordergrundfarbeMediator;
import de.bsvrz.buv.plugin.netz.LinieLegendeBaustein;
import de.bsvrz.buv.plugin.netz.model.TmcMeldungVerlaufDoModel;
import de.bsvrz.buv.plugin.netz.model.TmcMeldungVerlaufDoTyp;
import de.bsvrz.buv.rw.basislib.legende.ILegendeBaustein;

/**
 * MVC-Controller zur Darstellung des Verlaufs einer <em>TMC-Meldung</em>.
 *
 * @author BitCtrl Systems GmbH, Steffen Gieseler
 *
 */
public final class TmcMeldungVerlaufEditPart
		extends TmcMeldungEditPart<TmcMeldungVerlaufFigure> {

	private LinieLegendeBaustein legendeBaustein;

	@Override
	protected TmcMeldungVerlaufFigure createFigure() {
		return new TmcMeldungVerlaufFigure();
	}

	@Override
	protected TmcMeldungEmpfaenger createTmcMeldungEmpfaenger() {
		return new TmcMeldungVerlaufEmpfaenger(this);
	}

	@Override
	public void notifyChanged(final Notification notification) {
		super.notifyChanged(notification);

		final Object notifier = notification.getNotifier();
		if (notification.getEventType() != Notification.REMOVING_ADAPTER
				&& (notifier instanceof TmcMeldungVerlaufDoTyp
						|| notifier instanceof TmcMeldungVerlaufDoModel)) {
			refreshVisuals();
		}
	}

	@Override
	protected void refreshVisuals() {
		super.refreshVisuals();

		new VordergrundfarbeMediator(this).mediate();
		new LinienstaerkeZoomMediator(this).mediate();
	}

	@Override
	public Object getAdapter(@SuppressWarnings("rawtypes") final Class key) {
		if (ILegendeBaustein.class.equals(key)) {
			return getLegendeBaustein();
		}

		return super.getAdapter(key);
	}

	private ILegendeBaustein getLegendeBaustein() {
		disposeLegende();
		legendeBaustein = new LinieLegendeBaustein(getModel().getDoTyp(),
				createFigure());
		return legendeBaustein;
	}

	private void disposeLegende() {
		if (legendeBaustein != null) {
			legendeBaustein.dispose();
			legendeBaustein = null;
		}
	}

}
