/*
 * Rahmenwerk-Plug-in "Maßstäbliche Darstellung"
 * Copyright (C) 2018 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.buv.plugin.netz.tmcmeldung;

import org.eclipse.jface.dialogs.PopupDialog;
import org.eclipse.swt.widgets.Shell;

import de.bsvrz.buv.plugin.dobj.model.BitCtrlDoModel;
import de.bsvrz.buv.plugin.netz.ui.AbstractPopUpEditPolicy;
import de.bsvrz.sys.funclib.bitctrl.modell.tmtmcverkehrsmeldung.objekte.TmcVerkehrsMeldung;

/**
 * Editpolicy fuer TMC-Meldungen.
 *
 * @author BitCtrl Systems GmbH, Steffen Gieseler
 *
 */
final class TmcMeldungsPopUpEditPolicy
		extends AbstractPopUpEditPolicy<TmcVerkehrsMeldung> {

	@Override
	protected PopupDialog getPopupDialog(final Shell shell,
			final TmcVerkehrsMeldung systemObjekt) {
		return new TmcMeldungsPopUp(shell, systemObjekt, getDoModel());
	}

	@SuppressWarnings("unchecked")
	@Override
	protected TmcVerkehrsMeldung getSystemObjekt() {
		return ((BitCtrlDoModel<TmcVerkehrsMeldung>) getHost().getModel())
				.getSystemObjekt();
	}

}
