/*
 * Rahmenwerk-Plug-in "Maßstäbliche Darstellung"
 * Copyright (C) 2018 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.buv.plugin.netz.ui;

import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.editpolicies.AbstractEditPolicy;
import org.eclipse.gef.requests.LocationRequest;
import org.eclipse.jface.dialogs.PopupDialog;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

import de.bsvrz.buv.plugin.dobj.model.DoModel;
import de.bsvrz.sys.funclib.bitctrl.modell.SystemObjekt;

/**
 * Allgemeine Editpolicy fuer Tooltips bzw. Popups von Editparts.
 *
 * @author BitCtrl Systems GmbH, Thierfelder
 *
 *
 * @param <T>
 *            der Typ des Systemobjekts.
 */
public abstract class AbstractPopUpEditPolicy<T extends SystemObjekt>
		extends AbstractEditPolicy {

	/**
	 * Das Popup.
	 */
	private PopupDialog popUp;

	/**
	 * Erfragt das Systemobjekt, fuer das ein Popup dargestellt werden soll.
	 *
	 * @return ein Systemobjekt.
	 */
	protected abstract T getSystemObjekt();

	/**
	 * Erfragt den Popup-Dialog.
	 *
	 * @param shell
	 *            eine Schell
	 * @return ein Popup-Dialog.
	 */
	protected abstract PopupDialog getPopupDialog(final Shell shell,
			final T systemObjekt);

	/**
	 * Erfragt das Model, fuer das ein Popup dargestellt werden soll.
	 *
	 * @return ein Model.
	 */
	protected final DoModel getDoModel() {
		return (DoModel) getHost().getModel();
	}

	@Override
	public void showTargetFeedback(final Request request) {
		if (REQ_SELECTION_HOVER.equals(request.getType())) {
			// if (popUp != null) {
			// return;
			// }

			final LocationRequest req = (LocationRequest) request;
			final EditPart editPart = getHost();
			final Control control = editPart.getViewer().getControl();
			if (getSystemObjekt() == null) {
				// Kein Systemobjekt gesetz
				return;
			}

			popUp = getPopupDialog(control.getShell(), getSystemObjekt());
			popUp.create();

			Point p = req.getLocation().getCopy();

			p = new Point(control.toDisplay(p.x, p.y + 16));
			popUp.getShell().setLocation(p.x, p.y);
			popUp.open();

			final Point popUpLocation = new Point(
					popUp.getShell().getLocation());
			if (popUpLocation.y < p.y) {
				popUpLocation.y = popUpLocation.y
						- popUp.getShell().getSize().y;
				popUp.getShell().setLocation(popUpLocation.x, popUpLocation.y);
			}

			return;
		}

		super.showTargetFeedback(request);
	}

	@Override
	public void eraseTargetFeedback(final Request request) {
		// if (REQ_SELECTION_HOVER.equals(request.getType())) {
		// if (popUp != null) {
		// popUp.close();
		// popUp = null;
		// }
		//
		// return;
		// }
		//
		// super.eraseTargetFeedback(request);
	}

}
