/*
 * Rahmenwerk-Plug-in "Maßstäbliche Darstellung"
 * Copyright (C) 2018 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.buv.plugin.netz.ui;

import java.text.SimpleDateFormat;

import org.eclipse.jface.dialogs.PopupDialog;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;

import de.bsvrz.buv.plugin.dobj.model.DoModel;
import de.bsvrz.dav.daf.main.Data;
import de.bsvrz.dav.daf.main.config.AttributeGroup;
import de.bsvrz.sys.funclib.bitctrl.modell.SystemObjekt;

/**
 * Allgemeiner Tooltip fuer die vordefinierten DO-Typen.
 *
 * @author BitCtrl Systems GmbH, Thierfelder
 *
 */
public abstract class DObjPopUp<T extends SystemObjekt> extends PopupDialog {

	protected static final SimpleDateFormat FORMAT_DATUM_ZEIT = new SimpleDateFormat(
			"dd.MM.yyyy HH:mm:ss");

	protected static final SimpleDateFormat FORMAT_DATUM_ZEIT_GENAU = new SimpleDateFormat(
			"dd.MM.yyyy HH:mm:ss,SSS");

	private final T systemObjekt;

	protected final DoModel doModel;

	protected Label infoTextLabel;

	protected Label beschreibungsTextLabel;

	protected Label doModelNameLabel;

	protected DObjPopUp(final Shell parent, final T systemObjekt,
			final DoModel doModel) {
		super(parent, SWT.FOCUSED | SWT.ON_TOP, true, true, true, true, false,
				systemObjekt.toString(), "Führe Datenanmeldung durch ...");
		this.systemObjekt = systemObjekt;
		this.doModel = doModel;
	}

	protected final T getSystemObjekt() {
		return systemObjekt;
	}

	protected final String getInfoText() {
		String kurzinfo = null;
		if (getSystemObjekt() != null) {
			final AttributeGroup atg = getSystemObjekt().getSystemObject()
					.getDataModel().getAttributeGroup("atg.info");
			final Data data = getSystemObjekt().getSystemObject()
					.getConfigurationData(atg);
			if (data != null) {
				kurzinfo = data.getTextValue("kurzinfo").getText();
			}
		}
		return kurzinfo;
	}

	protected final String getBeschreibungsText() {
		String beschreibung = null;
		if (getSystemObjekt() != null) {
			final AttributeGroup atg = getSystemObjekt().getSystemObject()
					.getDataModel().getAttributeGroup("atg.info");
			final Data data = getSystemObjekt().getSystemObject()
					.getConfigurationData(atg);
			if (data != null) {
				beschreibung = data.getTextValue("beschreibung").getText();
			}
		}
		return beschreibung;
	}

}
