/*
 * Rahmenwerk-Plug-in "Maßstäbliche Darstellung"
 * Copyright (C) 2018 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.buv.plugin.netz.ui;

import org.eclipse.jface.dialogs.PopupDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

/**
 * Stellt Methoden zur Skalierung von Texten-Widgets innerhalb von
 * {@link PopupDialog}en zur Verfuegung.
 *
 * @author BitCtrl Systems GmbH, Thierfelder
 *
 */
public final class PopUpSizingHelper {

	private static int standardLetterHeight = Integer.MIN_VALUE;

	private static int standardLetterWidth = Integer.MIN_VALUE;

	private PopUpSizingHelper() {
		// es soll keine Instanzen der Klasse geben
	}

	/**
	 * Setzt die Gridgroesse des uebergebenen {@link Control}s so, dass der
	 * gesamte Text zu sehen ist.
	 *
	 * @param control
	 *            ein Control (entweder ein {@link Label} oder ein {@link Text}
	 *            ).
	 * @param maxWidth
	 *            die maximale Breite des Grids. <b>Achtung:</b> Wenn es sich
	 *            bei dem uebergebenen {@link Control} um ein {@link Label}
	 *            handelt, wird nichts abgeschnitten.
	 */
	public static void resize(final Control control, final int maxWidth) {
		if (standardLetterHeight == Integer.MIN_VALUE) {
			final GC gc = new GC(new Label(control.getShell(), SWT.NONE));
			standardLetterHeight = gc.getFontMetrics().getHeight();
			standardLetterWidth = gc.getFontMetrics().getAverageCharWidth();
			gc.dispose();
		}

		if (control instanceof Label) {
			final Label label = (Label) control;
			label.setLayoutData(GridDataFactory.swtDefaults()
					.align(SWT.FILL, SWT.FILL).grab(true, true)
					.hint(standardLetterWidth * label.getText().length(),
							standardLetterHeight)
					.create());
		} else if (control instanceof Text) {
			final Text text = (Text) control;
			text.setLayoutData(GridDataFactory.swtDefaults()
					.align(SWT.FILL, SWT.FILL).grab(true, true)
					.hint(maxWidth,
							standardLetterHeight + standardLetterHeight
									* text.getText().length()
									* standardLetterWidth / maxWidth)
					.create());
		} else {
			throw new IllegalArgumentException(
					control.getClass().getCanonicalName()
							+ " wird nicht unterstuetzt!");
		}
	}

	/**
	 * Setzt die Gridgroesse des uebergebenen {@link Control}s so, dass der
	 * gesamte Text zu sehen ist (max 400 Pixel pro Zeile).
	 *
	 * @param control
	 *            ein Control (entweder ein {@link Label} oder ein {@link Text}
	 *            ).
	 */
	public static void resize(final Control control) {
		resize(control, 500);
	}

}
