/*
 * Rahmenwerk-Plug-in "Maßstäbliche Darstellung"
 * Copyright (C) 2018 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.buv.plugin.netz.umfelddatenmessstelle;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.gef.EditPolicy;

import de.bsvrz.buv.plugin.dobj.editparts.PunktEditPart;
import de.bsvrz.buv.plugin.dobj.legende.DoLegendeBaustein;
import de.bsvrz.buv.plugin.netz.model.NetzPackage;
import de.bsvrz.buv.plugin.netz.model.UmfeldDatenMessStelleDoModel;
import de.bsvrz.buv.rw.basislib.legende.ILegendeBaustein;
import de.bsvrz.sys.funclib.bitctrl.modell.tmgeoreferenzierungglobal.konfigurationsdaten.KdPunktKoordinaten;
import de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.objekte.UmfeldDatenMessStelle;

/**
 * MVC-Controller für eine Umfelddatenmessstelle.
 *
 * @author BitCtrl Systems GmbH, thierfelder
 */
public final class UmfeldDatenMessStelleEditPart extends
		PunktEditPart<UmfeldDatenMessStelle, UmfeldDatenMessStelleFigure> {

	private DoLegendeBaustein legendeBaustein;

	@Override
	protected UmfeldDatenMessStelleFigure createFigure() {
		return new UmfeldDatenMessStelleFigure(getResourceManager());
	}

	@Override
	public void deactivate() {
		disposeLegende();

		super.deactivate();
	}

	@Override
	protected void createEditPolicies() {
		super.createEditPolicies();

		if (!isEditor()) {
			installEditPolicy(EditPolicy.SELECTION_FEEDBACK_ROLE,
					new UmfeldDatenMessStellePopUpEditPolicy());
		}
	}

	@Override
	protected IFigure getToolTip() {
		if (isEditor()) {
			return super.getToolTip();
		}

		return null;
	}

	@Override
	protected Point getWgs84Location() {
		vorladen(UmfeldDatenMessStelle.PID, KdPunktKoordinaten.PID);

		return super.getWgs84Location();
	}

	@Override
	public Object getAdapter(@SuppressWarnings("rawtypes") final Class key) {
		if (ILegendeBaustein.class.equals(key)) {
			return getLegendeBaustein();
		}

		return super.getAdapter(key);
	}

	private ILegendeBaustein getLegendeBaustein() {
		disposeLegende();
		final UmfeldDatenMessStelleFigure f = createFigure();
		legendeBaustein = new DoLegendeBaustein(getModel().getDoTyp(), f,
				f.getDimension());
		return legendeBaustein;
	}

	private void disposeLegende() {
		if (legendeBaustein != null) {
			legendeBaustein.dispose();
			legendeBaustein = null;
		}
	}

	@Override
	public UmfeldDatenMessStelleDoModel getModel() {
		return (UmfeldDatenMessStelleDoModel) super.getModel();
	}

	@Override
	public void notifyChanged(final Notification notification) {
		super.notifyChanged(notification);

		final Object notifier = notification.getNotifier();
		final int type = notification.getEventType();

		if (notifier instanceof UmfeldDatenMessStelleDoModel) {
			final int featureID = notification
					.getFeatureID(UmfeldDatenMessStelleDoModel.class);
			switch (type) {
			case Notification.SET:
			case Notification.UNSET:
				switch (featureID) {
				case NetzPackage.UMFELD_DATEN_MESS_STELLE_DO_MODEL__IMAGE_TYP:
					refreshVisuals();
					break;
				default:
					break;
				}
				break;
			}
		}
	}

	@Override
	protected void refreshVisuals() {
		super.refreshVisuals();
		getFigure().setImageTyp(getModel().getImageTyp());
	}
}