/*
 * Rahmenwerk-Plug-in "Maßstäbliche Darstellung"
 * Copyright (C) 2018 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.buv.plugin.netz.umfelddatenmessstelle;

import org.eclipse.draw2d.ImageFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.swt.graphics.Image;

import com.bitctrl.lib.eclipse.draw2d.FixedSizeFigure;

import de.bsvrz.buv.plugin.dobj.DoFigure;
import de.bsvrz.buv.plugin.netz.internal.NetzPlugin;
import de.bsvrz.buv.plugin.netz.model.UmfeldDatenMessstelleImageTyp;

/**
 * MVC-View für eine Umfelddatenmessstelle.
 *
 * @author BitCtrl Systems GmbH, Falko Schumamn
 */
final class UmfeldDatenMessStelleFigure extends FixedSizeFigure
		implements DoFigure {

	private static final ImageDescriptor IMAGE_DESCRIPTOR_STANDARD = NetzPlugin
			.getDefault()
			.getImageDescriptor("images/dot/umfelddatenmessstelle.png");

	private static final ImageDescriptor IMAGE_DESCRIPTOR_SWIS = NetzPlugin
			.getDefault()
			.getImageDescriptor("images/dot/umfelddatenmessstelle_swis.png");

	private double zoom = 1.0;
	private double vonZoom;
	private double bisZoom = Double.MAX_VALUE;

	private UmfeldDatenMessstelleImageTyp imageTyp = UmfeldDatenMessstelleImageTyp.STANDARDBILD;
	private final ImageFigure imageFigure;
	private final ResourceManager resourceManager;

	UmfeldDatenMessStelleFigure(final ResourceManager resourceManager) {

		this.resourceManager = resourceManager;
		final Image img = createImage();
		imageFigure = new ImageFigure(img);
		final Dimension size = new Dimension(img);
		imageFigure.setSize(size);
		add(imageFigure);

		setDimension(size);
	}

	private Image createImage() {
		Image img;
		switch (imageTyp) {
		case SWIS:
			img = resourceManager.createImage(IMAGE_DESCRIPTOR_SWIS);
			break;
		case STANDARDBILD:
		default:
			img = resourceManager.createImage(IMAGE_DESCRIPTOR_STANDARD);
			break;
		}
		return img;
	}

	@Override
	public Point getHotspot() {
		return getLocation();
	}

	@Override
	public void setHotspot(final Point hotspot) {
		setLocation(hotspot);
	}

	@Override
	public void setSichtbareZoomStufe(final double vonZoom,
			final double bisZoom) {
		if (this.vonZoom == vonZoom && this.bisZoom == bisZoom) {
			return;
		}

		this.vonZoom = vonZoom;
		this.bisZoom = bisZoom;

		updateFigure();
	}

	@Override
	public void handleZoomChanged(final double newZoom) {
		setZoom(newZoom);

		if (zoom == newZoom) {
			return;
		}

		zoom = newZoom;

		updateFigure();
	}

	private void updateFigure() {
		setVisible(vonZoom <= zoom && zoom <= bisZoom);
	}

	public void setImageTyp(final UmfeldDatenMessstelleImageTyp imageTyp) {

		UmfeldDatenMessstelleImageTyp newType = imageTyp;
		if (newType == null) {
			newType = UmfeldDatenMessstelleImageTyp.STANDARDBILD;
		}

		if (this.imageTyp != newType) {
			this.imageTyp = newType;
			imageFigure.setImage(createImage());
			updateFigure();
		}
	}
}
