/*
 * Rahmenwerk-Plug-in "Maßstäbliche Darstellung"
 * Copyright (C) 2018 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.buv.plugin.netz.umfelddatenmessstelle;

import java.util.HashMap;
import java.util.Map;

import org.eclipse.draw2d.ColorConstants;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;

import de.bsvrz.buv.plugin.dobj.model.DoModel;
import de.bsvrz.buv.plugin.netz.ui.DObjPopUp;
import de.bsvrz.sys.funclib.bitctrl.modell.Aspekt;
import de.bsvrz.sys.funclib.bitctrl.modell.DatensatzUpdateEvent;
import de.bsvrz.sys.funclib.bitctrl.modell.DatensatzUpdateListener;
import de.bsvrz.sys.funclib.bitctrl.modell.OnlineDatensatz;
import de.bsvrz.sys.funclib.bitctrl.modell.OnlineDatum;
import de.bsvrz.sys.funclib.bitctrl.modell.OnlineDatum.Status;
import de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.objekte.UfdsFahrBahnFeuchte;
import de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.objekte.UfdsFahrBahnGlaette;
import de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.objekte.UfdsFahrBahnOberFlaechenTemperatur;
import de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.objekte.UfdsFahrBahnOberFlaechenZustand;
import de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.objekte.UfdsGefrierTemperatur;
import de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.objekte.UfdsHelligkeit;
import de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.objekte.UfdsLuftDruck;
import de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.objekte.UfdsLuftTemperatur;
import de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.objekte.UfdsNiederschlagsArt;
import de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.objekte.UfdsNiederschlagsIntensitaet;
import de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.objekte.UfdsNiederschlagsMenge;
import de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.objekte.UfdsRelativeLuftFeuchte;
import de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.objekte.UfdsRestSalz;
import de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.objekte.UfdsSchneeHoehe;
import de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.objekte.UfdsSichtWeite;
import de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.objekte.UfdsTaupunktTemperatur;
import de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.objekte.UfdsTemperaturInTiefe1;
import de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.objekte.UfdsTemperaturInTiefe2;
import de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.objekte.UfdsTemperaturInTiefe3;
import de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.objekte.UfdsWasserFilmDicke;
import de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.objekte.UfdsWindGeschwindigkeitMittelWert;
import de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.objekte.UfdsWindGeschwindigkeitSpitzenWert;
import de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.objekte.UfdsWindRichtung;
import de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.objekte.UmfeldDatenMessStelle;
import de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.objekte.UmfeldDatenSensor;
import de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.onlinedaten.OdUfdsFahrBahnFeuchte;
import de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.onlinedaten.OdUfdsFahrBahnFeuchte.Daten;
import de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.onlinedaten.OdUfdsFahrBahnGlaette;
import de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.onlinedaten.OdUfdsFahrBahnOberFlaechenTemperatur;
import de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.onlinedaten.OdUfdsFahrBahnOberFlaechenZustand;
import de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.onlinedaten.OdUfdsGefrierTemperatur;
import de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.onlinedaten.OdUfdsHelligkeit;
import de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.onlinedaten.OdUfdsLuftDruck;
import de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.onlinedaten.OdUfdsLuftTemperatur;
import de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.onlinedaten.OdUfdsNiederschlagsArt;
import de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.onlinedaten.OdUfdsNiederschlagsIntensitaet;
import de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.onlinedaten.OdUfdsNiederschlagsMenge;
import de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.onlinedaten.OdUfdsRelativeLuftFeuchte;
import de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.onlinedaten.OdUfdsRestSalz;
import de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.onlinedaten.OdUfdsSchneeHoehe;
import de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.onlinedaten.OdUfdsSichtWeite;
import de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.onlinedaten.OdUfdsTaupunktTemperatur;
import de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.onlinedaten.OdUfdsTemperaturInTiefe1;
import de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.onlinedaten.OdUfdsTemperaturInTiefe2;
import de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.onlinedaten.OdUfdsTemperaturInTiefe3;
import de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.onlinedaten.OdUfdsWasserFilmDicke;
import de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.onlinedaten.OdUfdsWindGeschwindigkeitMittelWert;
import de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.onlinedaten.OdUfdsWindGeschwindigkeitSpitzenWert;
import de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.onlinedaten.OdUfdsWindRichtung;

/**
 * Tooltip fuer UmfeldDatenMessStelleEditPart.
 *
 * @author BitCtrl Systems GmbH, Thierfelder
 */
final class UmfeldDatenMessStellePopUp extends DObjPopUp<UmfeldDatenMessStelle>
		implements DatensatzUpdateListener {

	UmfeldDatenMessStellePopUp(final Shell shell,
			final UmfeldDatenMessStelle mst, final DoModel doModel) {
		super(shell, mst, doModel);
	}

	/**
	 * die Menge der Sensoren, die in der anzuzeigenden Umfelddatenmessstelle
	 * konfiguriert sind.
	 */
	private final Map<UmfeldDatenSensor, Label> sensorLabels = new HashMap<>();

	private Label zeitstempel;

	@Override
	protected Control createDialogArea(final Composite parent) {
		final Composite composite = (Composite) super.createDialogArea(parent);

		composite.setLayout(new GridLayout(1, true));
		composite.setLayoutData(GridDataFactory.fillDefaults()
				.minSize(600, SWT.DEFAULT).grab(true, true).create());

		final GridData gd = new GridData(GridData.FILL_HORIZONTAL);
		zeitstempel = new Label(composite, SWT.NONE);
		zeitstempel.setLayoutData(gd);
		Label label;

		final String infoText = getInfoText();
		if (infoText != null) {
			infoTextLabel = new Label(composite, SWT.NONE);
			infoTextLabel.setLayoutData(GridDataFactory.swtDefaults()
					.align(SWT.FILL, SWT.CENTER).create());
			infoTextLabel.setText("  Info: " + infoText);
		}
		final String beschreibungText = getBeschreibungsText();
		if (beschreibungText != null) {
			beschreibungsTextLabel = new Label(composite, SWT.NONE);
			beschreibungsTextLabel.setLayoutData(GridDataFactory.swtDefaults()
					.align(SWT.FILL, SWT.CENTER).create());
			beschreibungsTextLabel.setText("  Beschreibung: " + infoText);
		}
		if (doModel != null && doModel.getName() != null
				&& doModel.getName().length() > 0) {
			doModelNameLabel = new Label(composite, SWT.NONE);
			doModelNameLabel.setLayoutData(GridDataFactory.swtDefaults()
					.align(SWT.FILL, SWT.CENTER).create());
			doModelNameLabel.setText("  Model: " + doModel.getName());
		}

		for (final UmfeldDatenSensor sensor : getSystemObjekt()
				.getUmfeldDatenSensoren()) {
			label = new Label(composite, SWT.NONE);
			label.setLayoutData(gd);
			sensorLabels.put(sensor, label);
		}

		datenSatzListenerAnmelden();

		return composite;
	}

	@Override
	public boolean close() {
		datenSatzListenerAbmelden();
		return super.close();
	}

	@Override
	public void datensatzAktualisiert(final DatensatzUpdateEvent event) {
		getShell().getDisplay().asyncExec(new Runnable() {

			@Override
			public void run() {
				if (getShell() == null || getShell().isDisposed()) {
					return;
				}

				zeitstempel.setText("Zeit: " + FORMAT_DATUM_ZEIT_GENAU
						.format(event.getDatum().dGetZeitstempel().getTime()));
				displaySensorLabelData((UmfeldDatenSensor) event.getObjekt(),
						sensorLabels.get(event.getObjekt()));
			}

		});
	}

	/**
	 * Meldet die Datensaetze zum Empfang der Sensordaten beim Datenverteiler an
	 * bzw. wieder ab.
	 *
	 * @param sensor
	 *            der Sensor
	 * @param anmelden
	 *            Datenempfanganmelden?
	 */
	private void sensorDatenSatzAnOderAbMelden(final UmfeldDatenSensor sensor,
			final boolean anmelden) {
		OnlineDatensatz<? extends OnlineDatum> datum = null;
		Aspekt aspekt = null;

		if (sensor instanceof UfdsFahrBahnFeuchte) {
			datum = ((UfdsFahrBahnFeuchte) sensor).getOdUfdsFahrBahnFeuchte();
			aspekt = OdUfdsFahrBahnFeuchte.Aspekte.ExterneErfassung;
		} else if (sensor instanceof UfdsFahrBahnGlaette) {
			datum = ((UfdsFahrBahnGlaette) sensor).getOdUfdsFahrBahnGlaette();
			aspekt = OdUfdsFahrBahnGlaette.Aspekte.ExterneErfassung;
		} else if (sensor instanceof UfdsFahrBahnOberFlaechenTemperatur) {
			datum = ((UfdsFahrBahnOberFlaechenTemperatur) sensor)
					.getOdUfdsFahrBahnOberFlaechenTemperatur();
			aspekt = OdUfdsFahrBahnOberFlaechenTemperatur.Aspekte.ExterneErfassung;
		} else if (sensor instanceof UfdsFahrBahnOberFlaechenZustand) {
			datum = ((UfdsFahrBahnOberFlaechenZustand) sensor)
					.getOdUfdsFahrBahnOberFlaechenZustand();
			aspekt = OdUfdsFahrBahnOberFlaechenZustand.Aspekte.ExterneErfassung;
		} else if (sensor instanceof UfdsGefrierTemperatur) {
			datum = ((UfdsGefrierTemperatur) sensor)
					.getOdUfdsGefrierTemperatur();
			aspekt = OdUfdsGefrierTemperatur.Aspekte.ExterneErfassung;

		} else if (sensor instanceof UfdsHelligkeit) {
			datum = ((UfdsHelligkeit) sensor).getOdUfdsHelligkeit();
			aspekt = OdUfdsHelligkeit.Aspekte.ExterneErfassung;
		} else if (sensor instanceof UfdsLuftDruck) {
			datum = ((UfdsLuftDruck) sensor).getOdUfdsLuftDruck();
			aspekt = OdUfdsLuftDruck.Aspekte.ExterneErfassung;
		} else if (sensor instanceof UfdsLuftTemperatur) {
			datum = ((UfdsLuftTemperatur) sensor).getOdUfdsLuftTemperatur();
			aspekt = OdUfdsLuftTemperatur.Aspekte.ExterneErfassung;
		} else if (sensor instanceof UfdsNiederschlagsArt) {
			datum = ((UfdsNiederschlagsArt) sensor).getOdUfdsNiederschlagsArt();
			aspekt = OdUfdsNiederschlagsArt.Aspekte.ExterneErfassung;
		} else if (sensor instanceof UfdsNiederschlagsIntensitaet) {
			datum = ((UfdsNiederschlagsIntensitaet) sensor)
					.getOdUfdsNiederschlagsIntensitaet();
			aspekt = OdUfdsNiederschlagsIntensitaet.Aspekte.ExterneErfassung;
		} else if (sensor instanceof UfdsNiederschlagsMenge) {
			datum = ((UfdsNiederschlagsMenge) sensor)
					.getOdUfdsNiederschlagsMenge();
			aspekt = OdUfdsNiederschlagsMenge.Aspekte.ExterneErfassung;
		} else if (sensor instanceof UfdsRelativeLuftFeuchte) {
			datum = ((UfdsRelativeLuftFeuchte) sensor)
					.getOdUfdsRelativeLuftFeuchte();
			aspekt = OdUfdsRelativeLuftFeuchte.Aspekte.ExterneErfassung;
		} else if (sensor instanceof UfdsRestSalz) {
			datum = ((UfdsRestSalz) sensor).getOdUfdsRestSalz();
			aspekt = OdUfdsRestSalz.Aspekte.ExterneErfassung;
		} else if (sensor instanceof UfdsSchneeHoehe) {
			datum = ((UfdsSchneeHoehe) sensor).getOdUfdsSchneeHoehe();
			aspekt = OdUfdsSchneeHoehe.Aspekte.ExterneErfassung;
		} else if (sensor instanceof UfdsSichtWeite) {
			datum = ((UfdsSichtWeite) sensor).getOdUfdsSichtWeite();
			aspekt = OdUfdsSichtWeite.Aspekte.ExterneErfassung;
		} else if (sensor instanceof UfdsTaupunktTemperatur) {
			datum = ((UfdsTaupunktTemperatur) sensor)
					.getOdUfdsTaupunktTemperatur();
			aspekt = OdUfdsTaupunktTemperatur.Aspekte.ExterneErfassung;
		} else if (sensor instanceof UfdsTemperaturInTiefe1) {
			datum = ((UfdsTemperaturInTiefe1) sensor)
					.getOdUfdsTemperaturInTiefe1();
			aspekt = OdUfdsTemperaturInTiefe1.Aspekte.ExterneErfassung;
		} else if (sensor instanceof UfdsTemperaturInTiefe2) {
			datum = ((UfdsTemperaturInTiefe2) sensor)
					.getOdUfdsTemperaturInTiefe2();
			aspekt = OdUfdsTemperaturInTiefe2.Aspekte.ExterneErfassung;
		} else if (sensor instanceof UfdsTemperaturInTiefe3) {
			datum = ((UfdsTemperaturInTiefe3) sensor)
					.getOdUfdsTemperaturInTiefe3();
			aspekt = OdUfdsTemperaturInTiefe3.Aspekte.ExterneErfassung;
		} else if (sensor instanceof UfdsWasserFilmDicke) {
			datum = ((UfdsWasserFilmDicke) sensor).getOdUfdsWasserFilmDicke();
			aspekt = OdUfdsWasserFilmDicke.Aspekte.ExterneErfassung;
		} else if (sensor instanceof UfdsWindGeschwindigkeitMittelWert) {
			datum = ((UfdsWindGeschwindigkeitMittelWert) sensor)
					.getOdUfdsWindGeschwindigkeitMittelWert();
			aspekt = OdUfdsWindGeschwindigkeitMittelWert.Aspekte.ExterneErfassung;
		} else if (sensor instanceof UfdsWindGeschwindigkeitSpitzenWert) {
			datum = ((UfdsWindGeschwindigkeitSpitzenWert) sensor)
					.getOdUfdsWindGeschwindigkeitSpitzenWert();
			aspekt = OdUfdsWindGeschwindigkeitSpitzenWert.Aspekte.ExterneErfassung;
		} else if (sensor instanceof UfdsWindRichtung) {
			datum = ((UfdsWindRichtung) sensor).getOdUfdsWindRichtung();
			aspekt = OdUfdsWindRichtung.Aspekte.ExterneErfassung;
		}

		if ((datum != null) && (aspekt != null)) {
			if (anmelden) {
				datum.addUpdateListener(aspekt, this);
			} else {
				datum.removeUpdateListener(aspekt, this);
			}
		}
	}

	/**
	 * Meldet sich von Onlinedaten ab.
	 */
	public void datenSatzListenerAbmelden() {
		for (final UmfeldDatenSensor sensor : sensorLabels.keySet()) {
			sensorDatenSatzAnOderAbMelden(sensor, false);
		}
	}

	/**
	 * Meldet sich auf Online-Darten an.
	 */
	public void datenSatzListenerAnmelden() {
		for (final UmfeldDatenSensor sensor : sensorLabels.keySet()) {
			sensorDatenSatzAnOderAbMelden(sensor, true);
		}
	}

	/**
	 * die Funktion ermittelt die Daten für den übergebenen Sensor und zeigt den
	 * aktuell verfügbaren Wert an. Liegt ein gültiger Wert vor, wird dieser mit
	 * der Art des Sensors angezeigt, anderenfalls wird neben der Sensorart der
	 * Status des Datensatzes angezeigt und die entsprechende Sensorzeile rot
	 * eingefärbt.
	 *
	 * @param sensor
	 *            der Sensor
	 * @param label
	 *            die zu aktualisierende Label-Figur
	 */
	private void displaySensorLabelData(final UmfeldDatenSensor sensor,
			final Label label) {

		OnlineDatum datum = null;
		String name = null;
		Object wert = null;

		setInfoText("");

		if (sensor instanceof UfdsFahrBahnFeuchte) {
			datum = ((UfdsFahrBahnFeuchte) sensor).getOdUfdsFahrBahnFeuchte()
					.getDatum(OdUfdsFahrBahnFeuchte.Aspekte.ExterneErfassung);

			name = "Fahrbahnfeuchte";
			wert = ((Daten) datum).getFahrBahnFeuchte().getWert();
		} else if (sensor instanceof UfdsFahrBahnGlaette) {
			datum = ((UfdsFahrBahnGlaette) sensor).getOdUfdsFahrBahnGlaette()
					.getDatum(OdUfdsFahrBahnGlaette.Aspekte.ExterneErfassung);
			name = "Fahrbahnglätte";
			wert = ((de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.onlinedaten.OdUfdsFahrBahnGlaette.Daten) datum)
					.getFahrBahnGlaette().getWert();
		} else if (sensor instanceof UfdsFahrBahnOberFlaechenTemperatur) {
			datum = ((UfdsFahrBahnOberFlaechenTemperatur) sensor)
					.getOdUfdsFahrBahnOberFlaechenTemperatur().getDatum(
							OdUfdsFahrBahnOberFlaechenTemperatur.Aspekte.ExterneErfassung);
			name = "Fahrbahnoberflächentemperatur";
			wert = ((de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.onlinedaten.OdUfdsFahrBahnOberFlaechenTemperatur.Daten) datum)
					.getFahrBahnOberFlaechenTemperatur().getWert();
		} else if (sensor instanceof UfdsFahrBahnOberFlaechenZustand) {
			datum = ((UfdsFahrBahnOberFlaechenZustand) sensor)
					.getOdUfdsFahrBahnOberFlaechenZustand().getDatum(
							OdUfdsFahrBahnOberFlaechenZustand.Aspekte.ExterneErfassung);
			name = "Fahrbahnoberflächenzustand";
			wert = ((de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.onlinedaten.OdUfdsFahrBahnOberFlaechenZustand.Daten) datum)
					.getFahrBahnOberFlaechenZustand().getWert();
		} else if (sensor instanceof UfdsGefrierTemperatur) {
			datum = ((UfdsGefrierTemperatur) sensor)
					.getOdUfdsGefrierTemperatur()
					.getDatum(OdUfdsGefrierTemperatur.Aspekte.ExterneErfassung);
			name = "Gefriertemperatur";
			wert = ((de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.onlinedaten.OdUfdsGefrierTemperatur.Daten) datum)
					.getGefrierTemperatur().getWert();

		} else if (sensor instanceof UfdsHelligkeit) {
			datum = ((UfdsHelligkeit) sensor).getOdUfdsHelligkeit()
					.getDatum(OdUfdsHelligkeit.Aspekte.ExterneErfassung);
			name = "Helligkeit";
			wert = ((de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.onlinedaten.OdUfdsHelligkeit.Daten) datum)
					.getHelligkeit().getWert();

		} else if (sensor instanceof UfdsLuftDruck) {
			datum = ((UfdsLuftDruck) sensor).getOdUfdsLuftDruck()
					.getDatum(OdUfdsLuftDruck.Aspekte.ExterneErfassung);
			name = "Luftdruck";
			wert = ((de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.onlinedaten.OdUfdsLuftDruck.Daten) datum)
					.getLuftDruck().getWert();

		} else if (sensor instanceof UfdsLuftTemperatur) {
			datum = ((UfdsLuftTemperatur) sensor).getOdUfdsLuftTemperatur()
					.getDatum(OdUfdsLuftTemperatur.Aspekte.ExterneErfassung);
			name = "Lufttemperatur";
			wert = ((de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.onlinedaten.OdUfdsLuftTemperatur.Daten) datum)
					.getLuftTemperatur().getWert();

		} else if (sensor instanceof UfdsNiederschlagsArt) {
			datum = ((UfdsNiederschlagsArt) sensor).getOdUfdsNiederschlagsArt()
					.getDatum(OdUfdsNiederschlagsArt.Aspekte.ExterneErfassung);
			name = "Niederschlagsart";
			wert = ((de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.onlinedaten.OdUfdsNiederschlagsArt.Daten) datum)
					.getNiederschlagsArt().getWert();

		} else if (sensor instanceof UfdsNiederschlagsIntensitaet) {
			datum = ((UfdsNiederschlagsIntensitaet) sensor)
					.getOdUfdsNiederschlagsIntensitaet().getDatum(
							OdUfdsNiederschlagsIntensitaet.Aspekte.ExterneErfassung);
			name = "Niederschlagsintensität";
			wert = ((de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.onlinedaten.OdUfdsNiederschlagsIntensitaet.Daten) datum)
					.getNiederschlagsIntensitaet().getWert();

		} else if (sensor instanceof UfdsNiederschlagsMenge) {
			datum = ((UfdsNiederschlagsMenge) sensor)
					.getOdUfdsNiederschlagsMenge().getDatum(
							OdUfdsNiederschlagsMenge.Aspekte.ExterneErfassung);
			name = "Niederschlagsmenge";
			wert = ((de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.onlinedaten.OdUfdsNiederschlagsMenge.Daten) datum)
					.getNiederschlagsMenge().getWert();

		} else if (sensor instanceof UfdsRelativeLuftFeuchte) {
			datum = ((UfdsRelativeLuftFeuchte) sensor)
					.getOdUfdsRelativeLuftFeuchte().getDatum(
							OdUfdsRelativeLuftFeuchte.Aspekte.ExterneErfassung);
			name = "Relative Luftfeuchte";
			wert = ((de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.onlinedaten.OdUfdsRelativeLuftFeuchte.Daten) datum)
					.getRelativeLuftFeuchte().getWert();

		} else if (sensor instanceof UfdsRestSalz) {
			datum = ((UfdsRestSalz) sensor).getOdUfdsRestSalz()
					.getDatum(OdUfdsRestSalz.Aspekte.ExterneErfassung);
			name = "Restsalz";
			wert = ((de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.onlinedaten.OdUfdsRestSalz.Daten) datum)
					.getRestSalz().getWert();

		} else if (sensor instanceof UfdsSchneeHoehe) {
			datum = ((UfdsSchneeHoehe) sensor).getOdUfdsSchneeHoehe()
					.getDatum(OdUfdsSchneeHoehe.Aspekte.ExterneErfassung);
			name = "Schneehöhe";
			wert = ((de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.onlinedaten.OdUfdsSchneeHoehe.Daten) datum)
					.getSchneeHoehe().getWert();

		} else if (sensor instanceof UfdsSichtWeite) {
			datum = ((UfdsSichtWeite) sensor).getOdUfdsSichtWeite()
					.getDatum(OdUfdsSichtWeite.Aspekte.ExterneErfassung);
			name = "Sichtweite";
			wert = ((de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.onlinedaten.OdUfdsSichtWeite.Daten) datum)
					.getSichtWeite().getWert();

		} else if (sensor instanceof UfdsTaupunktTemperatur) {
			datum = ((UfdsTaupunktTemperatur) sensor)
					.getOdUfdsTaupunktTemperatur().getDatum(
							OdUfdsTaupunktTemperatur.Aspekte.ExterneErfassung);
			name = "Taupunkttemperatur";
			wert = ((de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.onlinedaten.OdUfdsTaupunktTemperatur.Daten) datum)
					.getTaupunktTemperatur().getWert();

		} else if (sensor instanceof UfdsTemperaturInTiefe1) {
			datum = ((UfdsTemperaturInTiefe1) sensor)
					.getOdUfdsTemperaturInTiefe1().getDatum(
							OdUfdsTemperaturInTiefe1.Aspekte.ExterneErfassung);
			name = "Temperatur in Tiefe 1";
			wert = ((de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.onlinedaten.OdUfdsTemperaturInTiefe1.Daten) datum)
					.getTemperaturInTiefe1().getWert();

		} else if (sensor instanceof UfdsTemperaturInTiefe2) {
			datum = ((UfdsTemperaturInTiefe2) sensor)
					.getOdUfdsTemperaturInTiefe2().getDatum(
							OdUfdsTemperaturInTiefe2.Aspekte.ExterneErfassung);
			name = "Temperatur in Tiefe 2";
			wert = ((de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.onlinedaten.OdUfdsTemperaturInTiefe2.Daten) datum)
					.getTemperaturInTiefe2().getWert();

		} else if (sensor instanceof UfdsTemperaturInTiefe3) {
			datum = ((UfdsTemperaturInTiefe3) sensor)
					.getOdUfdsTemperaturInTiefe3().getDatum(
							OdUfdsTemperaturInTiefe3.Aspekte.ExterneErfassung);
			name = "Temperatur in Tiefe 3";
			wert = ((de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.onlinedaten.OdUfdsTemperaturInTiefe3.Daten) datum)
					.getTemperaturInTiefe3().getWert();

		} else if (sensor instanceof UfdsWasserFilmDicke) {
			datum = ((UfdsWasserFilmDicke) sensor).getOdUfdsWasserFilmDicke()
					.getDatum(OdUfdsWasserFilmDicke.Aspekte.ExterneErfassung);
			name = "Wasserfilmdicke";
			wert = ((de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.onlinedaten.OdUfdsWasserFilmDicke.Daten) datum)
					.getWasserFilmDicke().getWert();

		} else if (sensor instanceof UfdsWindGeschwindigkeitMittelWert) {
			datum = ((UfdsWindGeschwindigkeitMittelWert) sensor)
					.getOdUfdsWindGeschwindigkeitMittelWert().getDatum(
							OdUfdsWindGeschwindigkeitMittelWert.Aspekte.ExterneErfassung);
			name = "Windgeschwindigkeit Mittel";
			wert = ((de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.onlinedaten.OdUfdsWindGeschwindigkeitMittelWert.Daten) datum)
					.getWindGeschwindigkeitMittelWert().getWert();

		} else if (sensor instanceof UfdsWindGeschwindigkeitSpitzenWert) {
			datum = ((UfdsWindGeschwindigkeitSpitzenWert) sensor)
					.getOdUfdsWindGeschwindigkeitSpitzenWert().getDatum(
							OdUfdsWindGeschwindigkeitSpitzenWert.Aspekte.ExterneErfassung);
			name = "Windgeschwindigkeit Spitze";
			wert = ((de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.onlinedaten.OdUfdsWindGeschwindigkeitSpitzenWert.Daten) datum)
					.getWindGeschwindigkeitSpitzenWert().getWert();

		} else if (sensor instanceof UfdsWindRichtung) {
			datum = ((UfdsWindRichtung) sensor).getOdUfdsWindRichtung()
					.getDatum(OdUfdsWindRichtung.Aspekte.ExterneErfassung);
			name = "Windrichtung";
			wert = ((de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.onlinedaten.OdUfdsWindRichtung.Daten) datum)
					.getWindRichtung().getWert();
		}

		if ((name == null) || (datum == null)) {
			label.setText("Unbekannter Sensor: " + sensor);
			label.setForeground(ColorConstants.red);
		} else {
			if ((datum.dGetDatenStatus() == Status.DATEN) && (wert != null)) {
				label.setText(name + " (" + sensor.getName() + "): "
						+ wert.toString());
				label.setForeground(ColorConstants.black);
			} else {
				label.setText(name + " (" + sensor.getName() + "): "
						+ datum.dGetDatenStatus());
				label.setForeground(ColorConstants.red);
			}
		}
	}

}
