/*
 * Rahmenwerk-Plug-in "Maßstäbliche Darstellung"
 * Copyright (C) 2018 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.buv.plugin.netz.umfelddatenmessstelle;

import static org.eclipse.swt.SWT.BORDER;
import static org.eclipse.swt.SWT.CENTER;
import static org.eclipse.ui.views.properties.tabbed.ITabbedPropertyConstants.HSPACE;

import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;

import com.bitctrl.lib.eclipse.emf.gef.commands.SetCommand;

import de.bsvrz.buv.plugin.dobj.properties.AbstractSection;
import de.bsvrz.buv.plugin.netz.model.NetzPackage;
import de.bsvrz.buv.plugin.netz.model.UmfeldDatenMessStelleDoModel;
import de.bsvrz.buv.plugin.netz.model.UmfeldDatenMessstelleImageTyp;

/**
 * @author BitCtrl Systems GmbH 2012, Christian Hösel
 */
public class UmfelddatenMessstellePropertySection
		extends AbstractSection<UmfeldDatenMessStelleDoModel> {

	private Label imageTypeLabel;
	private ComboViewer imageTypeSelektor;

	@Override
	public void createControls(final Composite parent,
			final TabbedPropertySheetPage aTabbedPropertySheetPage) {
		super.createControls(parent, aTabbedPropertySheetPage);
		final TabbedPropertySheetWidgetFactory factory = getWidgetFactory();
		final Composite container = factory.createFlatFormComposite(parent);

		createImageType(container);
	}

	private void createImageType(final Composite parent) {

		// Widgets anlegen

		final TabbedPropertySheetWidgetFactory factory = getWidgetFactory();
		imageTypeLabel = factory.createLabel(parent, "Darstellung:", BORDER);

		imageTypeSelektor = new ComboViewer(parent, SWT.NONE);
		imageTypeSelektor.setContentProvider(new ArrayContentProvider());
		imageTypeSelektor.setInput(UmfeldDatenMessstelleImageTyp.values());
		factory.adapt(parent);

		// Widgets layouten

		final FormData comboData = new FormData();
		comboData.left = new FormAttachment(imageTypeLabel, HSPACE);
		comboData.width = 150;
		comboData.top = new FormAttachment(0, 0);
		imageTypeSelektor.getControl().setLayoutData(comboData);
		final FormData labelData = new FormData();
		labelData.left = new FormAttachment(0, 0);
		labelData.width = STANDARD_LABEL_WIDTH;
		labelData.top = new FormAttachment(imageTypeSelektor.getControl(), 0,
				CENTER);
		imageTypeLabel.setLayoutData(labelData);

		// Listener anmelden

		imageTypeSelektor
				.addSelectionChangedListener(new ISelectionChangedListener() {

					@Override
					public void selectionChanged(
							final SelectionChangedEvent event) {
						final Object object = ((IStructuredSelection) event
								.getSelection()).getFirstElement();
						if (object instanceof UmfeldDatenMessstelleImageTyp) {
							final SetCommand cmd = new SetCommand(getElement(),
									NetzPackage.Literals.UMFELD_DATEN_MESS_STELLE_DO_MODEL__IMAGE_TYP,
									object);
							getCommandStack().execute(cmd);
						}
					}
				});
	}

	@Override
	public void refresh() {
		setImageTypToWidget();
	}

	private void setImageTypToWidget() {
		final UmfeldDatenMessstelleImageTyp imageTyp = getElement()
				.getImageTyp();

		final boolean isChanged = ((IStructuredSelection) imageTypeSelektor
				.getSelection()).getFirstElement() != imageTyp;
		if (isChanged) {
			if (imageTyp == null) {
				imageTypeSelektor.setSelection(new StructuredSelection(
						UmfeldDatenMessstelleImageTyp.STANDARDBILD));
			} else {
				imageTypeSelektor
						.setSelection(new StructuredSelection(imageTyp));
			}
		}
	}
}
