/*
 * Rahmenwerk-Plug-in "Parametrierung"
 * Copyright (C) 2018 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.buv.plugin.param.editors.beispiel;

import java.util.Date;
import java.util.Dictionary;

import org.eclipse.swt.SWT;
import org.eclipse.ui.forms.editor.IFormPage;
import org.osgi.framework.Bundle;

import de.bsvrz.buv.plugin.param.editors.AttributePropagationMode;
import de.bsvrz.buv.plugin.param.editors.IParameterFormPageFactory;
import de.bsvrz.buv.plugin.param.editors.ParameterEditor;
import de.bsvrz.buv.plugin.param.editors.ParameterEditorInfo;
import de.bsvrz.buv.plugin.param.editors.ParameterEditorInput;
import de.bsvrz.puk.param.lib.Parameter;

/**
 * Fabrik zum Erzeugen einer {@link BeispielParamEditorFormPage}. Es handelt
 * sich nur um ein Beispiel.
 *
 * @author BitCtrl Systems GmbH, Albrecht Uhlmann
 *
 *
 */
public class BeispielParamEditorFormPageFactory implements IParameterFormPageFactory {

	/**
	 * Konstante für die einzige Attributgruppe, die dieser Editor bearbeiten kann.
	 */
	public static final String EDITABLE_ATTRIBUTE_GROUP = "atg.verkehrsLageVerfahren1";

	@Override
	public IFormPage createFormPage(final ParameterEditor parameterEditor, final int index) {
		return new BeispielParamEditorFormPage(parameterEditor, BeispielParamEditorFormPage.class.getName(), "Daten");
	}

	@Override
	public boolean canEdit(final ParameterEditorInput editorInput) {
		boolean result = true;
		/* TODO hier müssen sicher andere Bedingungen geprüft werden */
		for (final Parameter p : editorInput.getParameters()) {
			if (!EDITABLE_ATTRIBUTE_GROUP.equals(p.getAtg().getPid())) {
				result = false;
				break;
			}
		}
		return result;
	}

	@Override
	public ParameterEditorInfo getEditorInfo() {
		final Bundle bundle = BeispielParamEditorPlugin.getDefault().getBundle();
		final Dictionary<?, ?> headers = bundle.getHeaders();
		return new ParameterEditorInfo((String) headers.get("Bundle-Name"), (String) headers.get("Bundle-Vendor"),
				bundle.getVersion().toString(), new Date(bundle.getLastModified()));
	}

	@Override
	public int getNumFormPages(final ParameterEditor parameterEditor) {
		return 1;
	}

	@Override
	public AttributePropagationMode getDefaultAttributePropagationMode() {
		return AttributePropagationMode.ONLY_EDITED;
	}

	@Override
	public int getAdequacy(final ParameterEditorInput editorInput) {
		return ADEQUACY_SPECIAL;
	}

	@Override
	public String getHelpContextId() {
		return BeispielParamEditorPlugin.PLUGIN_ID + "." + BeispielParamEditorFormPage.class.getSimpleName();
	}

	@Override
	public int getFormStyleBits() {
		// Der Standardwert
		return SWT.H_SCROLL | SWT.V_SCROLL;
	}

}
