/*
 * Rahmenwerk-Plug-in "Parametrierung"
 * Copyright (C) 2018 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.buv.plugin.param.editors.beispiel;

import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;

import de.bsvrz.buv.plugin.param.ParamUtils;
import de.bsvrz.buv.rw.basislib.legende.ICustomLegende;

/**
 * Legendenabschnitt für den Beispieleditor. Er zeigt eine statische
 * Erläuterung.
 *
 * @author BitCtrl Systems GmbH, Albrecht Uhlmann
 *
 *
 */
public class BeispielParamEditorLegendenAbschnitt implements ICustomLegende {

	@Override
	public void createControl(final Composite flaeche) {
		Label l;
		GridData gd;
		flaeche.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true));
		flaeche.setLayout(new GridLayout(1, false));
		final Composite farbenComposite = new Composite(flaeche, SWT.NONE);
		farbenComposite.setLayout(new GridLayout(2, false));
		// Kopf
		l = new Label(farbenComposite, SWT.NONE);
		l.setText("Item");
		gd = new GridData(SWT.LEFT, SWT.TOP, true, false);
		l.setLayoutData(gd);
		l = new Label(farbenComposite, SWT.NONE);
		l.setText("Erklärung");
		gd = new GridData(SWT.LEFT, SWT.TOP, true, false);
		l.setLayoutData(gd);

		// Inhalt
		// Normaldruck
		l = new Label(farbenComposite, SWT.NONE);
		l.setText("Item 1");
		gd = new GridData(SWT.LEFT, SWT.TOP, true, false);
		l.setLayoutData(gd);
		l = new Label(farbenComposite, SWT.NONE);
		l.setText("Erklärung 1");
		gd = new GridData(SWT.LEFT, SWT.TOP, true, false);
		l.setLayoutData(gd);

		// Fettdruck
		l = new Label(farbenComposite, SWT.NONE);
		l.setText("Item 2");
		l.setFont(ParamUtils.getBoldSystemFont());
		gd = new GridData(SWT.LEFT, SWT.TOP, true, false);
		l.setLayoutData(gd);
		l = new Label(farbenComposite, SWT.WRAP);
		l.setText("Erklärung 2");
		gd = new GridData(SWT.LEFT, SWT.TOP, true, false);
		l.setLayoutData(gd);
	}

	@Override
	public String getTitel() {
		return "Beispiel-Parametereditor";
	}

	@Override
	public Control getControl() {
		return null;
	}

	@Override
	public Corner getDefaultCorner() {
		return null;
	}

}
