/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.buv.plugin.param.editors.beispiel;

import de.bsvrz.buv.plugin.param.editors.ParameterSaveResultEnum;
import de.bsvrz.buv.plugin.param.editors.ParameterSaver;
import de.bsvrz.buv.plugin.param.editors.beispiel.internal.RahmenwerkService;
import de.bsvrz.dav.daf.main.Data;
import de.bsvrz.dav.daf.main.config.SystemObject;
import de.bsvrz.puk.param.lib.Parameter;
import de.bsvrz.puk.param.lib.ParameterInfo;
import de.bsvrz.puk.param.lib.daten.DataWithTime;
import java.util.Map;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.AbstractFormPart;

public class BeispielParamEditorFormPart
extends AbstractFormPart {
    private final Map<SystemObject, Text[]> editedControls;
    private final Map<SystemObject, Parameter> referenzParameters;

    public BeispielParamEditorFormPart(Map<SystemObject, Text[]> editedControls, Map<SystemObject, Parameter> referenzParameters) {
        this.editedControls = editedControls;
        this.referenzParameters = referenzParameters;
    }

    public void commit(boolean onSave) {
        Parameter[] editedParameters = new Parameter[this.editedControls.size()];
        int parameterLoop = 0;
        for (Map.Entry<SystemObject, Text[]> entry : this.editedControls.entrySet()) {
            SystemObject systemObject = entry.getKey();
            Parameter referenzParameter = this.referenzParameters.get(systemObject);
            ParameterInfo info = new ParameterInfo(systemObject, referenzParameter.getTyp(), referenzParameter.getAtg(), referenzParameter.getSim());
            Data data = referenzParameter.hasData() ? referenzParameter.getData().createModifiableCopy() : RahmenwerkService.getService().getObjektFactory().getDav().createData(referenzParameter.getAtg());
            Text[] texte = entry.getValue();
            int loop = 0;
            while (loop < texte.length) {
                Text t = texte[loop];
                String itemName = (String)t.getData("itemName");
                String valueString = t.getText();
                int value = -1;
                if (!valueString.isEmpty()) {
                    value = Integer.parseInt(valueString);
                }
                data.getUnscaledValue(itemName).set(value);
                ++loop;
            }
            editedParameters[parameterLoop] = new Parameter(info, new DataWithTime(data, System.currentTimeMillis()));
            ++parameterLoop;
        }
        ParameterSaveResultEnum saveResult = ParameterSaver.saveParameters((Parameter[])editedParameters, (String)ParameterSaver.buildDefaultUrsache((Parameter[])editedParameters, (Parameter[])editedParameters, (ParameterSaver.ParameterSaveUrsache)ParameterSaver.ParameterSaveUrsache.PARAMETRIERT));
        switch (saveResult) {
            case PARAMETER_SAVE_FAILURE: {
                throw new IllegalStateException(ParameterSaver.getLastError());
            }
            case PARAMETER_SAVE_CANCEL: {
                break;
            }
            case PARAMETER_SAVE_SUCCESS: {
                super.commit(onSave);
                break;
            }
        }
    }
}

