/*
 * Rahmenwerk-Plug-in "Parametrierung"
 * Copyright (C) 2018 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.buv.plugin.param.editors.table.actions;

import java.util.List;

import org.eclipse.jface.viewers.TableViewer;

import de.bsvrz.buv.plugin.param.ParamSharedImage;
import de.bsvrz.buv.plugin.param.editors.DataValueTextArrayMemberCombinator;
import de.bsvrz.buv.plugin.param.editors.table.edit.IParamTableEditorModifyListener;
import de.bsvrz.buv.plugin.param.editors.table.provider.ParameterTableEditorItem;
import de.bsvrz.buv.plugin.param.editors.table.provider.PlainDataValue;
import de.bsvrz.dav.daf.main.config.AttributeSet;

/**
 * Aktionsklasse zum Setzen eines Feldelements auf den Wert
 * {@link DataValueTextArrayMemberCombinator#IDENTIFIER_NICHT_DEFINIERT}.
 *
 * @author BitCtrl Systems GmbH, Albrecht Uhlmann
 */
public class TableParamEditorInvalidateElementAction extends TableParamEditorAction {

	/**
	 * Konstruktor reicht nur die Werte durch und setzt den Image Descriptor.
	 *
	 * @param tableViewer
	 *            der Tableviewer, aus dem heraus die Aktion aufgerufen wurde. Der
	 *            wird nach dem Ausführen aktualisiert.
	 * @param modifyListener
	 *            Ein Modifylistener (kann <code>null</code> sein), der über die
	 *            Änderung benachrichtigt wird. Als newValue wird dabei
	 *            <code>null</code> übergeben.
	 */
	public TableParamEditorInvalidateElementAction(final TableViewer tableViewer,
			final IParamTableEditorModifyListener modifyListener) {
		super("Setze " + DataValueTextArrayMemberCombinator.IDENTIFIER_NICHT_DEFINIERT, tableViewer, modifyListener);
		setImageDescriptor(ParamSharedImage.ERROR_NULL.getImageDescriptor());
	}

	@Override
	public void run() {
		final AttributeSet parentAttributeSet = getEditedValue().getParentAttributeSet();
		if (null == parentAttributeSet) {
			final String pid = getEditedValue().getPid();
			getEditedValue().invalidate();
			if (null != getModifyListener()) {
				getModifyListener().valueModified(getEditedItem(), getEditedIndex(), pid, null,
						getEditedValue().getAttributeType());
			}
		} else {
			handleListInvalidation();
		}
		getEditedItem().setDirty(true);
		getTableViewer().refresh();
	}

	/**
	 * Spezialbehandlung: Alle Elemente, die zur übergeordneten Attributliste
	 * gehören, werden ebenfalls invalidiert.
	 */
	private void handleListInvalidation() {
		final List<PlainDataValue> reducedList = getEditedItem().getValuesOfList(getAri(), 0, false);
		for (final PlainDataValue value : reducedList) {
			final int pos = ParameterTableEditorItem.bestimmePositionInnerhalbFeld(getEditedItem().getPlainDataValues(),
					value.getPath());
			final String pid = value.getPid();
			value.invalidate();
			if (null != getModifyListener()) {
				getModifyListener().valueModified(getEditedItem(), pos, pid, null, value.getAttributeType());
			}
		}
	}

	@Override
	public void setEditedValue(final ParameterTableEditorItem editedItem, final int editedIndex) {
		super.setEditedValue(editedItem, editedIndex);
		final int firstUndefinedIndex = editedItem.getFirstUndefinedIndexOfArray(editedIndex);
		setEnabled(getEditedValue().isValid() && (getAri().getIndex() >= 0)
				&& ((firstUndefinedIndex - 1) == getAri().getIndex()));
	}
}
