/*
 * Rahmenwerk-Plug-in "Parametrierung"
 * Copyright (C) 2018 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.buv.plugin.param.editors.table.edit;

import de.bsvrz.buv.plugin.param.editors.table.provider.ParameterTableEditorItem;
import de.bsvrz.buv.plugin.param.editors.table.provider.PlainDataValue;
import de.bsvrz.dav.daf.main.config.AttributeType;

/**
 * Schnittstelle zum Zugriff auf Objekte, die die Attributpropagierung
 * behandeln.
 *
 * @author BitCtrl Systems GmbH, Albrecht Uhlmann
 *
 */
public interface IParamTableEditorModifyListener {

	/**
	 * Aufzurufen, wenn ein {@link PlainDataValue} modifiziert wurde.
	 *
	 * @param item
	 *            das Containerobjekt, in dem das modifizierte Objekt enthalten ist
	 * @param index
	 *            der Index des modifizierten Objektes innerhalb item
	 * @param oldValue
	 *            alter Wert
	 * @param newValue
	 *            neuer Wert
	 * @param attributeType
	 *            DAF-Attributtyp
	 */
	void valueModified(ParameterTableEditorItem item, int index, Object oldValue, Object newValue,
			AttributeType attributeType);

	/**
	 * Aufforderung, das Kontextmenü anzuzeigen.
	 *
	 * @param editedValue
	 *            das Objekt, auf das die Operationen im Kontextmenü angewendet
	 *            werden sollen.
	 * @param editedItem
	 *            das bearbeitete Item
	 * @param editedIndex
	 *            der Index auf den bearbeiteten {@link PlainDataValue}.
	 */
	void showContextMenu(PlainDataValue editedValue, ParameterTableEditorItem editedItem, int editedIndex);

	/**
	 * Benachrichtigung, dass das grafische Layout geändert wurd bzw. zu ändern ist.
	 */
	void layoutModified();
}
