/*
 * Rahmenwerk-Plug-in "Parametrierung"
 * Copyright (C) 2018 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.buv.plugin.param.editors.table.provider;

/**
 * Hilfsklasse zum Aufteilen des Pfades eines Attributs in Feldname, Index
 * innerhalb des Feldes und Restpfad.
 *
 * @author BitCtrl Systems GmbH, Albrecht Uhlmann
 *
 *
 */
public class ArrayNameAndIndex {

	/**
	 * Index innerhalb des Feldes.
	 */
	private int index = -1;

	/**
	 * Der Name des Feldes. Kann leer, aber nicht null sein.
	 */
	private String arrayName = "";

	/**
	 * Der Restpfad nach dem Feldindex. Kann leer sein.
	 */
	private String restPfad = "";

	@Override
	public String toString() {
		return "index=" + index + ", Feldname=" + arrayName + ", Restpfad=" + restPfad;
	}

	/**
	 * Liefert den Index innerhalb des Feldes.
	 *
	 * @return der Index
	 */
	public int getIndex() {
		return index;
	}

	/**
	 * Setzt den Index innerhalb des Feldes.
	 *
	 * @param index
	 *            der Index
	 */
	public void setIndex(final int index) {
		this.index = index;
	}

	/**
	 * Liefert den Namen des Feldes. Kann leer, aber nicht null sein.
	 *
	 * @return der Feldname
	 */
	public String getArrayName() {
		return arrayName;
	}

	/**
	 * Setzt den Namen des Feldes. Kann leer, aber nicht null sein.
	 *
	 * @param arrayName
	 *            der Feldname
	 */
	public void setArrayName(final String arrayName) {
		this.arrayName = arrayName;
	}

	/**
	 * Liefert den Restpfad nach dem Feldindex. Kann leer sein.
	 *
	 * @return der Restpfad
	 */
	public String getRestPfad() {
		return restPfad;
	}

	/**
	 * Setzt den Restpfad nach dem Feldindex. Kann leer sein.
	 *
	 * @param restPfad
	 *            der Restpfad
	 */
	public void setRestPfad(final String restPfad) {
		this.restPfad = restPfad;
	}
}
