/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.buv.plugin.param.editors.table;

import com.bitctrl.lib.eclipse.actions.ExportSWTTableViewerToCSVorHTMLAction;
import de.bsvrz.buv.plugin.param.ParamUtils;
import de.bsvrz.buv.plugin.param.editors.AbstractParameterFormPage;
import de.bsvrz.buv.plugin.param.editors.ParameterEditor;
import de.bsvrz.buv.plugin.param.editors.ParameterEditorInput;
import de.bsvrz.buv.plugin.param.editors.table.TableParamEditorFormPart;
import de.bsvrz.buv.plugin.param.editors.table.TableParamEditorPlugin;
import de.bsvrz.buv.plugin.param.editors.table.actions.TableParamEditorAction;
import de.bsvrz.buv.plugin.param.editors.table.actions.TableParamEditorInvalidateElementAction;
import de.bsvrz.buv.plugin.param.editors.table.edit.IParamTableEditorModifyListener;
import de.bsvrz.buv.plugin.param.editors.table.edit.TableParamEditorAddElementAction;
import de.bsvrz.buv.plugin.param.editors.table.edit.TableParamEditorDoubleClickListener;
import de.bsvrz.buv.plugin.param.editors.table.provider.ArrayNameAndIndex;
import de.bsvrz.buv.plugin.param.editors.table.provider.ParamTableEditorLabelProvider;
import de.bsvrz.buv.plugin.param.editors.table.provider.ParameterTableEditorItem;
import de.bsvrz.buv.plugin.param.editors.table.provider.PlainDataValue;
import de.bsvrz.buv.rw.basislib.printing.RwPrintable;
import de.bsvrz.dav.daf.main.config.AttributeType;
import de.bsvrz.puk.param.lib.Parameter;
import de.bsvrz.sys.funclib.debug.Debug;
import java.util.Arrays;
import java.util.List;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.ITableColorProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.nebula.paperclips.core.BigPrint;
import org.eclipse.nebula.paperclips.core.ImagePrint;
import org.eclipse.nebula.paperclips.core.Print;
import org.eclipse.nebula.paperclips.core.border.Border;
import org.eclipse.nebula.paperclips.core.border.LineBorder;
import org.eclipse.nebula.paperclips.core.grid.CellBackgroundProvider;
import org.eclipse.nebula.paperclips.core.grid.DefaultGridLook;
import org.eclipse.nebula.paperclips.core.grid.GridColumn;
import org.eclipse.nebula.paperclips.core.grid.GridLook;
import org.eclipse.nebula.paperclips.core.grid.GridPrint;
import org.eclipse.nebula.paperclips.core.page.PagePrint;
import org.eclipse.nebula.paperclips.core.text.TextPrint;
import org.eclipse.nebula.paperclips.core.text.TextStyle;
import org.eclipse.swt.custom.TableCursor;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.events.ExpansionAdapter;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;

public class TableParamEditorFormPage
extends AbstractParameterFormPage
implements IParamTableEditorModifyListener,
RwPrintable {
    private static final Debug DEBUG = Debug.getLogger();
    public static final String TABLEDATA_KEY_CURSOR = "CURSOR";
    public static final String CURSORDATA_KEY_TABLE = "TABLE";
    private static final int DEFAULT_COLUMN_WIDTH = 120;
    private TableViewer viewer;
    private MenuManager contextMenuManager;
    private TableParamEditorAction elementAdd;
    private TableParamEditorAction elementInvalidate;
    private Section datenSektion;

    public TableParamEditorFormPage(FormEditor editor, String id, int index) {
        super(editor, id, ParameterEditor.VALID_INDICES[index]);
    }

    protected void createFormContent(IManagedForm managedForm) {
        final ScrolledForm form = managedForm.getForm();
        form.addControlListener(new ControlListener(){

            public void controlResized(ControlEvent e) {
                DEBUG.finer("form Resize!!!", (Object)form.getSize());
                TableParamEditorFormPage.this.layoutModified();
            }

            public void controlMoved(ControlEvent e) {
            }
        });
        FormToolkit toolkit = managedForm.getToolkit();
        GridLayout layout = new GridLayout();
        form.getBody().setLayout((Layout)layout);
        ParameterEditorInput pei = (ParameterEditorInput)this.getEditorInput();
        Parameter[] parameters = null;
        switch (this.getIndex()) {
            case 0: {
                parameters = pei.getParameters();
                break;
            }
            case 1: {
                parameters = pei.getSollParameters();
                break;
            }
            case 2: {
                parameters = pei.getDefaultParameters();
                break;
            }
            case 3: {
                parameters = pei.getIstParameters();
                break;
            }
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Index " + this.getIndex() + " wird nicht unterst\u00fctzt.\n" + "G\u00fcltige Indices sind von 0 bis 3," + " entsprechend dens Aspekten " + Arrays.toString(ParameterEditor.VALID_INDICES));
        }
        StringBuilder b = new StringBuilder("Tabellen-Parameterdialog: ");
        b.append(parameters.length);
        b.append(" Objekt");
        if (parameters.length > 1) {
            b.append('e');
        }
        b.append(" in Bearbeitung");
        form.setText(b.toString());
        boolean readOnly = this.getIndex() > 0;
        this.erzeugeAbschnittDaten(form, toolkit, readOnly);
        TableParamEditorFormPart formPart = new TableParamEditorFormPart(readOnly, this.viewer);
        managedForm.addPart((IFormPart)formPart);
        this.getEditor().getSite().setSelectionProvider((ISelectionProvider)this.viewer);
        IToolBarManager toolBarManager = form.getToolBarManager();
        ExportSWTTableViewerToCSVorHTMLAction exportAction = new ExportSWTTableViewerToCSVorHTMLAction(this.viewer);
        exportAction.setTitleText(((ParameterEditor)this.getEditor()).getDefaultHeader(true));
        toolBarManager.add((IAction)exportAction);
        toolBarManager.update(true);
        this.setExportAction((IAction)exportAction);
        super.createFormContent(managedForm);
    }

    public ParameterTableEditorItem[] createTableItems(Parameter[] parameters) {
        ParameterTableEditorItem[] tableItems = new ParameterTableEditorItem[parameters.length];
        int loop = 0;
        while (loop < tableItems.length) {
            tableItems[loop] = new ParameterTableEditorItem(parameters[loop], false, false);
            int innerLoop = 0;
            while (innerLoop < loop) {
                tableItems[loop].catchUpByData(tableItems[innerLoop]);
                ++innerLoop;
            }
            ++loop;
        }
        loop = 0;
        while (loop < tableItems.length) {
            tableItems[loop].run();
            ++loop;
        }
        return tableItems;
    }

    private void erzeugeAbschnittDaten(final ScrolledForm form, FormToolkit toolkit, boolean readOnly) {
        int defaultNumColumns = 10;
        this.datenSektion = toolkit.createSection(form.getBody(), 450);
        GridData gd = new GridData(16384, 128, true, true);
        this.datenSektion.setLayoutData((Object)gd);
        this.datenSektion.setText("Datenbereich");
        this.datenSektion.setDescription("In diesem Abschnitt erfolgt das Editieren (10 Einzelattribute)");
        this.datenSektion.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

            public void expansionStateChanged(ExpansionEvent e) {
                form.reflow(true);
            }
        });
        Composite sectionClient = toolkit.createComposite((Composite)this.datenSektion);
        sectionClient.setLayout((Layout)new GridLayout(1, false));
        gd = new GridData(16384, 128, false, false);
        gd.heightHint = 100;
        gd.widthHint = 1350;
        sectionClient.setLayoutData((Object)gd);
        Table table = toolkit.createTable(sectionClient, 2882);
        gd = new GridData(16384, 128, false, false);
        gd.heightHint = 100;
        gd.widthHint = 1350;
        table.setLayoutData((Object)gd);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        if (!readOnly) {
            this.setUpTableCursor(table);
        }
        this.viewer = new TableViewer(table);
        this.viewer.setLabelProvider((IBaseLabelProvider)new ParamTableEditorLabelProvider((ParameterEditorInput)this.getEditorInput(), readOnly));
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        if (!readOnly) {
            this.viewer.addDoubleClickListener((IDoubleClickListener)new TableParamEditorDoubleClickListener(this));
            this.createContextMenu(this.viewer);
        }
        this.datenSektion.setClient((Control)sectionClient);
    }

    public void fillTable(ParameterTableEditorItem[] tableItems) {
        this.clearTable();
        Table table = this.viewer.getTable();
        List<PlainDataValue> plainDataValues = tableItems[0].getPlainDataValues();
        int numColumns = plainDataValues.size();
        TableColumn column = new TableColumn(table, 0);
        column.setText("Objekt");
        column.setWidth(150);
        int loop = 0;
        while (loop < numColumns) {
            column = new TableColumn(table, 0);
            column.setWidth(120);
            PlainDataValue plainDataValue = plainDataValues.get(loop);
            column.setText(plainDataValue.getPath());
            String genericInfoText = ParamUtils.getInfotextForAttributeType((AttributeType)plainDataValue.getAttributeType(), (boolean)true);
            String completeInfoText = "Vollst\u00e4ndiger Attributname: ";
            completeInfoText = String.valueOf(completeInfoText) + plainDataValue.getPath();
            completeInfoText = String.valueOf(completeInfoText) + '\n';
            completeInfoText = String.valueOf(completeInfoText) + genericInfoText;
            column.setToolTipText(completeInfoText);
            ++loop;
        }
        this.viewer.setInput((Object)tableItems);
        TableColumn[] tableColumnArray = table.getColumns();
        int n = tableColumnArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableColumn c = tableColumnArray[n2];
            c.pack();
            ++n2;
        }
        column = table.getColumn(0);
        column.setWidth(16 + column.getWidth());
        this.fitTable();
    }

    private void fitTable() {
        int realHeight;
        Table table = this.viewer.getTable();
        GridData tableGridData = (GridData)table.getLayoutData();
        Composite sectionClient = (Composite)this.datenSektion.getClient();
        GridData sectionClientGridData = (GridData)sectionClient.getLayoutData();
        Point formSize = this.getManagedForm().getForm().getSize();
        int realWidth = 0;
        TableColumn[] tableColumnArray = table.getColumns();
        int n = tableColumnArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableColumn c = tableColumnArray[n2];
            realWidth += c.getWidth();
            ++n2;
        }
        tableGridData.widthHint = Math.min(formSize.x - 40, realWidth);
        sectionClientGridData.widthHint = Math.min(formSize.x - 40, realWidth);
        if (table.getItemCount() > 0) {
            Rectangle r = table.getItem(0).getBounds();
            int cellheight = r.height;
            if (table.getLinesVisible()) {
                ++cellheight;
            }
            realHeight = table.getHeaderHeight() + table.getItemCount() * cellheight;
        } else {
            realHeight = 26;
        }
        tableGridData.heightHint = Math.min(formSize.y - 110, realHeight);
        sectionClientGridData.heightHint = Math.min(formSize.y - 110, realHeight);
    }

    public void updateDatenSectionDescription(ParameterTableEditorItem[] tableItems) {
        int numEinzelAttribute = tableItems[0].getPlainDataValues().size();
        this.datenSektion.setDescription("In diesem Abschnitt erfolgt das Editieren (" + numEinzelAttribute + " Einzelattribute)");
    }

    public void clearTable() {
        Table table = this.viewer.getTable();
        table.removeAll();
        TableColumn[] tableColumnArray = table.getColumns();
        int n = tableColumnArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableColumn c = tableColumnArray[n2];
            c.dispose();
            ++n2;
        }
    }

    private void setUpTableCursor(final Table table) {
        final TableCursor cursor = new TableCursor(table, 0);
        table.setData(TABLEDATA_KEY_CURSOR, (Object)cursor);
        cursor.setData(CURSORDATA_KEY_TABLE, (Object)table);
        cursor.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
            }
        });
        cursor.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 262144 || e.keyCode == 131072 || (e.stateMask & 0x40000) != 0 || (e.stateMask & 0x20000) != 0) {
                    cursor.setVisible(false);
                }
            }
        });
        cursor.addMouseListener((MouseListener)new TableParamEditorDoubleClickListener(this));
        table.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                if (e.keyCode == 262144 && (e.stateMask & 0x20000) != 0) {
                    return;
                }
                if (e.keyCode == 131072 && (e.stateMask & 0x40000) != 0) {
                    return;
                }
                if (e.keyCode != 262144 && (e.stateMask & 0x40000) != 0) {
                    return;
                }
                if (e.keyCode != 131072 && (e.stateMask & 0x20000) != 0) {
                    return;
                }
                TableItem[] selection = table.getSelection();
                TableItem row = selection.length == 0 ? table.getItem(table.getTopIndex()) : selection[0];
                table.showItem(row);
                cursor.setVisible(true);
                cursor.setFocus();
            }
        });
    }

    private void createContextMenu(TableViewer tableViewer) {
        Table table = tableViewer.getTable();
        TableCursor cursor = (TableCursor)table.getData(TABLEDATA_KEY_CURSOR);
        if (cursor == null) {
            return;
        }
        this.elementAdd = new TableParamEditorAddElementAction(tableViewer, this);
        this.elementInvalidate = new TableParamEditorInvalidateElementAction(tableViewer, this);
        this.contextMenuManager = new MenuManager();
        this.contextMenuManager.setRemoveAllWhenShown(true);
        this.contextMenuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager mgr) {
                TableParamEditorFormPage.this.fillContextMenu(mgr);
            }
        });
        Menu menu = this.contextMenuManager.createContextMenu(tableViewer.getControl());
        cursor.setMenu(menu);
    }

    void fillContextMenu(IMenuManager mgr) {
        try {
            mgr.add((IContributionItem)new GroupMarker("additions"));
            TableCursor cursor = (TableCursor)this.viewer.getTable().getData(TABLEDATA_KEY_CURSOR);
            ParameterTableEditorItem item = (ParameterTableEditorItem)cursor.getRow().getData();
            int effCol = cursor.getColumn() - 1;
            PlainDataValue editedValue = null;
            if (effCol >= 0 && effCol < item.getPlainDataValues().size()) {
                editedValue = item.getPlainDataValues().get(effCol);
            }
            this.elementAdd.setEditedValue(item, effCol);
            this.elementInvalidate.setEditedValue(item, effCol);
            DEBUG.finest("fillCintextMenu: selectedObject=" + editedValue);
            boolean filled = false;
            this.contextMenuManager.add((IAction)this.elementAdd);
            this.contextMenuManager.add((IAction)this.elementInvalidate);
            filled = true;
            mgr.setVisible(filled);
        }
        catch (IllegalStateException e) {
            TableParamEditorPlugin.getDefault().getLogger().error("Fehler beim Bef\u00fcllen des Kontextmen\u00fcs", (Throwable)e);
        }
    }

    private void handleAttributePropagation(ParameterTableEditorItem item, int index, Object oldValue, Object newValue, AttributeType attributeType) {
        ParameterTableEditorItem[] tableItems;
        switch (this.getParameterEditorInput().getAttributePropagationMode()) {
            case ONLY_EDITED: {
                return;
            }
            case EDITED_AND_SELECTION: {
                throw new UnsupportedOperationException("Attributpropagierung auf Auswahl wird nicht unterst\u00fctzt");
            }
            case ALL: {
                break;
            }
        }
        PlainDataValue editedValue = item.getPlainDataValues().get(index);
        ParameterTableEditorItem[] parameterTableEditorItemArray = tableItems = (ParameterTableEditorItem[])this.viewer.getInput();
        int n = tableItems.length;
        int n2 = 0;
        while (n2 < n) {
            ParameterTableEditorItem tableItem = parameterTableEditorItemArray[n2];
            if (item != tableItem) {
                int firstUndefinedIndex = tableItem.getFirstUndefinedIndexOfArray(index);
                PlainDataValue valueToModify = tableItem.getPlainDataValues().get(index);
                ArrayNameAndIndex ari = ParameterTableEditorItem.getArrayIndexFromPath(valueToModify.getPath());
                boolean modified = false;
                if (newValue == null) {
                    if ((-2 == ari.getIndex() || ari.getIndex() >= 0 && (firstUndefinedIndex - 1 == ari.getIndex() || firstUndefinedIndex == ari.getIndex())) && valueToModify.isValid()) {
                        valueToModify.invalidate();
                        modified = true;
                    }
                } else if (valueToModify.isValid() || ari.getIndex() >= 0 && firstUndefinedIndex == ari.getIndex()) {
                    String oldPid = valueToModify.getPid();
                    if (!editedValue.getPid().equals(oldPid)) {
                        valueToModify.setPid(editedValue.getPid());
                        modified = true;
                    }
                }
                if (modified) {
                    tableItem.setDirty(true);
                }
            }
            ++n2;
        }
    }

    @Override
    public void valueModified(ParameterTableEditorItem item, int index, Object oldValue, Object newValue, AttributeType attributeType) {
        List<PlainDataValue> plainDataValues = item.getPlainDataValues();
        PlainDataValue editedValue = plainDataValues.get(index);
        DEBUG.fine("Item modifiziert: " + editedValue + "\nAlt: " + oldValue + "\nNeu: " + newValue + "\nATT: " + attributeType);
        TableParamEditorFormPart formPart = null;
        IFormPart[] iFormPartArray = this.getManagedForm().getParts();
        int n = iFormPartArray.length;
        int n2 = 0;
        while (n2 < n) {
            IFormPart part0 = iFormPartArray[n2];
            if (part0 instanceof TableParamEditorFormPart) {
                formPart = (TableParamEditorFormPart)part0;
                break;
            }
            ++n2;
        }
        if (formPart != null) {
            formPart.markDirty();
            this.handleAttributePropagation(item, index, oldValue, newValue, attributeType);
        }
        this.updateDatenSectionDescription(new ParameterTableEditorItem[]{item});
        this.fitTable();
        ((Composite)this.datenSektion.getClient()).layout();
        this.viewer.refresh();
        this.moveTableCursor();
    }

    private void moveTableCursor() {
        Table table = this.viewer.getTable();
        TableCursor cursor = (TableCursor)table.getData(TABLEDATA_KEY_CURSOR);
        int cursorCol = cursor.getColumn();
        cursorCol = cursorCol == table.getColumnCount() - 1 ? --cursorCol : ++cursorCol;
        cursor.setSelection(cursor.getRow(), cursorCol);
    }

    @Override
    public void showContextMenu(PlainDataValue editedValue, ParameterTableEditorItem editedItem, int editedIndex) {
        this.elementAdd.setEditedValue(editedItem, editedIndex);
        this.contextMenuManager.setVisible(true);
    }

    @Override
    public void layoutModified() {
        this.fitTable();
        this.getManagedForm().reflow(true);
    }

    public ParameterEditorInput getParameterEditorInput() {
        return (ParameterEditorInput)this.getEditorInput();
    }

    public PagePrint getDruckAuftrag() {
        final Table table = this.viewer.getTable();
        FontData systemFontData = table.getDisplay().getSystemFont().getFontData()[0];
        String header = ((ParameterEditor)this.getEditor()).getDefaultHeader(false);
        GridPrint grid = new GridPrint();
        grid.addColumn(new GridColumn(16384, -1, 0));
        grid.add((Print)new TextPrint(header, new FontData(systemFontData.getName(), systemFontData.getHeight() + 2, 1)));
        GridPrint tabelle = new GridPrint();
        DefaultGridLook look = new DefaultGridLook();
        look.setHeaderBackground(new RGB(200, 200, 200));
        if (this.viewer.getLabelProvider() instanceof ITableColorProvider) {
            final ITableColorProvider colorProvider = (ITableColorProvider)this.viewer.getLabelProvider();
            look.setBodyBackgroundProvider(new CellBackgroundProvider(){
                private final RGB white = new RGB(255, 255, 255);

                public RGB getCellBackground(int row, int column, int colspan) {
                    ParameterTableEditorItem item = (ParameterTableEditorItem)table.getItem(row).getData();
                    Color bColor = colorProvider.getBackground((Object)item, column);
                    if (bColor == null) {
                        return this.white;
                    }
                    return bColor.getRGB();
                }
            });
        }
        TextStyle defaultTextStyle = new TextStyle();
        TextStyle headerStyle = defaultTextStyle.font(systemFontData.getName(), systemFontData.getHeight(), 1);
        defaultTextStyle = defaultTextStyle.font(systemFontData.getName(), systemFontData.getHeight(), 0);
        look.setCellBorder((Border)new LineBorder(new RGB(0, 0, 0)));
        tabelle.setLook((GridLook)look);
        TableColumn[] tableColumnArray = table.getColumns();
        int n = tableColumnArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableColumn column = tableColumnArray[n2];
            GridColumn gridColumn = new GridColumn(16384, -1, 1);
            tabelle.addColumn(gridColumn);
            tabelle.addHeader((Print)headerStyle.create(column.getText()));
            ++n2;
        }
        tableColumnArray = table.getItems();
        n = tableColumnArray.length;
        n2 = 0;
        while (n2 < n) {
            TableColumn item = tableColumnArray[n2];
            int colIdx = 0;
            while (colIdx < table.getColumns().length) {
                TextStyle tStyle = defaultTextStyle.foreground(item.getForeground(colIdx).getRGB());
                Image image = item.getImage(colIdx);
                TextPrint tPrint = tStyle.create(item.getText(colIdx));
                if (image != null) {
                    GridPrint combinedGrid = new GridPrint();
                    combinedGrid.addColumn(new GridColumn(16384, -1, 0));
                    combinedGrid.addColumn(new GridColumn(16384, -1, 0));
                    combinedGrid.add(16384, 0x1000000, (Print)new ImagePrint(image.getImageData()));
                    combinedGrid.add(16384, 0x1000000, (Print)tPrint);
                    tabelle.add((Print)combinedGrid);
                } else {
                    tabelle.add(16384, 0x1000000, (Print)tPrint);
                }
                ++colIdx;
            }
            ++n2;
        }
        grid.add((Print)tabelle);
        return new PagePrint((Print)new BigPrint((Print)grid));
    }

    public String getTitel() {
        return null;
    }
}

