/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.buv.plugin.param.editors.table;

import de.bsvrz.buv.plugin.param.editors.ParameterEditor;
import de.bsvrz.buv.plugin.param.editors.ParameterEditorInput;
import de.bsvrz.buv.plugin.param.editors.ParameterEditorSaveMode;
import de.bsvrz.buv.plugin.param.editors.ParameterSaveResultEnum;
import de.bsvrz.buv.plugin.param.editors.ParameterSaver;
import de.bsvrz.buv.plugin.param.editors.table.TableParamEditorFormPage;
import de.bsvrz.buv.plugin.param.editors.table.TableParamEditorPlugin;
import de.bsvrz.buv.plugin.param.editors.table.provider.ParameterTableEditorItem;
import de.bsvrz.puk.param.lib.Parameter;
import de.bsvrz.puk.param.lib.ParameterClientException;
import de.bsvrz.puk.param.lib.daten.DataWithTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.ui.forms.AbstractFormPart;
import org.eclipse.ui.forms.editor.IFormPage;

public class TableParamEditorFormPart
extends AbstractFormPart {
    private final List<ParameterTableEditorItem> tableItems = new ArrayList<ParameterTableEditorItem>();
    private final boolean readOnly;
    private final TableViewer viewer;

    public TableParamEditorFormPart(boolean readOnly, TableViewer viewer) {
        this.readOnly = readOnly;
        this.viewer = viewer;
    }

    public void commit(boolean onSave) {
        if (!onSave) {
            return;
        }
        if (this.readOnly) {
            super.commit(onSave);
            return;
        }
        TableParamEditorFormPage page = (TableParamEditorFormPage)this.getManagedForm().getContainer();
        ParameterEditorSaveMode saveMode = page.getParameterEditorInput().getSaveMode();
        Parameter[] editedParameters = null;
        switch (saveMode) {
            case ALL: {
                editedParameters = new Parameter[this.tableItems.size()];
                int parameterLoop = 0;
                parameterLoop = 0;
                while (parameterLoop < this.tableItems.size()) {
                    ParameterTableEditorItem item = this.tableItems.get(parameterLoop);
                    editedParameters[parameterLoop] = new Parameter(this.tableItems.get(parameterLoop).getParameter().getInfo(), new DataWithTime(item.createData(), System.currentTimeMillis()));
                    ++parameterLoop;
                }
                break;
            }
            case ONLY_MODIFIED: {
                ArrayList<Parameter> parameterToSave = new ArrayList<Parameter>(this.tableItems.size());
                int parameterLoop = 0;
                while (parameterLoop < this.tableItems.size()) {
                    ParameterTableEditorItem item = this.tableItems.get(parameterLoop);
                    if (item.isDirty()) {
                        parameterToSave.add(new Parameter(this.tableItems.get(parameterLoop).getParameter().getInfo(), new DataWithTime(item.createData(), System.currentTimeMillis())));
                    }
                    ++parameterLoop;
                }
                editedParameters = parameterToSave.toArray(new Parameter[parameterToSave.size()]);
                break;
            }
        }
        Assert.isNotNull((Object)editedParameters, (String)("Die zu speichernden Parameter konnten nicht bestimmt werden.\nVerwendeter Save Mode: " + saveMode));
        ParameterSaveResultEnum saveResult = ParameterSaver.saveParameters((Parameter[])editedParameters, (String)ParameterSaver.buildDefaultUrsache((Parameter[])editedParameters, (Parameter[])editedParameters, (ParameterSaver.ParameterSaveUrsache)ParameterSaver.ParameterSaveUrsache.PARAMETRIERT));
        switch (saveResult) {
            case PARAMETER_SAVE_FAILURE: {
                throw new IllegalStateException(ParameterSaver.getLastError());
            }
            case PARAMETER_SAVE_CANCEL: {
                break;
            }
            case PARAMETER_SAVE_SUCCESS: {
                super.commit(onSave);
                this.getManagedForm().dirtyStateChanged();
                for (ParameterTableEditorItem item : this.tableItems) {
                    item.setDirty(false);
                }
                this.refreshViewer();
                break;
            }
        }
    }

    public void markStale() {
        ParameterEditorInput editorInput;
        if (!this.readOnly) {
            return;
        }
        IFormPage formPage = (IFormPage)this.getManagedForm().getContainer();
        if (1 == formPage.getIndex()) {
            editorInput = (ParameterEditorInput)formPage.getEditorInput();
            try {
                editorInput.sollParameterAbfragen();
                super.markStale();
                Parameter[] neueSollParameter = editorInput.getSollParameters();
                this.viewer.setInput((Object)((TableParamEditorFormPage)formPage).createTableItems(neueSollParameter));
                this.viewer.refresh();
            }
            catch (ParameterClientException e) {
                TableParamEditorPlugin.getDefault().getLogger().error("Fehler bei Aktualisierung der Soll-Parameter", (Throwable)e);
            }
        }
        if (3 == formPage.getIndex()) {
            editorInput = (ParameterEditorInput)formPage.getEditorInput();
            editorInput.istParameterAbfragen();
            super.markStale();
            Parameter[] neueIstParameter = editorInput.getIstParameters();
            this.viewer.setInput((Object)((TableParamEditorFormPage)formPage).createTableItems(neueIstParameter));
            this.viewer.refresh();
        }
    }

    public void markDirty() {
        if (this.readOnly) {
            return;
        }
        IFormPage formPage = (IFormPage)this.getManagedForm().getContainer();
        ParameterEditorInput editorInput = (ParameterEditorInput)formPage.getEditorInput();
        for (Integer index : editorInput.getSelectedParameters()) {
            ParameterTableEditorItem tableItem = this.tableItems.get(index);
            if (tableItem == null) continue;
            tableItem.setDirty(true);
            this.viewer.refresh((Object)tableItem);
        }
        super.markDirty();
    }

    public void refresh() {
        int innerLoop;
        ParameterTableEditorItem[] neueTableItems;
        TableParamEditorFormPage formPage = (TableParamEditorFormPage)this.getManagedForm().getContainer();
        ParameterEditorInput pei = (ParameterEditorInput)formPage.getEditorInput();
        Parameter[] parameters = null;
        switch (formPage.getIndex()) {
            case 0: {
                parameters = pei.getParameters();
                break;
            }
            case 1: {
                parameters = pei.getSollParameters();
                break;
            }
            case 2: {
                parameters = pei.getDefaultParameters();
                break;
            }
            case 3: {
                parameters = pei.getIstParameters();
                break;
            }
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Index " + formPage.getIndex() + " wird nicht unterst\u00fctzt.\n" + "G\u00fcltige Indices sind von 0 bis 3," + " entsprechend den Aspekten " + Arrays.toString(ParameterEditor.VALID_INDICES));
        }
        if (this.tableItems.isEmpty()) {
            neueTableItems = formPage.createTableItems(parameters);
        } else {
            neueTableItems = new ParameterTableEditorItem[this.tableItems.size()];
            int loop = 0;
            while (loop < this.tableItems.size()) {
                neueTableItems[loop] = pei.getSelectedParameters().contains(loop) || this.readOnly ? new ParameterTableEditorItem(parameters[loop], false, false) : this.tableItems.get(loop).createModifiableCopy();
                innerLoop = 0;
                while (innerLoop < loop) {
                    neueTableItems[loop].catchUpByData(neueTableItems[innerLoop]);
                    ++innerLoop;
                }
                ++loop;
            }
            loop = 0;
            while (loop < neueTableItems.length) {
                neueTableItems[loop].run();
                ++loop;
            }
            this.tableItems.clear();
        }
        ParameterTableEditorItem[] parameterTableEditorItemArray = neueTableItems;
        int n = neueTableItems.length;
        innerLoop = 0;
        while (innerLoop < n) {
            ParameterTableEditorItem item = parameterTableEditorItemArray[innerLoop];
            this.tableItems.add(item);
            ++innerLoop;
        }
        formPage.fillTable(neueTableItems);
        formPage.updateDatenSectionDescription(neueTableItems);
        boolean globalDirtyState = false;
        int loop = 0;
        while (loop < this.tableItems.size()) {
            if (this.tableItems.get(loop).isDirty()) {
                globalDirtyState = true;
                break;
            }
            ++loop;
        }
        if (this.getManagedForm().isDirty() != globalDirtyState) {
            super.refresh();
            this.getManagedForm().dirtyStateChanged();
        }
    }

    private void refreshViewer() {
        if (!this.viewer.getControl().getDisplay().isDisposed()) {
            this.viewer.getControl().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (!TableParamEditorFormPart.this.viewer.getControl().isDisposed()) {
                        TableParamEditorFormPart.this.viewer.refresh();
                    }
                }
            });
        }
    }
}

