/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.buv.plugin.param.editors.table.actions;

import de.bsvrz.buv.plugin.param.editors.table.edit.IParamTableEditorModifyListener;
import de.bsvrz.buv.plugin.param.editors.table.provider.ArrayNameAndIndex;
import de.bsvrz.buv.plugin.param.editors.table.provider.ParameterTableEditorItem;
import de.bsvrz.buv.plugin.param.editors.table.provider.PlainDataValue;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.custom.TableCursor;
import org.eclipse.swt.widgets.Table;

public abstract class TableParamEditorAction
extends Action {
    private final TableViewer tableViewer;
    private PlainDataValue editedValue;
    private ArrayNameAndIndex ari;
    private ParameterTableEditorItem editedItem;
    private int editedIndex;
    private final IParamTableEditorModifyListener modifyListener;

    public TableParamEditorAction(String text, TableViewer tableViewer, IParamTableEditorModifyListener modifyListener) {
        super(text);
        this.tableViewer = tableViewer;
        this.modifyListener = modifyListener;
    }

    public PlainDataValue getEditedValue() {
        return this.editedValue;
    }

    public void setEditedValue(ParameterTableEditorItem editedRow, int editedIdx) {
        this.editedItem = editedRow;
        this.editedIndex = editedIdx;
        this.editedValue = editedRow.getPlainDataValues().get(editedIdx);
        if (this.editedValue == null) {
            this.setEnabled(false);
            return;
        }
        this.ari = ParameterTableEditorItem.getArrayIndexFromPath(this.editedValue.getPath());
    }

    protected void refreshEditedItem() {
        Table table = this.tableViewer.getTable();
        TableCursor cursor = (TableCursor)table.getData("CURSOR");
        this.tableViewer.refresh(cursor.getRow().getData());
    }

    public TableViewer getTableViewer() {
        return this.tableViewer;
    }

    public IParamTableEditorModifyListener getModifyListener() {
        return this.modifyListener;
    }

    protected ParameterTableEditorItem getEditedItem() {
        return this.editedItem;
    }

    protected final int getEditedIndex() {
        return this.editedIndex;
    }

    protected final ArrayNameAndIndex getAri() {
        return this.ari;
    }
}

