/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.buv.plugin.param.editors.table.edit;

import com.bitctrl.lib.eclipse.wizards.ComposedWizardDialog;
import de.bsvrz.buv.plugin.param.editors.attribut.DoubleAttributDialog;
import de.bsvrz.buv.plugin.param.editors.attribut.IntegerAttributDialog;
import de.bsvrz.buv.plugin.param.editors.attribut.MultiLineInputDialog;
import de.bsvrz.buv.plugin.param.editors.attribut.StringLengthInputValidator;
import de.bsvrz.buv.plugin.param.editors.table.edit.IParamTableEditorModifyListener;
import de.bsvrz.buv.plugin.param.editors.table.internal.RahmenwerkService;
import de.bsvrz.buv.plugin.param.editors.table.provider.ArrayInTableInfo;
import de.bsvrz.buv.plugin.param.editors.table.provider.ArrayNameAndIndex;
import de.bsvrz.buv.plugin.param.editors.table.provider.ParameterTableEditorItem;
import de.bsvrz.buv.plugin.param.editors.table.provider.PlainDataValue;
import de.bsvrz.buv.rw.bitctrl.eclipse.MultipleSelection;
import de.bsvrz.buv.rw.bitctrl.eclipse.SystemObjectAuswahlType;
import de.bsvrz.buv.rw.bitctrl.eclipse.wizards.DatumZeitDialog;
import de.bsvrz.buv.rw.bitctrl.eclipse.wizards.SystemObjectAuswahlWizardPage;
import de.bsvrz.buv.rw.bitctrl.eclipse.wizards.ZeitDauerDialog;
import de.bsvrz.dav.daf.main.ClientDavInterface;
import de.bsvrz.dav.daf.main.config.AttributeSet;
import de.bsvrz.dav.daf.main.config.AttributeType;
import de.bsvrz.dav.daf.main.config.DoubleAttributeType;
import de.bsvrz.dav.daf.main.config.IntegerAttributeType;
import de.bsvrz.dav.daf.main.config.ReferenceAttributeType;
import de.bsvrz.dav.daf.main.config.StringAttributeType;
import de.bsvrz.dav.daf.main.config.SystemObject;
import de.bsvrz.dav.daf.main.config.SystemObjectType;
import de.bsvrz.dav.daf.main.config.TimeAttributeType;
import de.bsvrz.sys.funclib.debug.Debug;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.custom.TableCursor;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public class TableParamEditorDoubleClickListener
implements IDoubleClickListener,
MouseListener {
    private static final Debug DEBUG = Debug.getLogger();
    private final IParamTableEditorModifyListener modifyListener;

    public TableParamEditorDoubleClickListener(IParamTableEditorModifyListener modifyListener) {
        this.modifyListener = modifyListener;
    }

    private Object[] openTimeDialog(PlainDataValue editedValue) {
        Object[] values = new Object[]{editedValue.getPid(), null};
        Long oldValue = Long.parseLong(editedValue.getPid());
        long newValue = oldValue;
        TimeAttributeType attrType = (TimeAttributeType)editedValue.getAttributeType();
        Object azad = attrType.isRelative() ? new ZeitDauerDialog(null, oldValue.longValue()) : new DatumZeitDialog(null, oldValue.longValue());
        if (azad.open() == 0) {
            newValue = azad.getSelectedValue();
        }
        if (newValue != oldValue) {
            String pid = String.valueOf(newValue);
            editedValue.setPid(pid);
            values[1] = pid;
        }
        return values;
    }

    private Object[] openIntegerDialog(PlainDataValue editedValue) {
        Object[] values = new Object[]{editedValue.getPid(), null};
        Long initialWert = Long.valueOf(editedValue.getPid());
        IntegerAttributDialog iad = new IntegerAttributDialog(null, (IntegerAttributeType)editedValue.getAttributeType(), initialWert);
        if (iad.open() == 0) {
            String pid = String.valueOf(iad.getWert());
            editedValue.setPid(pid);
            values[1] = pid;
        }
        return values;
    }

    private Object[] openDoubleDialog(PlainDataValue editedValue) {
        Object[] values = new Object[]{editedValue.getPid(), null};
        Double initialWert = Double.valueOf(editedValue.getPid());
        DoubleAttributDialog dad = new DoubleAttributDialog(null, (DoubleAttributeType)editedValue.getAttributeType(), initialWert);
        if (dad.open() == 0) {
            String pid = String.valueOf(dad.getWert());
            editedValue.setPid(pid);
            values[1] = pid;
        }
        return values;
    }

    private Object[] openReferenceDialog(PlainDataValue editedValue) {
        SystemObjectAuswahlType auswahlType;
        Object[] values = new Object[]{editedValue.getPid(), null};
        ClientDavInterface davIf = RahmenwerkService.getService().getObjektFactory().getDav();
        SystemObject oldValue = davIf.getDataModel().getObject(editedValue.getPid());
        boolean neu = oldValue == null;
        ReferenceAttributeType referenceAttrType = (ReferenceAttributeType)editedValue.getAttributeType();
        SystemObjectType referencedType = referenceAttrType.getReferencedObjectType();
        if (referencedType == null) {
            referencedType = davIf.getDataModel().getType("typ.typ");
            auswahlType = SystemObjectAuswahlType.TypesOrInstances;
        } else {
            List elements = referencedType.getElements();
            if (elements == null || elements.isEmpty()) {
                auswahlType = SystemObjectAuswahlType.TypesOrInstances;
            } else {
                int numInstances = 0;
                int numTypes = 0;
                for (SystemObject o : elements) {
                    if (o instanceof SystemObjectType) {
                        ++numTypes;
                        continue;
                    }
                    ++numInstances;
                }
                auswahlType = numTypes == 0 ? SystemObjectAuswahlType.OnlyInstances : (numInstances == 0 ? SystemObjectAuswahlType.OnlyTypes : SystemObjectAuswahlType.TypesOrInstances);
            }
        }
        String systemObjektPid = referencedType.getPid();
        String descLongAnfang = "W\u00e4hlen Sie das gew\u00fcnschte Objekt ";
        String descLongEnde = " aus.";
        String aktionString = neu ? " zuweisen" : " modifizieren";
        SystemObjectAuswahlWizardPage auswahlPage = new SystemObjectAuswahlWizardPage(String.valueOf(referencedType.toString()) + aktionString, MultipleSelection.Single, auswahlType, neu ? new ArrayList() : Arrays.asList(oldValue), new String[]{systemObjektPid});
        auswahlPage.setDescription("W\u00e4hlen Sie das gew\u00fcnschte Objekt " + referencedType.toString() + " aus.");
        ComposedWizardDialog wizardDialog = new ComposedWizardDialog(String.valueOf(referencedType.toString()) + aktionString, new IWizardPage[]{auswahlPage});
        if (wizardDialog.open() == 0 && !auswahlPage.getAuswahl().isEmpty()) {
            SystemObject newValue = (SystemObject)auswahlPage.getAuswahl().get(0);
            if (newValue == null) {
                throw new IllegalStateException("Fehler: Referenz-Object konnte nicht identifiziert werden.");
            }
            editedValue.setPid(newValue.getPid());
            values[1] = newValue.getPid();
        }
        return values;
    }

    private Object[] openTextDialog(PlainDataValue editedValue) {
        Object[] values = new Object[2];
        values[1] = null;
        String oldTextValue = editedValue.getValue();
        values[0] = oldTextValue;
        StringAttributeType strAttr = (StringAttributeType)editedValue.getAttributeType();
        MultiLineInputDialog id = new MultiLineInputDialog(null, "Text bearbeiten", "Bitte bearbeiten Sie den Text. Erlaubt sind maximal " + strAttr.getMaxLength() + " Zeichen.", oldTextValue, (IInputValidator)new StringLengthInputValidator(strAttr.getMaxLength()));
        if (id.open() == 0) {
            values[1] = id.getValue();
            editedValue.setPid(id.getValue());
        }
        return values;
    }

    private String openDialog(ParameterTableEditorItem item, int index) {
        List<PlainDataValue> plainDataValues = item.getPlainDataValues();
        if (index < 0 || index >= plainDataValues.size()) {
            return null;
        }
        Object oldValue = null;
        Object newValue = null;
        PlainDataValue editedValue = plainDataValues.get(index);
        AttributeType attributeType = editedValue.getAttributeType();
        if (attributeType instanceof StringAttributeType) {
            Object[] values = this.openTextDialog(editedValue);
            oldValue = values[0];
            newValue = values[1];
        } else if (attributeType instanceof IntegerAttributeType) {
            Object[] values = this.openIntegerDialog(editedValue);
            oldValue = values[0];
            newValue = values[1];
        } else if (attributeType instanceof TimeAttributeType) {
            Object[] values = this.openTimeDialog(editedValue);
            oldValue = values[0];
            newValue = values[1];
        } else if (attributeType instanceof ReferenceAttributeType) {
            Object[] values = this.openReferenceDialog(editedValue);
            oldValue = values[0];
            newValue = values[1];
        } else if (attributeType instanceof DoubleAttributeType) {
            Object[] values = this.openDoubleDialog(editedValue);
            oldValue = values[0];
            newValue = values[1];
        }
        if (oldValue != null && newValue != null && !oldValue.equals(newValue)) {
            item.setDirty(true);
            if (this.modifyListener != null) {
                this.modifyListener.valueModified(item, index, oldValue, newValue, attributeType);
            }
        }
        return editedValue.getPath();
    }

    private void handleDoubleClick(TableCursor cursor) {
        int index = cursor.getColumn() - 1;
        if (index < 0) {
            return;
        }
        ParameterTableEditorItem item = (ParameterTableEditorItem)cursor.getRow().getData();
        PlainDataValue editedValue = item.getPlainDataValues().get(index);
        boolean canEdit = editedValue.isValid();
        if (!canEdit) {
            int firstUndefinedIndex = item.getFirstUndefinedIndexOfArray(index);
            ArrayNameAndIndex ari = ParameterTableEditorItem.getArrayIndexFromPath(editedValue.getPath());
            if (ari.getIndex() == firstUndefinedIndex) {
                if (-2 == firstUndefinedIndex) {
                    AttributeSet parentAttributeSet = editedValue.getParentAttributeSet();
                    if (parentAttributeSet == null) {
                        canEdit = true;
                    } else {
                        ArrayInTableInfo aiti;
                        boolean bl = canEdit = parentAttributeSet.getAttributes().size() == 1;
                        if (!canEdit && (aiti = new ArrayInTableInfo(item, index, true)).getNumMembers() > 0) {
                            canEdit = true;
                        }
                    }
                } else {
                    canEdit = true;
                }
            }
        }
        if (!canEdit) {
            return;
        }
        DEBUG.finer("\u00d6ffne Dialog f\u00fcr item " + item + ", Effektive Spalte " + index);
        Table table = (Table)cursor.getData("TABLE");
        TableColumn column = table.getColumn(cursor.getColumn());
        String newPath = this.openDialog(item, index);
        if (newPath != null && !newPath.equals(column.getText())) {
            column.setText(newPath);
        }
    }

    public void doubleClick(DoubleClickEvent event) {
        IStructuredSelection selection = (IStructuredSelection)event.getSelection();
        if (selection != null && !selection.isEmpty()) {
            Object selected = selection.getFirstElement();
            if (event.getViewer() instanceof TableViewer) {
                Table table = ((TableViewer)event.getViewer()).getTable();
                TableCursor cursor = (TableCursor)table.getData("CURSOR");
                if (selected instanceof ParameterTableEditorItem) {
                    this.handleDoubleClick(cursor);
                }
            }
        }
    }

    public void mouseDoubleClick(MouseEvent e) {
    }

    public void mouseDown(MouseEvent e) {
        DEBUG.finest("mouse down: " + e);
        TableCursor cursor = (TableCursor)e.widget;
        if (1 == e.button) {
            this.handleDoubleClick(cursor);
        } else if (3 == e.button) {
            int effCol = cursor.getColumn() - 1;
            ParameterTableEditorItem item = (ParameterTableEditorItem)cursor.getRow().getData();
            if (effCol >= 0 && effCol < item.getPlainDataValues().size()) {
                PlainDataValue editedValue = item.getPlainDataValues().get(effCol);
                if (this.modifyListener != null) {
                    this.modifyListener.showContextMenu(editedValue, item, effCol);
                }
            }
        }
    }

    public void mouseUp(MouseEvent e) {
    }
}

