/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.buv.plugin.param.editors.table.provider;

import de.bsvrz.buv.plugin.param.editors.table.provider.ArrayNameAndIndex;
import de.bsvrz.buv.plugin.param.editors.table.provider.ParameterTableEditorItem;
import de.bsvrz.buv.plugin.param.editors.table.provider.PlainDataValue;
import java.util.List;

public class ArrayInTableInfo {
    private int firstElementIndex = -1;
    private int lastElementIndex = -1;
    private int numMembers = -1;

    public ArrayInTableInfo(ParameterTableEditorItem item, int index, boolean ignoreEmptyArray) {
        List<PlainDataValue> plainDataValues = item.getPlainDataValues();
        ArrayNameAndIndex ari = ParameterTableEditorItem.getArrayIndexFromPath(plainDataValues.get(index).getPath());
        if (ari.getIndex() >= 0 || ignoreEmptyArray) {
            String relevantArrayName = ari.getArrayName();
            int loop = 0;
            while (loop < plainDataValues.size()) {
                if (plainDataValues.get(loop).getPath().startsWith(relevantArrayName)) {
                    if (-1 == this.firstElementIndex) {
                        this.firstElementIndex = loop;
                    }
                    this.lastElementIndex = loop;
                } else if (-1 != this.firstElementIndex) break;
                ++loop;
            }
            PlainDataValue lastValue = plainDataValues.get(this.lastElementIndex);
            for (ArrayNameAndIndex lastArn : ParameterTableEditorItem.getAllArrayComponentsFromPath(lastValue.getPath())) {
                if (!lastArn.getArrayName().equals(relevantArrayName)) continue;
                this.numMembers = lastArn.getIndex() + 1;
            }
            if (this.numMembers < 0 && ignoreEmptyArray) {
                PlainDataValue relevantValue = plainDataValues.get(index);
                this.numMembers = relevantValue.getParentAttributeSet() == null ? 1 : (this.lastElementIndex - this.firstElementIndex + 1) / relevantValue.getParentAttributeSet().getAttributes().size();
            }
        } else {
            this.firstElementIndex = ari.getIndex();
            this.lastElementIndex = ari.getIndex();
            this.numMembers = ari.getIndex();
        }
    }

    public int getFirstElementIndex() {
        return this.firstElementIndex;
    }

    public int getLastElementIndex() {
        return this.lastElementIndex;
    }

    public int getNumMembers() {
        return this.numMembers;
    }
}

