/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.buv.plugin.param.editors.table.provider;

import de.bsvrz.buv.plugin.param.ParamSharedImage;
import de.bsvrz.buv.plugin.param.editors.ParameterEditorInput;
import de.bsvrz.buv.plugin.param.editors.table.provider.ParameterTableEditorItem;
import de.bsvrz.buv.plugin.param.editors.table.provider.PlainDataValue;
import java.util.List;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITableColorProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;

public class ParamTableEditorLabelProvider
implements ITableLabelProvider,
ITableColorProvider {
    private final ParameterEditorInput editorInput;
    private final boolean readOnly;

    public ParamTableEditorLabelProvider(ParameterEditorInput editorInput, boolean readOnly) {
        this.editorInput = editorInput;
        this.readOnly = readOnly;
    }

    public Image getColumnImage(Object element, int columnIndex) {
        PlainDataValue plainValue;
        if (!(element instanceof ParameterTableEditorItem)) {
            return null;
        }
        Image image = null;
        int effIdx = columnIndex - 1;
        ParameterTableEditorItem item = (ParameterTableEditorItem)element;
        List<PlainDataValue> plainDataValues = item.getPlainDataValues();
        if (effIdx >= 0 && effIdx < plainDataValues.size() && !(plainValue = plainDataValues.get(effIdx)).isDefined() && !plainValue.hasUserValue()) {
            image = ParamSharedImage.ERROR_NULL.getImage();
        }
        return image;
    }

    public String getColumnText(Object element, int columnIndex) {
        String text = "unbekannt";
        if (!(element instanceof ParameterTableEditorItem)) {
            return text;
        }
        ParameterTableEditorItem item = (ParameterTableEditorItem)element;
        if (columnIndex == 0) {
            String objektName = item.getParameter().getObjekt().toString();
            text = item.isDirty() ? "*" + objektName : objektName;
        } else {
            int effIdx = columnIndex - 1;
            List<PlainDataValue> plainDataValues = item.getPlainDataValues();
            if (effIdx < plainDataValues.size()) {
                text = plainDataValues.get(effIdx).getValue();
            }
        }
        return text;
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public void dispose() {
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }

    public Color getBackground(Object element, int columnIndex) {
        if (!(element instanceof ParameterTableEditorItem)) {
            return null;
        }
        Color background = null;
        ParameterTableEditorItem item = (ParameterTableEditorItem)element;
        if (!this.readOnly) {
            List<PlainDataValue> plainDataValues = item.getPlainDataValues();
            int effIdx = columnIndex - 1;
            if (effIdx >= 0 && effIdx < plainDataValues.size()) {
                PlainDataValue plainDataValue = plainDataValues.get(effIdx);
                background = this.editorInput.getVorgabeColor(item.getParameter().getInfo(), plainDataValue.getPath(), plainDataValue.getValueText());
            }
        }
        return background;
    }

    public Color getForeground(Object element, int columnIndex) {
        return null;
    }
}

