/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.buv.plugin.param.editors.table.provider;

import de.bsvrz.buv.plugin.param.editors.table.internal.RahmenwerkService;
import de.bsvrz.buv.plugin.param.editors.table.provider.ArrayInTableInfo;
import de.bsvrz.buv.plugin.param.editors.table.provider.ArrayNameAndIndex;
import de.bsvrz.buv.plugin.param.editors.table.provider.PlainDataValue;
import de.bsvrz.dav.daf.main.Data;
import de.bsvrz.dav.daf.main.config.Attribute;
import de.bsvrz.dav.daf.main.config.AttributeListDefinition;
import de.bsvrz.dav.daf.main.config.AttributeSet;
import de.bsvrz.dav.daf.main.config.AttributeType;
import de.bsvrz.dav.daf.main.config.DoubleAttributeType;
import de.bsvrz.dav.daf.main.config.IntegerAttributeType;
import de.bsvrz.dav.daf.main.config.ReferenceAttributeType;
import de.bsvrz.dav.daf.main.config.StringAttributeType;
import de.bsvrz.dav.daf.main.config.SystemObject;
import de.bsvrz.dav.daf.main.config.TimeAttributeType;
import de.bsvrz.puk.param.lib.Parameter;
import de.bsvrz.puk.param.lib.daten.DataWithTime;
import de.bsvrz.sys.funclib.bitctrl.modell.ObjektFactory;
import de.bsvrz.sys.funclib.debug.Debug;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IAdaptable;

public class ParameterTableEditorItem
implements IAdaptable {
    public static final int NUM_COLUMNS_BEFORE = 1;
    public static final String PATH_SEPERATOR = ".";
    private static final Debug DEBUG = Debug.getLogger();
    private static final boolean DO_DEBUG = false;
    private final List<PlainDataValue> plainDataValues = new ArrayList<PlainDataValue>();
    private final Data workingCopy;
    private final Parameter parameter;
    private final boolean showUrlasserInfos;
    private boolean dirty;

    public ParameterTableEditorItem(Parameter parameter, boolean showUrlasserInfos, boolean runImmediately) {
        this.parameter = parameter;
        Assert.isNotNull((Object)parameter);
        Assert.isTrue((boolean)RahmenwerkService.getService().getObjektFactory().isVerbunden(), (String)"Keine Verbindung zum Datenverteiler");
        this.workingCopy = parameter.getData() == null ? RahmenwerkService.getService().getObjektFactory().getDav().createData(parameter.getAtg()) : parameter.getData().createModifiableCopy();
        this.showUrlasserInfos = showUrlasserInfos;
        if (runImmediately) {
            this.run();
        }
    }

    private int bestimmePfadUndIndex(AttributeSet parentData, Data data, String path, int index) {
        int idx = index;
        String nextBasePath = path.length() > 0 ? String.valueOf(path) + PATH_SEPERATOR + data.getName() : data.getName();
        if (data.isList()) {
            Iterator listIter = data.iterator();
            while (listIter.hasNext()) {
                idx = this.bestimmePfadUndIndex((AttributeSet)data.getAttributeType(), (Data)listIter.next(), nextBasePath, idx);
            }
        } else if (data.isArray()) {
            AttributeType a;
            AttributeSet parentAttributeSet = null;
            AttributeType relevantAttributeType = a = data.getAttributeType();
            if (a instanceof AttributeSet) {
                parentAttributeSet = (AttributeSet)a;
                relevantAttributeType = ((Attribute)parentAttributeSet.getAttributes().get(0)).getAttributeType();
            }
            if (data.asArray().getLength() <= 0) {
                PlainDataValue arrayKopf = new PlainDataValue(null, String.valueOf(nextBasePath) + PATH_SEPERATOR + "Leer");
                this.plainDataValues.add(idx, arrayKopf);
                ++idx;
                arrayKopf.setAttributeType(relevantAttributeType);
                arrayKopf.setParentAttributeSet(parentAttributeSet);
                arrayKopf.setAttributeName(data.getName());
                if (parentAttributeSet != null) {
                    for (Attribute attribut : parentAttributeSet.getAttributes()) {
                        arrayKopf.addFeldAttribut(attribut);
                    }
                }
            } else {
                int itemLoop = 0;
                while (itemLoop < data.asArray().getLength()) {
                    idx = this.bestimmePfadUndIndex(parentAttributeSet, data.asArray().getItem(itemLoop), nextBasePath, idx);
                    ++itemLoop;
                }
            }
        } else if (data.isPlain()) {
            PlainDataValue element = new PlainDataValue(data, nextBasePath);
            element.setParentAttributeSet(parentData);
            this.plainDataValues.add(idx, element);
            ++idx;
        }
        return idx;
    }

    public void run() {
        this.plainDataValues.clear();
        String path = "";
        Iterator iterator = this.workingCopy.iterator();
        int index = 0;
        while (iterator.hasNext()) {
            Data next = (Data)iterator.next();
            if (!this.showUrlasserInfos && "atl.urlasser".equals(next.getAttributeType().getPid())) continue;
            index = this.bestimmePfadUndIndex((AttributeSet)this.parameter.getAtg(), next, "", index);
        }
    }

    public static ArrayNameAndIndex getArrayIndexFromPath(String path) {
        ArrayNameAndIndex result = new ArrayNameAndIndex();
        result.setArrayName(path);
        result.setRestPfad("");
        String[] components = path.split("\\.");
        if ("Leer".equals(components[components.length - 1])) {
            result.setIndex(-2);
            result.setArrayName("");
            int arrayNameLoop = 0;
            while (arrayNameLoop < components.length - 1) {
                if (arrayNameLoop != 0) {
                    result.setArrayName(String.valueOf(result.getArrayName()) + PATH_SEPERATOR);
                }
                result.setArrayName(String.valueOf(result.getArrayName()) + components[arrayNameLoop]);
                ++arrayNameLoop;
            }
            return result;
        }
        int backLoop = components.length - 1;
        while (backLoop >= 0) {
            boolean isNumber = true;
            if (!"Leer".equals(components[backLoop])) {
                int charLoop = 0;
                while (charLoop < components[backLoop].length()) {
                    if (!Character.isDigit(components[backLoop].charAt(charLoop))) {
                        isNumber = false;
                        break;
                    }
                    ++charLoop;
                }
            }
            if (isNumber) {
                if (!"Leer".equals(components[backLoop])) {
                    result.setIndex(Integer.parseInt(components[backLoop]));
                } else {
                    result.setIndex(-2);
                }
                result.setArrayName("");
                int arrayNameLoop = 0;
                while (arrayNameLoop < backLoop) {
                    if (arrayNameLoop != 0) {
                        result.setArrayName(String.valueOf(result.getArrayName()) + PATH_SEPERATOR);
                    }
                    result.setArrayName(String.valueOf(result.getArrayName()) + components[arrayNameLoop]);
                    ++arrayNameLoop;
                }
                int restNameLoop = backLoop + 1;
                while (restNameLoop < components.length) {
                    if (restNameLoop != backLoop + 1) {
                        result.setRestPfad(String.valueOf(result.getRestPfad()) + PATH_SEPERATOR);
                    }
                    result.setRestPfad(String.valueOf(result.getRestPfad()) + components[restNameLoop]);
                    ++restNameLoop;
                }
                break;
            }
            --backLoop;
        }
        return result;
    }

    public static List<ArrayNameAndIndex> getAllArrayComponentsFromPath(String path) {
        int index;
        ArrayList<ArrayNameAndIndex> indices = new ArrayList<ArrayNameAndIndex>();
        String curPath = path;
        do {
            ArrayNameAndIndex ari;
            if (-1 == (index = (ari = ParameterTableEditorItem.getArrayIndexFromPath(curPath)).getIndex())) continue;
            indices.add(ari);
            curPath = ari.getArrayName();
        } while (index != -1);
        return indices;
    }

    public ParameterTableEditorItem createModifiableCopy() {
        Parameter p = new Parameter(this.getParameter().getInfo(), new DataWithTime(this.createData(), System.currentTimeMillis()));
        ParameterTableEditorItem copy = new ParameterTableEditorItem(p, this.showUrlasserInfos, false);
        copy.setDirty(this.isDirty());
        return copy;
    }

    private void doCatchUpByDataRekursiv(AttributeSet attributeSet, Data d1, Data d2) {
        for (Attribute a : attributeSet.getAttributes()) {
            if (!a.isArray()) continue;
            Data.Array array1 = d1.getArray(a.getName());
            Data.Array array2 = d2.getArray(a.getName());
            int len1 = array1.getLength();
            int len2 = array2.getLength();
            int sollLength = Math.max(len1, len2);
            if (len1 != len2) {
                Data.Array shorterArray = len1 > len2 ? array2 : array1;
                shorterArray.setLength(sollLength);
            }
            if (!(a.getAttributeType() instanceof AttributeSet)) continue;
            int loop = 0;
            while (loop < sollLength) {
                AttributeSet attributeSetImArray = (AttributeSet)a.getAttributeType();
                Data d1ImArray = array1.getItem(loop);
                Data d2ImArray = array2.getItem(loop);
                this.doCatchUpByDataRekursiv(attributeSetImArray, d1ImArray, d2ImArray);
                ++loop;
            }
        }
    }

    public void catchUpByData(ParameterTableEditorItem otherSpaltenBestimmer) {
        this.doCatchUpByDataRekursiv((AttributeSet)this.parameter.getAtg(), this.workingCopy, otherSpaltenBestimmer.getWorkingCopy());
    }

    @Deprecated
    public void catchUpBiDirectional(ParameterTableEditorItem otherSpaltenBestimmer) {
        boolean go = true;
        List<PlainDataValue> otherPlainDataValues = otherSpaltenBestimmer.getPlainDataValues();
        int pfadLoop = 0;
        int lastEqualPath = 0;
        while (go) {
            go = false;
            int maxCount = Math.min(this.plainDataValues.size(), otherPlainDataValues.size());
            pfadLoop = lastEqualPath;
            while (pfadLoop < maxCount) {
                String otherPath;
                String path = this.plainDataValues.get(pfadLoop).getPath();
                if (path.equals(otherPath = otherPlainDataValues.get(pfadLoop).getPath())) {
                    lastEqualPath = pfadLoop;
                } else {
                    List<ArrayNameAndIndex> ourArrayComponents = ParameterTableEditorItem.getAllArrayComponentsFromPath(path);
                    List<ArrayNameAndIndex> theirArrayComponents = ParameterTableEditorItem.getAllArrayComponentsFromPath(otherPath);
                    ArrayNameAndIndex ourArrayNameAndIndex = ourArrayComponents.get(0);
                    int index = ourArrayNameAndIndex.getIndex();
                    ArrayNameAndIndex theirArrayNameAndIndex = theirArrayComponents.get(0);
                    int otherIndex = theirArrayNameAndIndex.getIndex();
                    if (ourArrayNameAndIndex.getArrayName().equals(theirArrayNameAndIndex.getArrayName())) {
                        if (-1 == index && -1 == otherIndex) {
                            DEBUG.finer("###########################");
                        } else {
                            PlainDataValue filler;
                            if (-2 == index && otherIndex >= 0) {
                                this.fillEmptyArrayFirstElement(pfadLoop, path, this.plainDataValues, otherPlainDataValues);
                                go = true;
                                break;
                            }
                            if (index >= 0 && -2 == otherIndex) {
                                this.fillEmptyArrayFirstElement(pfadLoop, otherPath, otherPlainDataValues, this.plainDataValues);
                                go = true;
                                break;
                            }
                            if (index > otherIndex && otherIndex != -1) {
                                filler = new PlainDataValue(null, path);
                                otherPlainDataValues.add(pfadLoop, filler);
                                go = true;
                                break;
                            }
                            if (otherIndex > index && index != -1) {
                                filler = new PlainDataValue(null, otherPath);
                                this.plainDataValues.add(pfadLoop, filler);
                                go = true;
                                break;
                            }
                            DEBUG.finer(">>>>>>>>>>>>>>>>>>>>>>>>>");
                        }
                    } else {
                        this.handleUngleicheFelder(pfadLoop, ourArrayNameAndIndex, theirArrayNameAndIndex, otherPlainDataValues);
                        go = true;
                        break;
                    }
                }
                ++pfadLoop;
            }
            if (!go && pfadLoop >= maxCount && this.plainDataValues.size() != otherPlainDataValues.size()) {
                go = this.handleFinalPadding(otherPlainDataValues);
            }
            if (!go) continue;
            DEBUG.finest("Zwischenstand:\nWir:" + this + "\n\nDie: " + otherSpaltenBestimmer);
        }
        if (this.plainDataValues.size() != otherPlainDataValues.size()) {
            DEBUG.warning("Final Catch-up failure", new Object[]{this.plainDataValues, otherPlainDataValues});
        }
    }

    private boolean handleFinalPadding(List<PlainDataValue> otherPlainDataValues) {
        List<PlainDataValue> biggerList;
        List<PlainDataValue> smallerList;
        if (this.plainDataValues.size() < otherPlainDataValues.size()) {
            smallerList = this.plainDataValues;
            biggerList = otherPlainDataValues;
        } else {
            smallerList = otherPlainDataValues;
            biggerList = this.plainDataValues;
        }
        ArrayList<PlainDataValue> paddedValues = new ArrayList<PlainDataValue>();
        PlainDataValue lastCommonValue = smallerList.get(smallerList.size() - 1);
        ArrayNameAndIndex lastCommonAri = ParameterTableEditorItem.getArrayIndexFromPath(lastCommonValue.getPath());
        PlainDataValue firstRestValue = biggerList.get(smallerList.size());
        ArrayNameAndIndex firstRestAri = ParameterTableEditorItem.getArrayIndexFromPath(firstRestValue.getPath());
        if (!lastCommonAri.getArrayName().equals(firstRestAri.getArrayName())) {
            return false;
        }
        if (lastCommonValue.getParentAttributeSet() == null) {
            int restLoop = smallerList.size();
            while (restLoop < biggerList.size()) {
                PlainDataValue restValue = biggerList.get(restLoop);
                ArrayNameAndIndex restAri = ParameterTableEditorItem.getArrayIndexFromPath(restValue.getPath());
                if (lastCommonAri.getArrayName().equals(restAri.getArrayName())) {
                    StringBuilder b = new StringBuilder(restAri.getArrayName());
                    b.append(PATH_SEPERATOR);
                    b.append(lastCommonAri.getIndex() + 1 + restLoop - smallerList.size());
                    PlainDataValue padValue = new PlainDataValue(null, b.toString());
                    padValue.setAttributeType(lastCommonValue.getAttributeType());
                    padValue.setParentAttributeSet(lastCommonValue.getParentAttributeSet());
                    paddedValues.add(padValue);
                }
                ++restLoop;
            }
        } else {
            StringBuilder b = new StringBuilder(lastCommonAri.getArrayName());
            b.append(PATH_SEPERATOR);
            b.append(lastCommonAri.getIndex() + 1);
            paddedValues.addAll(ParameterTableEditorItem.createPlainDataValues(b.toString(), lastCommonValue.getParentAttributeSet()));
        }
        smallerList.addAll(paddedValues);
        return this.plainDataValues.size() != otherPlainDataValues.size();
    }

    private void handleUngleicheFelder(int pfadLoop, ArrayNameAndIndex ourArrayNameAndIndex, ArrayNameAndIndex theirArrayNameAndIndex, List<PlainDataValue> otherPlainDataValues) {
        ArrayNameAndIndex targetDetails;
        List<PlainDataValue> plainDataValuesProvidingElements;
        List<PlainDataValue> plainDataValuesMissingElements;
        if (ourArrayNameAndIndex.getIndex() > theirArrayNameAndIndex.getIndex() && theirArrayNameAndIndex.getIndex() >= 0) {
            plainDataValuesMissingElements = otherPlainDataValues;
            plainDataValuesProvidingElements = this.plainDataValues;
            targetDetails = ourArrayNameAndIndex;
        } else if (ourArrayNameAndIndex.getIndex() >= 0 && ourArrayNameAndIndex.getIndex() < theirArrayNameAndIndex.getIndex()) {
            plainDataValuesMissingElements = this.plainDataValues;
            plainDataValuesProvidingElements = otherPlainDataValues;
            targetDetails = theirArrayNameAndIndex;
        } else {
            int beiUnsLoop = 0;
            boolean foundByUs = false;
            beiUnsLoop = pfadLoop + 1;
            while (beiUnsLoop < this.plainDataValues.size()) {
                if (this.plainDataValues.get(beiUnsLoop).getPath().startsWith(theirArrayNameAndIndex.getArrayName())) {
                    foundByUs = true;
                    break;
                }
                ++beiUnsLoop;
            }
            if (foundByUs) {
                plainDataValuesMissingElements = otherPlainDataValues;
                plainDataValuesProvidingElements = this.plainDataValues;
                targetDetails = ourArrayNameAndIndex;
            } else {
                plainDataValuesMissingElements = this.plainDataValues;
                plainDataValuesProvidingElements = otherPlainDataValues;
                targetDetails = theirArrayNameAndIndex;
            }
        }
        this.fillMissingArrayMember(pfadLoop, plainDataValuesMissingElements, plainDataValuesProvidingElements, targetDetails);
    }

    private void fillMissingArrayMember(int pfadLoop, List<PlainDataValue> plainDataValuesMissingElements, List<PlainDataValue> plainDataValuesProvidingElements, ArrayNameAndIndex targetDetails) {
        ArrayList<PlainDataValue> newValues = new ArrayList<PlainDataValue>();
        int providingLoop = pfadLoop;
        while (providingLoop < plainDataValuesProvidingElements.size()) {
            PlainDataValue providingValue = plainDataValuesProvidingElements.get(providingLoop);
            if (!providingValue.getPath().startsWith(targetDetails.getArrayName())) break;
            PlainDataValue newValue = new PlainDataValue(null, providingValue.getPath());
            newValue.setAttributeType(providingValue.getAttributeType());
            newValue.setParentAttributeSet(providingValue.getParentAttributeSet());
            newValues.add(newValue);
            ++providingLoop;
        }
        ArrayList<Integer> indicesToBeRemoved = new ArrayList<Integer>();
        ArrayList<PlainDataValue> leerItemsToBeRemoved = new ArrayList<PlainDataValue>();
        int missingLoop = pfadLoop;
        while (missingLoop < plainDataValuesMissingElements.size()) {
            PlainDataValue testValue = plainDataValuesMissingElements.get(missingLoop);
            if (testValue.getPath().endsWith("Leer")) {
                String pathOhneEmpty = testValue.getPath().substring(0, testValue.getPath().length() - "Leer".length() - 1);
                int newValuesLoop = 0;
                while (newValuesLoop < newValues.size()) {
                    PlainDataValue piePiece = (PlainDataValue)newValues.get(newValuesLoop);
                    if (piePiece.getPath().startsWith(pathOhneEmpty) && !indicesToBeRemoved.contains(missingLoop)) {
                        indicesToBeRemoved.add(missingLoop);
                        leerItemsToBeRemoved.add(testValue);
                    }
                    ++newValuesLoop;
                }
            }
            ++missingLoop;
        }
        plainDataValuesMissingElements.removeAll(leerItemsToBeRemoved);
        plainDataValuesMissingElements.addAll(pfadLoop, newValues);
    }

    private void fillEmptyArrayFirstElement(int pfadLoop, String path, List<PlainDataValue> emptyArray, List<PlainDataValue> filledArray) {
        PlainDataValue emptyArrayValue = emptyArray.get(pfadLoop);
        List<Attribute> arrayAttributes = emptyArrayValue.getFeldAttribute();
        int attributLoop = 1;
        while (attributLoop < arrayAttributes.size()) {
            Attribute attribute = arrayAttributes.get(attributLoop);
            String attributName = attribute.getName();
            String neuerPfad = String.valueOf(path.replace("Leer", "0")) + PATH_SEPERATOR + attributName;
            if (attribute.isArray()) {
                neuerPfad = String.valueOf(neuerPfad) + ".Leer";
            }
            AttributeType at = emptyArrayValue.getAttributeType();
            ArrayList<Attribute> geradeEntdeckteArrayAttribute = null;
            if (at instanceof AttributeListDefinition) {
                AttributeListDefinition ald = (AttributeListDefinition)at;
                Attribute attr = ald.getAttribute(attributName);
                if (attr == null) {
                    DEBUG.warning("Oops");
                } else if (attr.isArray()) {
                    geradeEntdeckteArrayAttribute = new ArrayList<Attribute>();
                    for (Attribute arrayAttribut : ald.getAttributes()) {
                        geradeEntdeckteArrayAttribute.add(arrayAttribut);
                    }
                }
            }
            PlainDataValue filler = new PlainDataValue(null, neuerPfad);
            filler.setAttributeType(at);
            if (geradeEntdeckteArrayAttribute != null) {
                for (Attribute geradeEntdecktesAttribut : geradeEntdeckteArrayAttribute) {
                    filler.addFeldAttribut(geradeEntdecktesAttribut);
                }
            }
            emptyArray.add(pfadLoop + attributLoop, filler);
            ++attributLoop;
        }
        PlainDataValue filledPlainDataValue = filledArray.get(pfadLoop);
        emptyArrayValue.setPath(filledPlainDataValue.getPath());
    }

    private void writeDataItemRekursiv(Data data, String restPfad, PlainDataValue value) {
        if (!value.isValid()) {
            return;
        }
        String[] splitPath = restPfad.split("\\.");
        Data item = data.isPlain() ? data : data.getItem(splitPath[0]);
        if (splitPath.length == 1) {
            AttributeType attributeType = value.getAttributeType();
            if (attributeType instanceof StringAttributeType) {
                item.asTextValue().setText(value.getValue());
            } else if (attributeType instanceof IntegerAttributeType) {
                item.asTextValue().setText(value.getValue());
            } else if (attributeType instanceof TimeAttributeType) {
                Long timeValue = Long.valueOf(value.getPid());
                item.asTimeValue().setMillis(timeValue.longValue());
            } else if (attributeType instanceof DoubleAttributeType) {
                item.asTextValue().setText(value.getValue());
            } else if (attributeType instanceof ReferenceAttributeType) {
                item.asTextValue().setText(value.getPid());
            }
            return;
        }
        StringBuilder restPath = new StringBuilder(value.getPath().length());
        int restLoopStart = 1;
        if (item.isArray()) {
            DEBUG.finer("Array-Item", (Object)item.getAttributeType());
            ++restLoopStart;
        }
        int restLoop = restLoopStart;
        while (restLoop < splitPath.length) {
            if (restLoop > restLoopStart) {
                restPath.append(PATH_SEPERATOR);
            }
            restPath.append(splitPath[restLoop]);
            ++restLoop;
        }
        if (item.isList()) {
            this.writeDataItemRekursiv(item, restPath.toString(), value);
        } else if (item.isArray()) {
            if ("Leer".equals(splitPath[1])) {
                item.asArray().setLength(0);
                return;
            }
            Integer idx = Integer.parseInt(splitPath[1]);
            item.asArray().setLength(idx + 1);
            this.writeDataItemRekursiv(item.asArray().getItem(idx.intValue()), restPath.toString(), value);
        }
    }

    public int getFirstUndefinedIndexOfArray(int index) {
        ArrayInTableInfo aiti = new ArrayInTableInfo(this, index, false);
        if (aiti.getFirstElementIndex() < 0) {
            return aiti.getFirstElementIndex();
        }
        ArrayNameAndIndex relevantAri = ParameterTableEditorItem.getArrayIndexFromPath(this.plainDataValues.get(index).getPath());
        String relevantArrayName = relevantAri.getArrayName();
        ArrayList indexedLists = new ArrayList(aiti.getNumMembers());
        int indexLoop = 0;
        while (indexLoop <= aiti.getNumMembers()) {
            indexedLists.add(new ArrayList());
            ++indexLoop;
        }
        int loop = aiti.getFirstElementIndex();
        while (loop <= aiti.getLastElementIndex()) {
            PlainDataValue value = this.plainDataValues.get(loop);
            for (ArrayNameAndIndex arn : ParameterTableEditorItem.getAllArrayComponentsFromPath(value.getPath())) {
                if (!arn.getArrayName().equals(relevantArrayName)) continue;
                int arnidx = arn.getIndex();
                if (arnidx < 0) {
                    DEBUG.warning("Negativer arnidx", (Object)value);
                    arnidx = 0;
                }
                ((List)indexedLists.get(arnidx)).add(value);
            }
            ++loop;
        }
        int result = aiti.getNumMembers();
        indexLoop = 0;
        while (indexLoop < aiti.getNumMembers()) {
            List currentList = (List)indexedLists.get(indexLoop);
            boolean currentListIsValid = true;
            loop = 0;
            while (loop < currentList.size()) {
                PlainDataValue value = (PlainDataValue)currentList.get(loop);
                if (!value.isValid()) {
                    currentListIsValid = false;
                    break;
                }
                ++loop;
            }
            if (!currentListIsValid) {
                result = indexLoop;
                break;
            }
            ++indexLoop;
        }
        return result;
    }

    public Data createData() {
        ObjektFactory f = RahmenwerkService.getService().getObjektFactory();
        Assert.isTrue((boolean)f.isVerbunden(), (String)"Keine Verbindung zum Datenverteiler");
        Data data = f.getDav().createData(this.parameter.getAtg());
        DEBUG.finest("Ich selbst", (Object)this);
        int spalte = 0;
        while (spalte < this.plainDataValues.size()) {
            PlainDataValue value = this.plainDataValues.get(spalte);
            this.writeDataItemRekursiv(data, value.getPath(), value);
            ++spalte;
        }
        return data;
    }

    public List<PlainDataValue> getValuesOfList(ArrayNameAndIndex ari, int startIndex, boolean plain) {
        ArrayList<PlainDataValue> result = new ArrayList<PlainDataValue>(this.plainDataValues.size());
        String searchString = plain ? ari.getArrayName() : String.valueOf(ari.getArrayName()) + PATH_SEPERATOR + ari.getIndex();
        int loop = startIndex;
        while (loop < this.plainDataValues.size()) {
            PlainDataValue candidate = this.plainDataValues.get(loop);
            if (candidate.getPath().startsWith(searchString)) {
                result.add(candidate);
            }
            ++loop;
        }
        return result;
    }

    public static int bestimmePositionInnerhalbFeld(List<PlainDataValue> values, String elementPath) {
        int pos = 0;
        while (pos < values.size()) {
            if (values.get(pos).getPath().equals(elementPath)) break;
            ++pos;
        }
        return pos;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ParameterTableEditorItem) {
            return ((ParameterTableEditorItem)obj).getParameter().getObjekt().equals(this.parameter.getObjekt());
        }
        return super.equals(obj);
    }

    public int hashCode() {
        return this.parameter.getObjekt().hashCode();
    }

    public List<PlainDataValue> getPlainDataValues() {
        return this.plainDataValues;
    }

    public Parameter getParameter() {
        return this.parameter;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void setDirty(boolean dirty) {
        this.dirty = dirty;
    }

    public static List<PlainDataValue> createPlainDataValues(String prefix, AttributeSet attributeSet) {
        ArrayList<PlainDataValue> values = new ArrayList<PlainDataValue>();
        for (Attribute a : attributeSet.getAttributes()) {
            PlainDataValue value;
            AttributeType type = a.getAttributeType();
            int faktor = 1;
            if (a.isArray()) {
                if (!a.isCountVariable()) {
                    faktor = a.getMaxCount();
                } else {
                    value = new PlainDataValue(null, String.valueOf(prefix) + PATH_SEPERATOR + a.getName() + PATH_SEPERATOR + "Leer");
                    if (type instanceof AttributeSet) {
                        value.setParentAttributeSet((AttributeSet)type);
                        value.setAttributeName(a.getName());
                    }
                    value.setAttributeType(type);
                    values.add(value);
                    continue;
                }
            }
            if (type instanceof AttributeSet) {
                int loop = 0;
                while (loop < faktor) {
                    String neuesPrefix = String.valueOf(prefix) + PATH_SEPERATOR + a.getName();
                    if (a.isArray()) {
                        neuesPrefix = String.valueOf(neuesPrefix) + PATH_SEPERATOR + loop;
                    }
                    values.addAll(ParameterTableEditorItem.createPlainDataValues(neuesPrefix, (AttributeSet)type));
                    ++loop;
                }
                continue;
            }
            value = new PlainDataValue(null, String.valueOf(prefix) + PATH_SEPERATOR + a.getName());
            value.setAttributeType(type);
            value.setParentAttributeSet(attributeSet);
            values.add(value);
        }
        return values;
    }

    public String toString() {
        StringBuilder b = new StringBuilder(this.plainDataValues.size() * 50);
        b.append("Objekt: ");
        b.append(this.parameter.getObjekt().toString());
        b.append('\n');
        int loop = 0;
        while (loop < this.plainDataValues.size()) {
            b.append(loop);
            b.append(": ");
            b.append(this.plainDataValues.get(loop).toString());
            b.append('\n');
            ++loop;
        }
        return b.toString();
    }

    Data getWorkingCopy() {
        return this.workingCopy;
    }

    public Object getAdapter(Class adapter) {
        Parameter adapted = null;
        if (Parameter.class.equals((Object)adapter)) {
            adapted = this.parameter;
        } else if (SystemObject.class.equals((Object)adapter)) {
            adapted = this.parameter.getObjekt();
        }
        return adapted;
    }
}

