/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.buv.plugin.param.editors.table.provider;

import com.bitctrl.math.SkalierungHelper;
import de.bsvrz.buv.plugin.param.editors.table.internal.RahmenwerkService;
import de.bsvrz.buv.plugin.param.editors.table.provider.ArrayNameAndIndex;
import de.bsvrz.buv.plugin.param.editors.table.provider.ParameterTableEditorItem;
import de.bsvrz.dav.daf.main.Data;
import de.bsvrz.dav.daf.main.config.Attribute;
import de.bsvrz.dav.daf.main.config.AttributeSet;
import de.bsvrz.dav.daf.main.config.AttributeType;
import de.bsvrz.dav.daf.main.config.IntegerAttributeType;
import de.bsvrz.dav.daf.main.config.IntegerValueState;
import de.bsvrz.dav.daf.main.config.ReferenceAttributeType;
import de.bsvrz.dav.daf.main.config.StringAttributeType;
import de.bsvrz.dav.daf.main.config.SystemObject;
import de.bsvrz.dav.daf.main.config.TimeAttributeType;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.eclipse.core.runtime.Assert;

public class PlainDataValue {
    private static final DateFormat DATE_FORMAT_SEKUNDENGENAU_ABSOLUT = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss");
    private static final DateFormat DATE_FORMAT_MILLISEKUNDENGENAU_ABSOLUT = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss,SSS");
    private DateFormat dateFormat;
    private Data dafData;
    private String userValue;
    private String path;
    private List<Attribute> feldAttribute;
    private AttributeType attributeType;
    private String pid = "0";
    private AttributeSet parentAttributeSet;
    private String attributeName;

    private static String formatRelativeTimeLikeDaV(long timeValue, byte accuracy) {
        long val = timeValue;
        StringBuffer text = new StringBuffer();
        int millis = (int)(val % 1000L);
        int seconds = (int)((val /= 1000L) % 60L);
        int minutes = (int)((val /= 60L) % 60L);
        int hours = (int)((val /= 60L) % 24L);
        long days = val /= 24L;
        if (days != 0L) {
            if (days == 1L) {
                text.append("1 Tag ");
            } else if (days == -1L) {
                text.append("-1 Tag ");
            } else {
                text.append(days).append(" Tage ");
            }
        }
        if (hours != 0) {
            if (hours == 1) {
                text.append("1 Stunde ");
            } else if (hours == -1) {
                text.append("-1 Stunde ");
            } else {
                text.append(hours).append(" Stunden ");
            }
        }
        if (minutes != 0) {
            if (minutes == 1) {
                text.append("1 Minute ");
            } else if (minutes == -1) {
                text.append("-1 Minute ");
            } else {
                text.append(minutes).append(" Minuten ");
            }
        }
        if (seconds != 0 || days == 0L && hours == 0 && minutes == 0 && millis == 0) {
            if (seconds == 1) {
                text.append("1 Sekunde ");
            } else if (seconds == -1) {
                text.append("-1 Sekunde ");
            } else {
                text.append(seconds).append(" Sekunden ");
            }
        }
        if (millis != 0 && accuracy == 1) {
            if (millis == 1) {
                text.append("1 Millisekunde ");
            } else if (millis == -1) {
                text.append("-1 Millisekunde ");
            } else {
                text.append(millis).append(" Millisekunden ");
            }
        }
        text.setLength(text.length() - 1);
        return text.toString();
    }

    public PlainDataValue(Data dafData, String path) {
        this.dafData = dafData;
        this.path = path;
        Assert.isNotNull((Object)path);
        Assert.isTrue((path.length() > 0 ? 1 : 0) != 0);
        if (dafData != null) {
            this.attributeType = dafData.getAttributeType();
            this.attributeName = dafData.getName();
            if (this.attributeType instanceof ReferenceAttributeType) {
                SystemObject referencedSystemObject = dafData.asReferenceValue().getSystemObject();
                this.pid = referencedSystemObject == null ? "0" : referencedSystemObject.getPid();
            } else if (this.attributeType instanceof TimeAttributeType) {
                this.pid = String.valueOf(dafData.asTimeValue().getMillis());
                if (1 == ((TimeAttributeType)this.attributeType).getAccuracy()) {
                    if (!((TimeAttributeType)this.attributeType).isRelative()) {
                        this.dateFormat = DATE_FORMAT_MILLISEKUNDENGENAU_ABSOLUT;
                    }
                } else if (!((TimeAttributeType)this.attributeType).isRelative()) {
                    this.dateFormat = DATE_FORMAT_SEKUNDENGENAU_ABSOLUT;
                }
            } else if (this.attributeType instanceof IntegerAttributeType) {
                this.pid = String.valueOf(dafData.asUnscaledValue().longValue());
            } else if (this.attributeType instanceof StringAttributeType) {
                this.pid = dafData.asTextValue().getValueText();
            }
        } else {
            this.setAttributeNameFromPath();
        }
    }

    public void setAttributeNameFromPath() {
        String[] splitPath = this.path.split("\\.");
        this.attributeName = splitPath[splitPath.length - 1];
    }

    public void addFeldAttribut(Attribute attribute) {
        if (attribute == null) {
            return;
        }
        if (this.feldAttribute == null) {
            this.feldAttribute = new ArrayList<Attribute>();
        }
        if (!this.feldAttribute.contains(attribute)) {
            this.feldAttribute.add(attribute);
        }
    }

    public String getValue() {
        String value = "<Undefiniert>";
        if (this.hasUserValue()) {
            value = this.getUserValue();
        } else if (this.isDefined()) {
            if (this.attributeType instanceof ReferenceAttributeType) {
                SystemObject referencedSystemObject = this.dafData.asReferenceValue().getSystemObject();
                if (referencedSystemObject != null) {
                    value = referencedSystemObject.toString();
                }
            } else {
                value = this.dafData.valueToString();
            }
        }
        return value;
    }

    public boolean isDefined() {
        boolean result = false;
        if (this.dafData != null) {
            String value;
            SystemObject referencedSystemObject;
            result = this.attributeType instanceof ReferenceAttributeType ? (referencedSystemObject = this.dafData.asReferenceValue().getSystemObject()) != null : !"<Undefiniert>".equals(value = this.dafData.valueToString());
        }
        return result;
    }

    public boolean hasUserValue() {
        return this.userValue != null;
    }

    public boolean equals(Object obj) {
        if (obj instanceof PlainDataValue) {
            return this.path.equals(((PlainDataValue)obj).getPath());
        }
        return super.equals(obj);
    }

    public int hashCode() {
        return this.path.hashCode();
    }

    public String toString() {
        String result = String.valueOf(this.path) + ":Nutzerwert=";
        result = this.userValue == null ? String.valueOf(result) + "undefiniert" : String.valueOf(result) + this.userValue;
        result = String.valueOf(result) + ",Datawert=";
        result = this.dafData == null ? String.valueOf(result) + "undefiniert" : String.valueOf(result) + this.dafData.valueToString();
        result = String.valueOf(result) + ", Attributtyp=";
        result = this.attributeType == null ? String.valueOf(result) + "undefiniert" : String.valueOf(result) + this.attributeType.toString();
        result = String.valueOf(result) + ", Attributname=";
        result = String.valueOf(result) + this.attributeName;
        return result;
    }

    public String getPath() {
        return this.path;
    }

    public String getUserValue() {
        return this.userValue;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public AttributeType getAttributeType() {
        return this.attributeType;
    }

    public void setAttributeType(AttributeType attributeType) {
        this.attributeType = attributeType;
    }

    public String getPid() {
        return this.pid;
    }

    public String getValueText() {
        String result = this.pid;
        if (this.attributeType instanceof TimeAttributeType) {
            try {
                long timeValue = Long.parseLong(this.pid);
                result = ((TimeAttributeType)this.attributeType).isRelative() ? PlainDataValue.formatRelativeTimeLikeDaV(timeValue, ((TimeAttributeType)this.attributeType).getAccuracy()) : this.dateFormat.format(new Date(timeValue));
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Die pid " + this.pid + " ist keine G\u00fcltige Zeitangabe", e);
            }
        }
        return result;
    }

    /*
     * Unable to fully structure code
     */
    public void setPid(String pid) {
        if (this.attributeType instanceof ReferenceAttributeType) {
            f = RahmenwerkService.getService().getObjektFactory();
            o = f.getDav().getDataModel().getObject(pid);
            if (o == null) {
                throw new IllegalArgumentException("Die pid " + pid + " referenziert kein SystemObject");
            }
            this.userValue = o.toString();
        } else if (this.attributeType instanceof TimeAttributeType) {
            try {
                timeValue = Long.parseLong(pid);
                if (((TimeAttributeType)this.attributeType).isRelative()) {
                    this.userValue = PlainDataValue.formatRelativeTimeLikeDaV(timeValue, ((TimeAttributeType)this.attributeType).getAccuracy());
                }
                this.userValue = String.valueOf(this.dateFormat.format(new Date(timeValue))) + " Uhr";
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Die pid " + pid + " ist keine G\u00fcltige Zeitangabe", e);
            }
        } else if (this.attributeType instanceof IntegerAttributeType) {
            try {
                longValue = Long.parseLong(pid);
                typ = (IntegerAttributeType)this.attributeType;
                wertGefunden = false;
                if (typ.getStates() != null) {
                    for (IntegerValueState state : typ.getStates()) {
                        if (state.getValue() != longValue) continue;
                        this.userValue = state.getName();
                        wertGefunden = true;
                        break;
                    }
                }
                if (wertGefunden) ** GOTO lbl42
                if (typ.getRange() != null) {
                    this.userValue = 1.0 == typ.getRange().getConversionFactor() ? pid : SkalierungHelper.getInstanz().format((double)longValue, typ.getRange().getConversionFactor()).replace('.', ',');
                    unit = typ.getRange().getUnit();
                    if (unit == null || unit.length() <= 0) ** GOTO lbl42
                    this.userValue = String.valueOf(this.userValue) + " " + unit;
                }
                this.userValue = pid;
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Die pid " + pid + " ist kein g\u00fcltiger Integerwert", e);
            }
        } else if (this.attributeType instanceof StringAttributeType) {
            this.userValue = pid;
        }
lbl42:
        // 10 sources

        this.pid = pid;
        if (this.path.contains("Leer")) {
            arrayName = this.path.replace("Leer", "0");
            if (this.parentAttributeSet != null && this.attributeType != null && !this.path.endsWith(this.attributeName)) {
                arrayName = String.valueOf(arrayName) + ".";
                arrayName = String.valueOf(arrayName) + this.attributeName;
            }
            this.setPath(arrayName);
        }
    }

    public AttributeSet getParentAttributeSet() {
        return this.parentAttributeSet;
    }

    public void setParentAttributeSet(AttributeSet parentAttributeSet) {
        this.parentAttributeSet = parentAttributeSet;
    }

    public boolean isValid() {
        boolean result;
        boolean bl = result = this.isDefined() || this.userValue != null;
        if (!result && this.path.contains("Leer")) {
            result = this.parentAttributeSet == null ? true : this.parentAttributeSet.getAttributes().size() == 1;
        }
        return result;
    }

    public void invalidate() {
        this.dafData = null;
        this.userValue = null;
        this.pid = "0";
        ArrayNameAndIndex ari = ParameterTableEditorItem.getArrayIndexFromPath(this.path);
        if (ari.getIndex() == 0) {
            this.setPath(String.valueOf(ari.getArrayName()) + "." + "Leer" + "." + ari.getRestPfad());
        }
    }

    public String getAttributeName() {
        return this.attributeName;
    }

    public void setAttributeName(String attributeName) {
        this.attributeName = attributeName;
    }

    public List<Attribute> getFeldAttribute() {
        return this.feldAttribute;
    }
}

