/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.buv.plugin.param.editors.standard;

import de.bsvrz.buv.plugin.param.editors.ParameterEditorInput;
import de.bsvrz.buv.plugin.param.editors.ParameterEditorSaveMode;
import de.bsvrz.buv.plugin.param.editors.ParameterSaveResultEnum;
import de.bsvrz.buv.plugin.param.editors.ParameterSaver;
import de.bsvrz.buv.plugin.param.editors.helper.ParaEditComposite;
import de.bsvrz.buv.plugin.param.editors.standard.StandardParamEditorFormPage;
import de.bsvrz.buv.plugin.param.editors.standard.StandardParamEditorPlugin;
import de.bsvrz.puk.param.lib.Parameter;
import de.bsvrz.puk.param.lib.ParameterClientException;
import java.util.ArrayList;
import org.eclipse.core.runtime.Assert;
import org.eclipse.ui.forms.AbstractFormPart;
import org.eclipse.ui.forms.editor.IFormPage;

public class ParaEditCompositeFormPart
extends AbstractFormPart {
    private final ParaEditComposite[] paraEditComposites;
    private final boolean readOnly;

    public ParaEditCompositeFormPart(ParaEditComposite[] paraEditComposites, boolean readOnly) {
        this.paraEditComposites = paraEditComposites;
        this.readOnly = readOnly;
        Assert.isNotNull((Object)paraEditComposites);
    }

    public void commit(boolean onSave) {
        ParaEditComposite pec;
        int loop;
        if (!onSave) {
            return;
        }
        if (this.readOnly) {
            super.commit(onSave);
            return;
        }
        StandardParamEditorFormPage page = (StandardParamEditorFormPage)((Object)this.getManagedForm().getContainer());
        ParameterEditorSaveMode saveMode = page.getParameterEditorInput().getSaveMode();
        Parameter[] editedParameters = null;
        switch (saveMode) {
            case ALL: {
                editedParameters = new Parameter[this.paraEditComposites.length];
                loop = 0;
                while (loop < this.paraEditComposites.length) {
                    ParaEditComposite pec2 = this.paraEditComposites[loop];
                    editedParameters[loop] = pec2.getEditedParameter();
                    ++loop;
                }
                break;
            }
            case ONLY_MODIFIED: {
                ArrayList<Parameter> parameterToSave = new ArrayList<Parameter>(this.paraEditComposites.length);
                loop = 0;
                while (loop < this.paraEditComposites.length) {
                    pec = this.paraEditComposites[loop];
                    if (pec.isDirty()) {
                        parameterToSave.add(pec.getEditedParameter());
                    }
                    ++loop;
                }
                editedParameters = parameterToSave.toArray(new Parameter[parameterToSave.size()]);
                break;
            }
        }
        Assert.isNotNull((Object)editedParameters, (String)("Die zu speichernden Parameter konnten nicht bestimmt werden.\nVerwendeter Save Mode: " + saveMode));
        ParameterSaveResultEnum saveResult = ParameterSaver.saveParameters((Parameter[])editedParameters, (String)ParameterSaver.buildDefaultUrsache((Parameter[])editedParameters, (Parameter[])editedParameters, (ParameterSaver.ParameterSaveUrsache)ParameterSaver.ParameterSaveUrsache.PARAMETRIERT));
        switch (saveResult) {
            case PARAMETER_SAVE_FAILURE: {
                throw new IllegalStateException(ParameterSaver.getLastError());
            }
            case PARAMETER_SAVE_CANCEL: {
                break;
            }
            case PARAMETER_SAVE_SUCCESS: {
                super.commit(onSave);
                this.getManagedForm().dirtyStateChanged();
                loop = 0;
                while (loop < this.paraEditComposites.length) {
                    pec = this.paraEditComposites[loop];
                    pec.markSaved();
                    ++loop;
                }
                break;
            }
            default: {
                throw new IllegalStateException("Resultat von Speichern nicht bestimmbar");
            }
        }
    }

    public void markStale() {
        ParameterEditorInput editorInput;
        if (!this.readOnly) {
            return;
        }
        IFormPage formPage = (IFormPage)this.getManagedForm().getContainer();
        if (1 == formPage.getIndex()) {
            editorInput = (ParameterEditorInput)formPage.getEditorInput();
            try {
                editorInput.sollParameterAbfragen();
                super.markStale();
                Parameter[] neueSollParameter = editorInput.getSollParameters();
                int loop = 0;
                while (loop < this.paraEditComposites.length) {
                    this.paraEditComposites[loop].showData(new Parameter[]{neueSollParameter[loop]}, false);
                    StandardParamEditorPlugin.getDefault().getLogger().warning("Parameter " + neueSollParameter[loop].getInfo() + " enth\u00e4lt keine Daten. \u00dcberpr\u00fcfen Sie die Parametrierung der Parametrierung.");
                    ++loop;
                }
            }
            catch (ParameterClientException e) {
                StandardParamEditorPlugin.getDefault().getLogger().error("Fehler bei Aktualisierung der Soll-Parameter", (Throwable)e);
            }
        }
        if (3 == formPage.getIndex()) {
            editorInput = (ParameterEditorInput)formPage.getEditorInput();
            editorInput.istParameterAbfragen();
            super.markStale();
            Parameter[] neueIstParameter = editorInput.getIstParameters();
            int loop = 0;
            while (loop < this.paraEditComposites.length) {
                this.paraEditComposites[loop].showData(new Parameter[]{neueIstParameter[loop]}, false);
                ++loop;
            }
        }
    }

    public void markDirty() {
        if (this.readOnly) {
            return;
        }
        IFormPage formPage = (IFormPage)this.getManagedForm().getContainer();
        ParameterEditorInput editorInput = (ParameterEditorInput)formPage.getEditorInput();
        for (Integer index : editorInput.getSelectedParameters()) {
            ParaEditComposite tableItem = this.paraEditComposites[index];
            if (tableItem == null) continue;
            tableItem.fireExternalModificationEvent();
        }
        super.markDirty();
    }

    public void refresh() {
        StandardParamEditorFormPage formPage = (StandardParamEditorFormPage)((Object)this.getManagedForm().getContainer());
        ParameterEditorInput pei = (ParameterEditorInput)formPage.getEditorInput();
        Parameter[] parameters = null;
        switch (formPage.getIndex()) {
            case 0: {
                parameters = pei.getParameters();
                break;
            }
            case 1: {
                parameters = pei.getSollParameters();
                break;
            }
            case 2: {
                parameters = pei.getDefaultParameters();
                break;
            }
            case 3: {
                parameters = pei.getIstParameters();
                break;
            }
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Index " + formPage.getIndex() + " wird nicht unterst\u00fctzt.\n" + "G\u00fcltige Indices sind von 0 bis 3");
        }
        int loop = 0;
        while (loop < this.paraEditComposites.length) {
            if (pei.getSelectedParameters().contains(loop)) {
                this.paraEditComposites[loop].showData(new Parameter[]{parameters[loop]}, true);
            }
            ++loop;
        }
        boolean globalDirtyState = false;
        loop = 0;
        while (loop < this.paraEditComposites.length) {
            if (this.paraEditComposites[loop].isDirty()) {
                globalDirtyState = true;
                break;
            }
            ++loop;
        }
        if (this.getManagedForm().isDirty() != globalDirtyState) {
            super.refresh();
            this.getManagedForm().dirtyStateChanged();
        }
    }

    public void dispose() {
        ParaEditComposite[] paraEditCompositeArray = this.paraEditComposites;
        int n = this.paraEditComposites.length;
        int n2 = 0;
        while (n2 < n) {
            ParaEditComposite pec = paraEditCompositeArray[n2];
            pec.dispose();
            ++n2;
        }
    }

    public ParaEditComposite[] getParaEditComposites() {
        return this.paraEditComposites;
    }
}

