/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.buv.plugin.param.editors.standard;

import de.bsvrz.buv.plugin.param.editors.AbstractParameterFormPage;
import de.bsvrz.buv.plugin.param.editors.ParameterEditor;
import de.bsvrz.buv.plugin.param.editors.ParameterEditorInput;
import de.bsvrz.buv.plugin.param.editors.helper.IParaEditCompositeContainer;
import de.bsvrz.buv.plugin.param.editors.helper.MyTreeObject;
import de.bsvrz.buv.plugin.param.editors.helper.ParaEditComposite;
import de.bsvrz.buv.plugin.param.editors.helper.TableTreeLabelProvider;
import de.bsvrz.buv.plugin.param.editors.standard.ParaEditCompositeFormPart;
import de.bsvrz.buv.plugin.param.editors.standard.actions.ExportTreeEditorToCSVorHTMLAction;
import de.bsvrz.buv.rw.basislib.printing.RwPrintable;
import de.bsvrz.dav.daf.main.Data;
import de.bsvrz.dav.daf.main.config.AttributeType;
import de.bsvrz.dav.daf.main.config.DoubleAttributeType;
import de.bsvrz.dav.daf.main.config.IntegerAttributeType;
import de.bsvrz.dav.daf.main.config.ReferenceAttributeType;
import de.bsvrz.dav.daf.main.config.StringAttributeType;
import de.bsvrz.dav.daf.main.config.SystemObject;
import de.bsvrz.dav.daf.main.config.TimeAttributeType;
import de.bsvrz.puk.param.lib.Parameter;
import de.bsvrz.sys.funclib.debug.Debug;
import java.util.List;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.nebula.paperclips.core.BigPrint;
import org.eclipse.nebula.paperclips.core.ImagePrint;
import org.eclipse.nebula.paperclips.core.Print;
import org.eclipse.nebula.paperclips.core.border.Border;
import org.eclipse.nebula.paperclips.core.border.LineBorder;
import org.eclipse.nebula.paperclips.core.grid.CellBackgroundProvider;
import org.eclipse.nebula.paperclips.core.grid.DefaultGridLook;
import org.eclipse.nebula.paperclips.core.grid.GridColumn;
import org.eclipse.nebula.paperclips.core.grid.GridLook;
import org.eclipse.nebula.paperclips.core.grid.GridPrint;
import org.eclipse.nebula.paperclips.core.page.PagePrint;
import org.eclipse.nebula.paperclips.core.text.TextPrint;
import org.eclipse.nebula.paperclips.core.text.TextStyle;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.ui.forms.AbstractFormPart;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.events.ExpansionAdapter;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;

public class StandardParamEditorFormPage
extends AbstractParameterFormPage
implements IParaEditCompositeContainer,
RwPrintable {
    private static final Debug DEBUG = Debug.getLogger();
    public static final String[] VALID_INDICES = new String[]{"Vorgabe", "Soll", "Default", "Ist"};

    public StandardParamEditorFormPage(FormEditor editor, String id, int index) {
        super(editor, id, VALID_INDICES[index]);
    }

    protected void createFormContent(IManagedForm managedForm) {
        ScrolledForm form = managedForm.getForm();
        FormToolkit toolkit = managedForm.getToolkit();
        TableWrapLayout layout = new TableWrapLayout();
        form.getBody().setLayout((Layout)layout);
        layout.numColumns = 2;
        this.updateFormText();
        ParameterEditorInput pei = (ParameterEditorInput)this.getEditorInput();
        Parameter[] parameters = pei.getParameters();
        Parameter[] sollParameters = pei.getSollParameters();
        Parameter[] defaultParameters = pei.getDefaultParameters();
        Parameter[] istParameters = pei.getIstParameters();
        ParaEditComposite[] paraEditComposites = new ParaEditComposite[parameters.length];
        int loop = 0;
        boolean readOnly = this.getIndex() > 0;
        Parameter[] parameterArray = parameters;
        int n = parameters.length;
        int n2 = 0;
        while (n2 < n) {
            Parameter p = parameterArray[n2];
            Parameter[] results = new Parameter[1];
            Parameter korrespondierenderSollParameter = sollParameters[loop];
            if (this.getIndex() == 0) {
                results[0] = p;
            } else if (1 == this.getIndex()) {
                results[0] = korrespondierenderSollParameter;
            } else if (2 == this.getIndex()) {
                results[0] = defaultParameters[loop];
            } else if (3 == this.getIndex()) {
                results[0] = istParameters[loop];
            }
            paraEditComposites[loop++] = this.erzeugeAbschnittDaten(form, toolkit, results, readOnly);
            ++n2;
        }
        ParaEditCompositeFormPart formPart = new ParaEditCompositeFormPart(paraEditComposites, readOnly);
        ParaEditComposite[] paraEditCompositeArray = paraEditComposites;
        int n3 = paraEditComposites.length;
        n = 0;
        while (n < n3) {
            ParaEditComposite pec = paraEditCompositeArray[n];
            pec.setFormPart((AbstractFormPart)formPart);
            ++n;
        }
        managedForm.addPart((IFormPart)formPart);
        IToolBarManager toolBarManager = form.getToolBarManager();
        ExportTreeEditorToCSVorHTMLAction exportAction = new ExportTreeEditorToCSVorHTMLAction(formPart);
        exportAction.setTitleText(((ParameterEditor)this.getEditor()).getDefaultHeader(true));
        toolBarManager.add((IAction)exportAction);
        toolBarManager.update(true);
        this.setExportAction((IAction)exportAction);
        super.createFormContent(managedForm);
    }

    private ParaEditComposite erzeugeAbschnittDaten(final ScrolledForm form, FormToolkit toolkit, Parameter[] results, boolean readOnly) {
        Section sektion = toolkit.createSection(form.getBody(), 450);
        TableWrapData td = new TableWrapData(256);
        td.colspan = 2;
        sektion.setLayoutData((Object)td);
        sektion.setText("Objekt: " + results[0].getObjekt().toString());
        sektion.setDescription("In diesem Abschnitt erfolgt das Editieren des Objektes " + results[0].getObjekt().toString());
        sektion.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

            public void expansionStateChanged(ExpansionEvent e) {
                form.reflow(true);
            }
        });
        return new ParaEditComposite(toolkit, sektion, results, null, (IParaEditCompositeContainer)this, readOnly);
    }

    public void updateFormText() {
        IManagedForm managedForm = this.getManagedForm();
        ScrolledForm form = managedForm.getForm();
        ParameterEditorInput pei = (ParameterEditorInput)this.getEditorInput();
        StringBuilder b = new StringBuilder();
        Parameter[] parameters = pei.getParameters();
        b.append(parameters.length);
        b.append(" Objekt");
        if (parameters.length > 1) {
            b.append('e');
        }
        b.append(" in Bearbeitung");
        form.setText(b.toString());
    }

    public void dirtyStateChanged(ParaEditComposite pec, boolean status) {
        if (status) {
            this.getEditor().editorDirtyStateChanged();
        }
    }

    public void valueModified(ParaEditComposite pec, MyTreeObject myTreeObject, Object oldValue, Object newValue, AttributeType attributeType) {
        ParaEditCompositeFormPart formPart = null;
        IFormPart[] iFormPartArray = this.getManagedForm().getParts();
        int n = iFormPartArray.length;
        int n2 = 0;
        while (n2 < n) {
            IFormPart part0 = iFormPartArray[n2];
            if (part0 instanceof ParaEditCompositeFormPart) {
                formPart = (ParaEditCompositeFormPart)part0;
                break;
            }
            ++n2;
        }
        if (formPart != null && myTreeObject.getData() instanceof Data) {
            this.handleAttributePropagation(pec, myTreeObject, newValue, attributeType, formPart);
        }
    }

    private void handleAttributePropagation(ParaEditComposite pec, MyTreeObject myTreeObject, Object newValue, AttributeType attributeType, ParaEditCompositeFormPart formPart) {
        switch (this.getParameterEditorInput().getAttributePropagationMode()) {
            case ONLY_EDITED: {
                return;
            }
            case EDITED_AND_SELECTION: {
                throw new UnsupportedOperationException("Attributpropagierung auf Auswahl wird nicht unterst\u00fctzt");
            }
            case ALL: {
                break;
            }
        }
        String path = myTreeObject.getFullPath();
        ParaEditComposite[] paraEditCompositeArray = formPart.getParaEditComposites();
        int n = paraEditCompositeArray.length;
        int n2 = 0;
        while (n2 < n) {
            MyTreeObject matchedMyTreeObject;
            ParaEditComposite currentPec = paraEditCompositeArray[n2];
            if (currentPec != pec && (matchedMyTreeObject = currentPec.getMyTreeObjectForPath(path)).getData() instanceof Data) {
                Data matchData = (Data)matchedMyTreeObject.getData();
                if (attributeType instanceof IntegerAttributeType) {
                    matchData.asUnscaledValue().set(((Long)newValue).longValue());
                } else if (attributeType instanceof DoubleAttributeType) {
                    matchData.asUnscaledValue().set(((Double)newValue).doubleValue());
                } else if (attributeType instanceof StringAttributeType) {
                    matchData.asTextValue().setText((String)newValue);
                } else if (attributeType instanceof TimeAttributeType) {
                    matchData.asUnscaledValue().set(((Long)newValue).longValue());
                } else if (attributeType instanceof ReferenceAttributeType) {
                    matchData.asReferenceValue().setSystemObject((SystemObject)newValue);
                }
                currentPec.fireExternalModificationEvent();
                DEBUG.finer("Objekt modifiziert:", (Object)matchedMyTreeObject);
            }
            ++n2;
        }
    }

    public ParameterEditorInput getParameterEditorInput() {
        return (ParameterEditorInput)this.getEditorInput();
    }

    private GridPrint getGridPrint(ParaEditComposite pec) {
        TreeViewer viewer = pec.getTreeViewer();
        Tree tree = viewer.getTree();
        final TableTreeLabelProvider labelAndColorProvider = (TableTreeLabelProvider)viewer.getLabelProvider();
        FontData systemFontData = tree.getDisplay().getSystemFont().getFontData()[0];
        final List flatList = pec.getMediatorDataObject().getFlatList();
        GridPrint tabelle = new GridPrint();
        DefaultGridLook look = new DefaultGridLook();
        look.setHeaderBackground(new RGB(200, 200, 200));
        look.setBodyBackgroundProvider(new CellBackgroundProvider(){
            private final RGB white = new RGB(255, 255, 255);

            public RGB getCellBackground(int row, int column, int colspan) {
                MyTreeObject item = (MyTreeObject)flatList.get(row);
                Color bColor = labelAndColorProvider.getBackground((Object)item, column);
                if (bColor == null) {
                    return this.white;
                }
                return bColor.getRGB();
            }
        });
        TextStyle defaultTextStyle = new TextStyle();
        TextStyle headerStyle = defaultTextStyle.font(systemFontData.getName(), systemFontData.getHeight(), 1);
        defaultTextStyle = defaultTextStyle.font(systemFontData.getName(), systemFontData.getHeight(), 0);
        look.setCellBorder((Border)new LineBorder(new RGB(0, 0, 0)));
        tabelle.setLook((GridLook)look);
        int numColumns = tree.getColumns().length;
        int loop = 0;
        while (loop < numColumns) {
            TreeColumn column = tree.getColumns()[loop];
            GridColumn gridColumn = new GridColumn(16384, (2 + loop * 3) * 95, 1 + loop * 2);
            tabelle.addColumn(gridColumn);
            tabelle.addHeader((Print)headerStyle.create(column.getText()));
            ++loop;
        }
        List ebeneList = pec.getMediatorDataObject().getEbeneList();
        int numItems = flatList.size();
        loop = 0;
        while (loop < numItems) {
            MyTreeObject myTreeObject = (MyTreeObject)flatList.get(loop);
            int ebene = (Integer)ebeneList.get(loop);
            this.addTreeItem(numColumns, tabelle, defaultTextStyle, myTreeObject, ebene, labelAndColorProvider);
            ++loop;
        }
        return tabelle;
    }

    private void addTreeItem(int numColumns, GridPrint tabelle, TextStyle defaultTextStyle, MyTreeObject myTreeObject, int ebene, TableTreeLabelProvider labelAndColorProvider) {
        int colIdx = 0;
        while (colIdx < numColumns) {
            GridPrint gridForTable;
            Data myTreeObjectData;
            String colText = labelAndColorProvider.getColumnText((Object)myTreeObject, colIdx);
            Image image = labelAndColorProvider.getColumnImage((Object)myTreeObject, colIdx);
            StringBuilder realColText = new StringBuilder();
            if (colIdx == 0 && myTreeObject.getData() instanceof Data && (myTreeObjectData = (Data)myTreeObject.getData()).isArray()) {
                if (myTreeObject.hasChildren()) {
                    realColText.append("+ ");
                } else {
                    realColText.append("- ");
                }
            }
            GridPrint gridWithLeftPadding = new GridPrint();
            if (colIdx == 0) {
                DefaultGridLook combinedLook = new DefaultGridLook();
                combinedLook.setCellPadding(10 * ebene, 0, 3, 0);
                gridWithLeftPadding.setLook((GridLook)combinedLook);
            }
            gridWithLeftPadding.addColumn(new GridColumn(16384, -1, 0));
            if (image != null) {
                gridForTable = new GridPrint();
                gridForTable.addColumn(new GridColumn(16384, -1, 0));
                gridForTable.addColumn(new GridColumn(16384, -1, 0));
                gridWithLeftPadding.add(16384, 0x1000000, (Print)new ImagePrint(image.getImageData()));
                gridForTable.add((Print)gridWithLeftPadding);
                TextPrint tPrint = defaultTextStyle.create(colText);
                gridForTable.add(16384, 0x1000000, (Print)tPrint);
            } else {
                realColText.append(colText);
                String realColTextStr = realColText.toString();
                TextPrint tPrint = defaultTextStyle.create(realColTextStr);
                gridWithLeftPadding.add(16384, 0x1000000, (Print)tPrint);
                gridForTable = gridWithLeftPadding;
            }
            tabelle.add((Print)gridForTable);
            ++colIdx;
        }
    }

    public PagePrint getDruckAuftrag() {
        String header = ((ParameterEditor)this.getEditor()).getDefaultHeader(false);
        ParaEditCompositeFormPart formPart = null;
        IFormPart[] iFormPartArray = this.getManagedForm().getParts();
        int n = iFormPartArray.length;
        int n2 = 0;
        while (n2 < n) {
            IFormPart part0 = iFormPartArray[n2];
            if (part0 instanceof ParaEditCompositeFormPart) {
                formPart = (ParaEditCompositeFormPart)part0;
                break;
            }
            ++n2;
        }
        FontData systemFontData = Display.getDefault().getSystemFont().getFontData()[0];
        GridPrint mainGrid = new GridPrint();
        mainGrid.addColumn(new GridColumn(16384, -1, 0));
        mainGrid.add((Print)new TextPrint(header, new FontData(systemFontData.getName(), systemFontData.getHeight() + 2, 1)));
        DefaultGridLook mainLook = new DefaultGridLook();
        mainLook.setCellSpacing(0, systemFontData.getHeight());
        mainGrid.setLook((GridLook)mainLook);
        TextStyle objectTextStyle = new TextStyle().font(new FontData(systemFontData.getName(), systemFontData.getHeight() + 1, 1));
        if (formPart != null) {
            ParaEditComposite[] paraEditCompositeArray = formPart.getParaEditComposites();
            int n3 = paraEditCompositeArray.length;
            int n4 = 0;
            while (n4 < n3) {
                ParaEditComposite pec = paraEditCompositeArray[n4];
                GridPrint pecGrid = new GridPrint();
                pecGrid.addColumn(new GridColumn(16384, -1, 0));
                DefaultGridLook pecLook = new DefaultGridLook();
                pecLook.setCellSpacing(0, systemFontData.getHeight() / 4);
                pecGrid.setLook((GridLook)pecLook);
                SystemObject o = pec.getEditedParameter().getObjekt();
                String objectTitle = "Objekt: " + o.toString();
                pecGrid.add((Print)objectTextStyle.create(objectTitle));
                GridPrint tabelle = this.getGridPrint(pec);
                pecGrid.add((Print)tabelle);
                mainGrid.add((Print)pecGrid);
                ++n4;
            }
        }
        return new PagePrint((Print)new BigPrint((Print)mainGrid));
    }

    public String getTitel() {
        return null;
    }
}

