/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.buv.plugin.param.editors.standard.actions;

import com.bitctrl.lib.eclipse.actions.AbstractCopyTableAction;
import de.bsvrz.buv.plugin.param.editors.helper.MyDataObject;
import de.bsvrz.buv.plugin.param.editors.helper.MyTreeObject;
import de.bsvrz.buv.plugin.param.editors.helper.ParaEditComposite;
import de.bsvrz.buv.plugin.param.editors.helper.TableTreeLabelProvider;
import de.bsvrz.buv.plugin.param.editors.standard.ParaEditCompositeFormPart;
import de.bsvrz.dav.daf.main.config.SystemObject;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;

public class ExportTreeEditorToCSVorHTMLAction
extends AbstractCopyTableAction {
    private static final String LINEBREAK = "\r\n";
    private static String title = "";
    private static final String HTML_HEADER_START = "<html xmlns=\"http://www.w3.org/1999/xhtml\"><head><meta http-equiv=\"content-type\" content=\"text/html;charset=ISO-8859-1\"/><title>";
    private static final String HTML_HEADER_ENDE = "</title></head><body>";
    private static final String HTML_FOOTER = "</body></html>";
    private final ParaEditCompositeFormPart treeEditorFormPart;

    public ExportTreeEditorToCSVorHTMLAction(ParaEditCompositeFormPart treeEditorFormPart) {
        this.treeEditorFormPart = treeEditorFormPart;
        Assert.isNotNull((Object)((Object)treeEditorFormPart));
        Assert.isTrue((treeEditorFormPart.getParaEditComposites().length > 0 ? 1 : 0) != 0);
        this.setToolTipText("Exportiert den Baumeditor nach CSV oder HTML");
    }

    public void run() {
        ParaEditComposite[] pecs = this.treeEditorFormPart.getParaEditComposites();
        Control control = pecs[0].getTreeViewer().getControl();
        if (control != null && !control.isDisposed()) {
            this.exportToFile(control.getDisplay());
        }
    }

    public void setTitleText(String neuerTitle) {
        title = neuerTitle != null ? neuerTitle : "";
    }

    private String getHeader(AbstractCopyTableAction.MainTag main) {
        TreeColumn[] columns;
        ParaEditComposite pec = this.treeEditorFormPart.getParaEditComposites()[0];
        StringBuffer text = new StringBuffer();
        TreeViewer treeViewer = pec.getTreeViewer();
        Tree tree = treeViewer.getTree();
        TreeColumn[] treeColumnArray = columns = tree.getColumns();
        int n = columns.length;
        int n2 = 0;
        while (n2 < n) {
            TreeColumn column = treeColumnArray[n2];
            text.append(main.head.row.data.getBegin());
            String content = column.getText();
            text.append(main.mask(content));
            text.append(main.head.row.data.getEnd());
            ++n2;
        }
        return text.toString();
    }

    private String getContent(AbstractCopyTableAction.MainTag main, ParaEditComposite pec) {
        StringBuffer text = new StringBuffer();
        TreeViewer treeViewer = pec.getTreeViewer();
        TableTreeLabelProvider labelAndColorProvider = (TableTreeLabelProvider)treeViewer.getLabelProvider();
        Tree tree = treeViewer.getTree();
        TreeColumn[] columns = tree.getColumns();
        MyDataObject mediator = pec.getMediatorDataObject();
        List flatList = mediator.getFlatList();
        int numColumns = columns.length;
        List ebeneList = pec.getMediatorDataObject().getEbeneList();
        int numItems = flatList.size();
        int loop = 0;
        while (loop < numItems) {
            text.append(main.body.row.getBegin());
            MyTreeObject myTreeObject = (MyTreeObject)flatList.get(loop);
            int ebene = (Integer)ebeneList.get(loop);
            int colIdx = 0;
            while (colIdx < numColumns) {
                text.append(main.body.row.data.getBegin());
                String content = labelAndColorProvider.getColumnText((Object)myTreeObject, colIdx);
                if (colIdx == 0) {
                    int ebeneLoop = ebene;
                    while (ebeneLoop-- > 0) {
                        text.append("  ");
                    }
                    if (myTreeObject.hasChildren()) {
                        text.append("Knoten:");
                    } else {
                        text.append("Blatt:");
                    }
                }
                text.append(main.mask(content));
                text.append(main.body.row.data.getEnd());
                ++colIdx;
            }
            text.append(main.body.row.getEnd());
            ++loop;
        }
        return text.toString();
    }

    protected String getTextForSelection(AbstractCopyTableAction.MainTag main) {
        ParaEditComposite[] pecs = this.treeEditorFormPart.getParaEditComposites();
        StringBuffer text = new StringBuffer();
        text.append(main.getBegin());
        text.append(main.head.getBegin());
        text.append(main.head.row.getBegin());
        text.append(this.getHeader(main));
        text.append(main.head.row.getEnd());
        text.append(main.head.getEnd());
        text.append(main.body.getBegin());
        ParaEditComposite[] paraEditCompositeArray = pecs;
        int n = pecs.length;
        int n2 = 0;
        while (n2 < n) {
            ParaEditComposite pec = paraEditCompositeArray[n2];
            SystemObject systemObject = pec.getEditedParameter().getObjekt();
            text.append(main.body.row.getBegin());
            text.append(main.body.row.data.getBegin());
            text.append(main.mask("Objekt:" + systemObject.getPidOrId()));
            text.append(main.body.row.data.getEnd());
            text.append(main.body.row.data.getBegin());
            text.append(main.mask(systemObject.getNameOrPidOrId()));
            text.append(main.body.row.data.getEnd());
            text.append(main.body.row.getEnd());
            text.append(this.getContent(main, pec));
            ++n2;
        }
        text.append(main.body.getEnd());
        text.append(main.getEnd());
        return text.toString();
    }

    protected void exportToFile(Display display) {
        FileDialog fd = new FileDialog(display.getActiveShell(), 8192);
        fd.setFilterExtensions(new String[]{".csv", ".html"});
        String newFilePath = fd.open();
        if (newFilePath == null) {
            return;
        }
        try {
            if (!this.checkFileExists(display, newFilePath)) {
                return;
            }
            File f = new File(newFilePath);
            FileOutputStream fo = new FileOutputStream(f);
            OutputStreamWriter ouw = new OutputStreamWriter((OutputStream)fo, "ISO-8859-1");
            String text = "";
            if (newFilePath.endsWith("csv".toLowerCase())) {
                text = this.getTextForSelection(CSV);
                ouw.write("#" + title + LINEBREAK + text);
            } else if (newFilePath.endsWith("html".toLowerCase())) {
                text = this.getTextForSelection(HTML);
                ouw.write(HTML_HEADER_START + title + HTML_HEADER_ENDE + text + HTML_FOOTER);
            } else {
                text = this.getTextForSelection(TEXT);
                ouw.write(String.valueOf(title) + LINEBREAK + text);
            }
            ouw.close();
            fo.close();
        }
        catch (FileNotFoundException e) {
            MessageDialog.openError((Shell)display.getActiveShell(), (String)"Fehler beim Export", (String)e.getLocalizedMessage());
        }
        catch (IOException e) {
            MessageDialog.openError((Shell)display.getActiveShell(), (String)"Fehler beim Export", (String)e.getLocalizedMessage());
        }
    }

    private boolean checkFileExists(Display display, String newFilePath) {
        boolean ok = true;
        File f = new File(newFilePath);
        if (f.exists() && (ok = MessageDialog.openQuestion((Shell)display.getActiveShell(), (String)("Die Datei " + newFilePath + " existiert bereits"), (String)("Die Datei " + newFilePath + " existiert bereits. M\u00f6chten Sie diese \u00fcberschreiben?")))) {
            f.delete();
        }
        return ok;
    }
}

