/*
 * Rahmenwerk-Plug-in "Parametrierung"
 * Copyright (C) 2018 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.buv.plugin.param.imex;

import de.bsvrz.buv.plugin.param.imex.internal.RahmenwerkService;
import de.bsvrz.buv.plugin.param.internal.ParamPlugin;
import de.bsvrz.buv.rw.basislib.berechtigung.Berechtigungen;
import de.bsvrz.buv.rw.basislib.berechtigung.FunktionMitBerechtigung;

/**
 * Die Definition der Funktionen, für die Berechtigungen innerhalb des
 * Rahmenwerkes festgelegt werden können. Die Funktionen sind erst ausführbar,
 * nachdem das Plug-in aktiviert wurde. (Definiert per plugin.xml)
 *
 * @author BitCtrl Systems GmbH, Uwe Peuker
 *
 *
 */
public enum ParamImExFunktion {

	/** Exportieren von Parametern. */
	EXPORTIEREN("ParamImExFunktion.exportieren"),

	/** Importieren von Parametern. */
	IMPORTIEREN("ParamImExFunktion.importieren");

	/** die ID mit der Funktion registriert wird. */
	private String id;

	/**
	 * Konstruktor, erzeugt eine Funktionsdefinition mit der gegebenen ID.
	 *
	 * Die ID wird über den Extension-Point um die Plugin-ID erweitert (Präfix),
	 * deshalb wird diese hier ergänzt.
	 *
	 * @param id
	 *            die ID
	 */
	private ParamImExFunktion(final String id) {
		this.id = ParamPlugin.PLUGIN_ID + "." + id;
	}

	/**
	 * liefert die Funktion aus der Berechtigungsverwaltung.
	 *
	 * @return die Funktion oder <code>null</code>, wenn keine solche existiert
	 */
	public FunktionMitBerechtigung getFunktionMitBerechtigung() {
		return RahmenwerkService.getService().getBerechtigungen().getFunktion(id);
	}

	/**
	 * liefert die Id der Funktion.
	 *
	 * @return die Id
	 */
	public String getId() {
		return id;
	}

	/**
	 * liefert den Freigabestatus der Funktion für den angemeldeten Nutzer.
	 *
	 * @return den Status
	 */
	public boolean isFreigegeben() {
		final Berechtigungen berechtigungen = RahmenwerkService.getService().getBerechtigungen();
		return berechtigungen.hasBerechtigung(berechtigungen.getFunktion(id));
	}
}
