/*
 * Rahmenwerk-Plug-in "Parametrierung"
 * Copyright (C) 2018 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.buv.plugin.param.imex;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.ui.PlatformUI;

import de.bsvrz.buv.plugin.param.internal.ParamPlugin;

/**
 * Utility-Klasse für die einfache Ausgabe von Fehlermeldungen.
 *
 * @author BitCtrl Systems GmbH, Uwe Peuker
 *
 */
public final class ParameterImex {

	/** ID des Plugin-Fragments. */
	private static final String PLUGIN_ID = "de.bsvrz.buv.plugin.param.imex";

	/** Standardkonstruktor. */
	private ParameterImex() {
		// verhindert das Anlegen von Instanzen
	}

	/**
	 * gibt eine Logmeldung über den allgemeinen Plugin-Logger aus.
	 *
	 * @param severity
	 *            der Level der Meldung
	 * @param text
	 *            der Meldungstext
	 * @param exception
	 *            eine optionale Exception
	 */
	public static void log(final int severity, final String text, final Exception exception) {
		String meldungsText = text;
		if (meldungsText == null) {
			if (exception != null) {
				meldungsText = exception.getLocalizedMessage();
			} else {
				meldungsText = "";
			}
		}
		final Status status = new Status(severity, ParameterImex.PLUGIN_ID, meldungsText, exception);
		ParamPlugin.getDefault().getLog().log(status);
	}

	/**
	 * zeigt einen Fehlerdialog mit dem Meldungstext der übergebenen Exception an.
	 *
	 * @param exception
	 *            die Exception
	 */
	public static void zeigeFehler(final Exception exception) {
		ParameterImex.fehlerMeldung(null, exception);
		MessageDialog.openError(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), "FEHLER",
				exception.getLocalizedMessage());
	}

	/**
	 * zeigt einen Fehlerdialog mit übergebenen Meldungstext an.
	 *
	 * @param meldung
	 *            der Meldungstext
	 */
	public static void zeigeFehler(final String meldung) {
		ParameterImex.fehlerMeldung(meldung, null);
		MessageDialog.openError(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), "FEHLER", meldung);
	}

	/**
	 * gibt eine Fehlermeldung mit einem optionalen Stacktrace einer Exception über
	 * den Eclipse-Logger aus.
	 *
	 * @param text
	 *            der Text der Meldung
	 * @param exception
	 *            die optionale Ausnahme
	 */
	public static void fehlerMeldung(final String text, final Exception exception) {
		String msgText = text;
		if (text == null) {
			if (exception == null) {
				msgText = "Allgmeiner Fehler";
			} else {
				msgText = exception.getLocalizedMessage();
				if (msgText == null) {
					msgText = exception.getClass().getName();
				}
			}
		}
		ParameterImex.log(IStatus.ERROR, msgText, exception);
	}
}
