/*
 * Rahmenwerk-Plug-in "Parametrierung"
 * Copyright (C) 2018 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.buv.plugin.param.imex.wizards;

import org.eclipse.core.runtime.IAdaptable;

import de.bsvrz.buv.plugin.param.imex.internal.RahmenwerkService;
import de.bsvrz.buv.rw.basislib.Rahmenwerk;
import de.bsvrz.dav.daf.main.config.ConfigurationArea;
import de.bsvrz.dav.daf.main.config.ObjectTimeSpecification;
import de.bsvrz.dav.daf.main.config.SystemObject;
import de.bsvrz.dav.daf.main.config.SystemObjectType;
import de.bsvrz.puk.param.lib.Parameter;

/**
 * Wurzelknoten für die Darstellung des Baums mit den zu exportierenden
 * Datensätzen im Parameter-Export-Assistent.
 *
 * @author BitCtrl Systems GmbH, Uwe Peuker
 *
 */
class DavNode extends CheckableNode {

	/** Standardkonstruktor. */
	public DavNode() {
		super(RahmenwerkService.getService().getRahmenWerk());

		final Rahmenwerk rahmenwerk = RahmenwerkService.getService().getRahmenWerk();
		if (rahmenwerk.isOnline()) {
			for (final SystemObject obj : rahmenwerk.getDavVerbindung().getDataModel().getTypeTypeObject()
					.getElements()) {

				if (obj instanceof SystemObjectType) {
					final TypeNode node = new TypeNode((SystemObjectType) obj);
					if (node.getChildren().size() > 0) {
						addChild(node);
					}
				}
			}
		}
	}

	/**
	 * initialisiert den Markierungszustand der Knoten entsprechend dem übergebenen
	 * Objekt.
	 *
	 * @param object
	 *            das Objekt
	 */
	public void addInitialSelectionFor(final Object object) {

		if (object instanceof ConfigurationArea) {
			for (final Object kbObj : ((ConfigurationArea) object).getObjects(null, ObjectTimeSpecification.valid())) {
				initSelectionFor(kbObj);
			}
		} else if (object instanceof SystemObject) {
			initSelectionFor(object);
		} else if (object instanceof Parameter) {
			final CheckableNode node = findNode(((Parameter) object).getObjekt());
			if (node != null) {
				if (node instanceof TypeNode) {
					final CheckableNode parameterNode = ((TypeNode) node).getParameterNode();
					if (parameterNode != null) {
						parameterNode.initSelectionFor(((Parameter) object).getAtg());
					}
				} else {
					node.initSelectionFor(((Parameter) object).getAtg());
				}
			}
		} else if (object instanceof IAdaptable) {
			final Object adapter = ((IAdaptable) object).getAdapter(SystemObject.class);
			if (adapter != null) {
				initSelectionFor(adapter);
			}
		}

	}
}
