/*
 * Rahmenwerk-Plug-in "Parametrierung"
 * Copyright (C) 2018 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.buv.plugin.param.imex.wizards;

import de.bsvrz.dav.daf.main.config.AttributeGroup;
import de.bsvrz.dav.daf.main.config.SystemObject;

/**
 * Knoten für die Darstellung einer Objektinstanz im Baum für die Darstellung
 * der zu exportierenden Datensätze im Parameter-Export-Assistenten.
 *
 * @author BitCtrl Systems GmbH, Uwe Peuker
 *
 */
class InstanceNode extends CheckableNode {

	/**
	 * Konstruktor, erzeugt den Knoten für das übergebene Systemobjekt.
	 *
	 * @param obj
	 *            das Objekt
	 */
	public InstanceNode(final SystemObject obj) {
		super(obj);

		for (final AttributeGroup atg : obj.getType().getAttributeGroups()) {
			if (atg.isParameter()) {
				addChild(new ParameterSetNode(atg));
			}
		}
	}

	@Override
	public String toString() {
		return getValue().toString();
	}
}
