/*
 * Rahmenwerk-Plug-in "Parametrierung"
 * Copyright (C) 2018 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.buv.plugin.param.imex.wizards;

import java.util.ArrayList;
import java.util.Collection;

import org.eclipse.jface.viewers.ICheckStateProvider;
import org.eclipse.jface.viewers.ITableColorProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Color;

/**
 * Content-Provider für die Darstellung der Knoten im Baum für die Auswahl der
 * zu exportierenden Parameter-Datensätze.
 *
 * @author BitCtrl Systems GmbH, Uwe Peuker
 *
 */
public class ParameterExportNodeContentProvider
		implements ITreeContentProvider, ICheckStateProvider, ITableColorProvider {

	@Override
	public void dispose() {
		// keine Ressourcen freizugeben
	}

	@Override
	public Color getBackground(final Object element, final int columnIndex) {
		return null;
	}

	@Override
	public Object[] getChildren(final Object parentElement) {
		final Collection<Object> result = new ArrayList<>();
		if (parentElement instanceof CheckableNode) {
			result.addAll(((CheckableNode) parentElement).getChildren());
		}
		return result.toArray();
	}

	@Override
	public Object[] getElements(final Object inputElement) {
		return getChildren(inputElement);
	}

	@Override
	public Color getForeground(final Object element, final int columnIndex) {
		return null;
	}

	@Override
	public Object getParent(final Object element) {
		Object result = null;
		if (element instanceof CheckableNode) {
			result = ((CheckableNode) element).getParent();
		}
		return result;
	}

	@Override
	public boolean hasChildren(final Object element) {
		return getChildren(element).length > 0;
	}

	@Override
	public void inputChanged(final Viewer viewer, final Object oldInput, final Object newInput) {
		// keine spezielle Aktion erforderlich
	}

	@Override
	public boolean isChecked(final Object element) {
		boolean result = false;
		if (element instanceof CheckableNode) {
			result = ((CheckableNode) element).isChecked();
		}
		return result;
	}

	@Override
	public boolean isGrayed(final Object element) {
		boolean result = false;
		if (element instanceof CheckableNode) {
			result = ((CheckableNode) element).isGrayed();
		}
		return result;
	}
}
