/*
 * Rahmenwerk-Plug-in "Parametrierung"
 * Copyright (C) 2018 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.buv.plugin.param.imex.wizards;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.Map.Entry;
import java.util.Set;

import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.IExportWizard;
import org.eclipse.ui.IWorkbench;

import de.bsvrz.buv.plugin.param.imex.ParamImExFunktion;
import de.bsvrz.buv.plugin.param.imex.ParameterImex;
import de.bsvrz.buv.plugin.param.imex.internal.RahmenwerkService;
import de.bsvrz.buv.rw.basislib.Rahmenwerk;
import de.bsvrz.dav.daf.main.config.AttributeGroup;
import de.bsvrz.dav.daf.main.config.SystemObject;
import de.bsvrz.dav.daf.main.config.SystemObjectType;
import de.bsvrz.puk.param.lib.MethodenBibliothek;
import de.bsvrz.puk.param.lib.Parameter;
import de.bsvrz.puk.param.lib.ParameterClientException;
import de.bsvrz.puk.param.lib.ParameterInfo;
import de.bsvrz.puk.param.lib.SerializableParameter;
import de.bsvrz.sys.funclib.debug.Debug;

/**
 * Assistent zum Export von Parameterdaten.
 *
 * @author BitCtrl Systems GmbH, Uwe Peuker
 *
 */
public class ParameterExportWizard extends Wizard implements IExportWizard {

	/** die Seite zur Auswahl der zu exportierenden Daten. */
	private final ParameterExportSelectionPage selectionPage = new ParameterExportSelectionPage();

	@Override
	public void addPages() {
		super.addPages();
		addPage(selectionPage);
	}

	@Override
	public void init(final IWorkbench workbench, final IStructuredSelection selection) {
		// keine Initialisierung notwendig
	}

	@Override
	public boolean performFinish() {

		if (!ParamImExFunktion.EXPORTIEREN.isFreigegeben()) {
			ParameterImex.zeigeFehler("Sie haben keine Berechtigung zum Exportieren von Parametern!");
			return false;
		}

		boolean result = false;

		final String destName = selectionPage.getDestName();
		if (destName == null) {
			ParameterImex.zeigeFehler("Es wurde keine Zieldatei angegeben, in die die Daten exportiert werden sollen!");
			return false;
		}

		final File file = new File(destName);
		if (file.exists()) {
			if (!MessageDialog.openConfirm(getShell(), "Exportieren",
					"Soll die bestehende Datei: " + destName + "überschrieben werden?")) {
				return false;
			}
		}

		final Rahmenwerk rahmenwerk = RahmenwerkService.getService().getRahmenWerk();
		if (!rahmenwerk.isOnline()) {
			ParameterImex.zeigeFehler("Es besteht keine gültige Datenverteilerverbindung!");
			return false;
		}

		ObjectOutputStream stream = null;
		try {
			stream = new ObjectOutputStream(new FileOutputStream(file));

			for (final Entry<SystemObject, Set<AttributeGroup>> entry : selectionPage.getExportSelection().entrySet()) {

				final SystemObject object = entry.getKey();
				for (final AttributeGroup atg : entry.getValue()) {
					Parameter[] parameters;
					try {
						if (object instanceof SystemObjectType) {
							parameters = MethodenBibliothek.getParameterManager(rahmenwerk.getDavVerbindung())
									.getParameter(true, new ParameterInfo(object, (SystemObjectType) object, atg));
						} else {
							parameters = MethodenBibliothek.getParameterManager(rahmenwerk.getDavVerbindung())
									.getParameter(true, new ParameterInfo(object, atg));
						}
						for (final Parameter parameter : parameters) {
							stream.writeObject(new SerializableParameter(rahmenwerk.getDavVerbindung(), parameter));
						}
					} catch (final ParameterClientException e) {
						ParameterImex.zeigeFehler(e);
					}
				}

			}

			result = true;
		} catch (final FileNotFoundException e) {
			ParameterImex.zeigeFehler(e);
		} catch (final IOException e) {
			ParameterImex.zeigeFehler(e);
		} finally {
			if (stream != null) {
				try {
					stream.close();
				} catch (final IOException e) {
					// kann ignoriert werden
					Debug.getLogger().finest(e.getLocalizedMessage(), e);
				}
			}
		}

		return result;
	}
}
