/*
 * Rahmenwerk-Plug-in "Parametrierung"
 * Copyright (C) 2018 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.buv.plugin.param.imex.wizards;

import java.util.Map;
import java.util.Set;

import org.eclipse.jface.viewers.ITableColorProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.PlatformUI;

import de.bsvrz.dav.daf.main.config.SystemObject;
import de.bsvrz.puk.param.lib.Parameter;

/**
 * Darstellungsprovider für die Anzeige der importierbaren Datensätze im
 * Parameter-Import-Assistent.
 *
 * @author BitCtrl Systems GmbH, Uwe Peuker
 *
 */
public class ParameterImportSourceLabelProvider extends LabelProvider
		implements ITableLabelProvider, ITableColorProvider {

	@Override
	public Color getBackground(final Object element, final int columnIndex) {
		return null;
	}

	/**
	 * {@inheritDoc}
	 *
	 * Datensätze, die keine Daten enthalten werden mit einem roten Kreuz markiert.
	 *
	 * @see org.eclipse.jface.viewers.ITableLabelProvider#getColumnImage(java.lang.Object,
	 *      int)
	 */
	@Override
	public Image getColumnImage(final Object element, final int columnIndex) {

		Image result = null;

		if (columnIndex == 0) {
			if (element instanceof Map.Entry<?, ?>) {
				final Object key = ((Map.Entry<?, ?>) element).getKey();
				if (key instanceof Parameter) {
					final Parameter parameter = (Parameter) key;
					if (parameter.getData() == null) {
						result = PlatformUI.getWorkbench().getSharedImages().getImage(ISharedImages.IMG_ETOOL_DELETE);
					}
				}
			}
		}
		return result;
	}

	@Override
	public String getColumnText(final Object element, final int columnIndex) {
		String result = null;

		if (element instanceof Map.Entry<?, ?>) {
			final Object key = ((Map.Entry<?, ?>) element).getKey();
			if (key instanceof Parameter) {
				final Parameter parameter = (Parameter) key;
				SystemObject sysObj = null;
				switch (columnIndex) {
				case 0:
					sysObj = parameter.getObjekt();
					break;
				case 1:
					sysObj = parameter.getAtg();
					break;
				default:
					break;
				}

				if (sysObj != null) {
					result = sysObj.toString();
				}
			}
		}

		if (result == null) {
			result = "";
		}

		return result;
	}

	@Override
	public Color getForeground(final Object element, final int columnIndex) {

		Color result = null;

		if (element instanceof Map.Entry<?, ?>) {
			final Object value = ((Map.Entry<?, ?>) element).getValue();
			final Object key = ((Map.Entry<?, ?>) element).getKey();
			if (key instanceof Parameter) {
				final Parameter parameter = (Parameter) key;
				if (value instanceof Set<?>) {
					final int size = ((Set<?>) value).size();
					if (size > 1) {
						result = Display.getDefault().getSystemColor(SWT.COLOR_BLUE);
					} else if (size == 1) {
						final Object assignment = ((Set<?>) value).toArray()[0];
						if (parameter.getObjekt().equals(assignment)) {
							result = Display.getDefault().getSystemColor(SWT.COLOR_BLACK);
						} else {
							result = Display.getDefault().getSystemColor(SWT.COLOR_BLUE);
						}
					} else {
						result = Display.getDefault().getSystemColor(SWT.COLOR_GRAY);
					}
				}
			}
		}

		return result;
	}

}
